/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.gui;

import com.zuxelus.energycontrol.containers.ContainerTimer;
import com.zuxelus.energycontrol.gui.controls.CompactButton;
import com.zuxelus.energycontrol.network.NetworkHelper;
import com.zuxelus.energycontrol.tileentities.TileEntityTimer;
import com.zuxelus.zlib.gui.GuiContainerBase;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiTimer
extends GuiContainerBase {
    private static final ResourceLocation TEXTURE = new ResourceLocation("energycontrol", "textures/gui/gui_timer.png");
    private TileEntityTimer timer;
    private GuiTextField textboxTimer;
    private boolean lastIsWorking;

    public GuiTimer(ContainerTimer container) {
        super(container, "tile.timer.name", TEXTURE);
        this.field_146999_f = 100;
        this.field_147000_g = 136;
        this.timer = container.te;
        this.lastIsWorking = this.timer.getIsWorking();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.lastIsWorking = this.timer.getIsWorking();
        this.func_189646_b(new CompactButton(0, this.field_147003_i + 14, this.field_147009_r + 50, 34, 12, "+1"));
        this.func_189646_b(new CompactButton(1, this.field_147003_i + 14, this.field_147009_r + 64, 34, 12, "+10"));
        this.func_189646_b(new CompactButton(2, this.field_147003_i + 50, this.field_147009_r + 50, 34, 12, "+100"));
        this.func_189646_b(new CompactButton(3, this.field_147003_i + 50, this.field_147009_r + 64, 34, 12, "+1000"));
        this.func_189646_b(new CompactButton(4, this.field_147003_i + 14, this.field_147009_r + 78, 70, 12, "+10000"));
        this.func_189646_b(new CompactButton(5, this.field_147003_i + 14, this.field_147009_r + 36, 34, 12, "Reset"));
        this.func_189646_b(new CompactButton(6, this.field_147003_i + 50, this.field_147009_r + 36, 34, 12, "Ticks"));
        this.func_189646_b(new CompactButton(7, this.field_147003_i + 14, this.field_147009_r + 92, 70, 12, this.timer.getInvertRedstone() ? "No Redstone" : "Redstone"));
        this.func_189646_b(new CompactButton(8, this.field_147003_i + 14, this.field_147009_r + 106, 70, 12, this.lastIsWorking ? "Stop" : "Start"));
        this.updateCaptions(this.timer.getIsTicks());
        this.textboxTimer = new GuiTextField(11, this.field_146289_q, 20, 20, 58, 12);
        this.textboxTimer.func_146184_c(!this.lastIsWorking);
        this.textboxTimer.func_146195_b(!this.lastIsWorking);
        this.textboxTimer.func_146180_a(this.timer.getTimeString());
    }

    private void updateCaptions(boolean isTicks) {
        ((GuiButton)this.field_146292_n.get((int)0)).field_146126_j = isTicks ? "+1" : "+1s";
        ((GuiButton)this.field_146292_n.get((int)1)).field_146126_j = isTicks ? "+10" : "+30s";
        ((GuiButton)this.field_146292_n.get((int)2)).field_146126_j = isTicks ? "+100" : "+1m";
        ((GuiButton)this.field_146292_n.get((int)3)).field_146126_j = isTicks ? "+1000" : "+30m";
        ((GuiButton)this.field_146292_n.get((int)4)).field_146126_j = isTicks ? "+10000" : "+1h";
        ((GuiButton)this.field_146292_n.get((int)6)).field_146126_j = isTicks ? "Ticks" : "Time";
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.name, (this.field_146999_f - this.field_146289_q.func_78256_a(this.name)) / 2, 6, 0x404040);
        if (this.textboxTimer != null) {
            this.textboxTimer.func_146194_f();
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.textboxTimer != null) {
            this.textboxTimer.func_146178_a();
            boolean isWorking = this.timer.getIsWorking();
            if (isWorking != this.lastIsWorking) {
                this.textboxTimer.func_146184_c(!isWorking);
                this.textboxTimer.func_146195_b(!isWorking);
                ((GuiButton)this.field_146292_n.get((int)8)).field_146126_j = isWorking ? "Stop" : "Start";
                this.lastIsWorking = isWorking;
            }
            if (isWorking) {
                this.textboxTimer.func_146180_a(this.timer.getTimeString());
            }
        }
    }

    public void func_146281_b() {
        this.updateTime(0);
        super.func_146281_b();
    }

    private void updateTime(int delta) {
        if (this.textboxTimer == null) {
            return;
        }
        int time = 0;
        try {
            String value = this.textboxTimer.func_146179_b();
            if (this.timer.getIsTicks()) {
                if (!"".equals(value)) {
                    time = Integer.parseInt(value);
                }
            } else {
                String[] times = value.split(":");
                if (times.length == 2) {
                    time = (Integer.parseInt(times[0]) * 60 + Integer.parseInt(times[1])) * 20;
                }
                if (times.length == 3) {
                    time = (Integer.parseInt(times[0]) * 3600 + Integer.parseInt(times[1]) * 60 + Integer.parseInt(times[2])) * 20;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if ((time += delta) < 0) {
            time = 0;
        }
        if (time >= 1000000) {
            time = 1000000;
        }
        if (this.timer.getTime() != time) {
            NetworkHelper.updateSeverTileEntity(this.timer.func_174877_v(), 1, time);
            this.timer.setTime(time);
        }
        this.textboxTimer.func_146180_a(this.timer.getTimeString());
    }

    protected void func_146284_a(GuiButton button) {
        boolean isTicks = this.timer.getIsTicks();
        switch (button.field_146127_k) {
            case 0: {
                this.updateTime(isTicks ? 1 : 20);
                break;
            }
            case 1: {
                this.updateTime(isTicks ? 10 : 600);
                break;
            }
            case 2: {
                this.updateTime(isTicks ? 100 : 1200);
                break;
            }
            case 3: {
                this.updateTime(isTicks ? 1000 : 36000);
                break;
            }
            case 4: {
                this.updateTime(isTicks ? 10000 : 72000);
                break;
            }
            case 5: {
                NetworkHelper.updateSeverTileEntity(this.timer.func_174877_v(), 1, 0);
                this.timer.setTime(0);
                this.textboxTimer.func_146180_a(this.timer.getTimeString());
                break;
            }
            case 6: {
                NetworkHelper.updateSeverTileEntity(this.timer.func_174877_v(), 4, isTicks ? 0 : 1);
                this.timer.setIsTicks(!isTicks);
                this.textboxTimer.func_146180_a(this.timer.getTimeString());
                this.updateCaptions(!isTicks);
                break;
            }
            case 7: {
                boolean invertRedstone = this.timer.getInvertRedstone();
                NetworkHelper.updateSeverTileEntity(this.timer.func_174877_v(), 2, invertRedstone ? 0 : 1);
                this.timer.setInvertRedstone(!invertRedstone);
                ((GuiButton)this.field_146292_n.get((int)7)).field_146126_j = !invertRedstone ? "No Redstone" : "Redstone";
                break;
            }
            case 8: {
                this.updateTime(0);
                boolean isWorking = this.timer.getIsWorking();
                NetworkHelper.updateSeverTileEntity(this.timer.func_174877_v(), 3, isWorking ? 0 : 1);
                this.timer.setIsWorking(!isWorking);
                ((GuiButton)this.field_146292_n.get((int)8)).field_146126_j = !isWorking ? "Stop" : "Start";
                this.textboxTimer.func_146184_c(isWorking);
                this.textboxTimer.func_146195_b(isWorking);
            }
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) {
        if (keyCode == 1) {
            this.field_146297_k.field_71439_g.func_71053_j();
        } else if (typedChar == '\r') {
            this.updateTime(0);
        } else if (this.textboxTimer != null && this.textboxTimer.func_146206_l() && (Character.isDigit(typedChar) || typedChar == '\u0000' || typedChar == '\b')) {
            this.textboxTimer.func_146201_a(typedChar, keyCode);
        }
    }
}

