/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.items.cards;

import com.zuxelus.energycontrol.api.CardState;
import com.zuxelus.energycontrol.api.ICardReader;
import com.zuxelus.energycontrol.api.PanelSetting;
import com.zuxelus.energycontrol.api.PanelString;
import com.zuxelus.energycontrol.items.cards.ItemCardBase;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemCardRedstone
extends ItemCardBase {
    public ItemCardRedstone() {
        super(16, "card_redstone");
    }

    @Override
    public CardState update(World world, ICardReader reader, int range, BlockPos pos) {
        BlockPos target = reader.getTarget();
        if (target == null) {
            return CardState.NO_TARGET;
        }
        IBlockState state = world.func_180495_p(target);
        Block block = state.func_177230_c();
        if (block != Blocks.field_150350_a) {
            reader.setString("name", block.func_149732_F());
            reader.setBoolean("isPowered", world.func_175640_z(target));
            reader.setInt("indirect", world.func_175687_A(target));
            reader.setBoolean("canProvide", state.func_185897_m());
            reader.setString("powered", String.format("D:%d U:%d N:%d S:%d W:%d E:%d", world.func_175651_c(target.func_177977_b(), EnumFacing.DOWN), world.func_175651_c(target.func_177984_a(), EnumFacing.UP), world.func_175651_c(target.func_177978_c(), EnumFacing.NORTH), world.func_175651_c(target.func_177968_d(), EnumFacing.SOUTH), world.func_175651_c(target.func_177976_e(), EnumFacing.WEST), world.func_175651_c(target.func_177974_f(), EnumFacing.EAST)));
            reader.setString("week", String.format("D:%d U:%d N:%d S:%d W:%d E:%d", state.func_185911_a((IBlockAccess)world, target, EnumFacing.UP), state.func_185911_a((IBlockAccess)world, target, EnumFacing.DOWN), state.func_185911_a((IBlockAccess)world, target, EnumFacing.SOUTH), state.func_185911_a((IBlockAccess)world, target, EnumFacing.NORTH), state.func_185911_a((IBlockAccess)world, target, EnumFacing.EAST), state.func_185911_a((IBlockAccess)world, target, EnumFacing.WEST)));
            reader.setString("strong", String.format("D:%d U:%d N:%d S:%d W:%d E:%d", state.func_185893_b((IBlockAccess)world, target, EnumFacing.UP), state.func_185893_b((IBlockAccess)world, target, EnumFacing.DOWN), state.func_185893_b((IBlockAccess)world, target, EnumFacing.SOUTH), state.func_185893_b((IBlockAccess)world, target, EnumFacing.NORTH), state.func_185893_b((IBlockAccess)world, target, EnumFacing.EAST), state.func_185893_b((IBlockAccess)world, target, EnumFacing.WEST)));
            return CardState.OK;
        }
        return CardState.NO_TARGET;
    }

    @Override
    public List<PanelString> getStringData(int settings, ICardReader reader, boolean isServer, boolean showLabels) {
        LinkedList<PanelString> result = new LinkedList<PanelString>();
        result.add(new PanelString("msg.ec.InfoPanelName", reader.getString("name"), showLabels));
        result.add(new PanelString("msg.ec.InfoPanelBlockPowered", reader.getBoolean("isPowered").toString(), showLabels));
        result.add(new PanelString("msg.ec.InfoPanelIndirectPower", reader.getInt("indirect").intValue(), showLabels));
        result.add(new PanelString("msg.ec.InfoPanelCanProvidePower", reader.getBoolean("canProvide").toString(), showLabels));
        result.add(new PanelString("msg.ec.InfoPanelRedstonePower", reader.getString("powered"), showLabels));
        result.add(new PanelString("msg.ec.InfoPanelSendWeekPower", reader.getString("week"), showLabels));
        result.add(new PanelString("msg.ec.InfoPanelSendStrongPower", reader.getString("strong"), showLabels));
        return result;
    }

    @Override
    public List<PanelSetting> getSettingsList(ItemStack stack) {
        return null;
    }
}

