/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.items.cards;

import com.zuxelus.energycontrol.api.CardState;
import com.zuxelus.energycontrol.api.ICardReader;
import com.zuxelus.energycontrol.api.PanelSetting;
import com.zuxelus.energycontrol.api.PanelString;
import com.zuxelus.energycontrol.items.cards.ItemCardBase;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCardVanilla
extends ItemCardBase {
    public static final int DISPLAY_BURNING = 1;
    public static final int DISPLAY_TIME = 2;
    public static final int DISPLAY_SLOT_1 = 4;
    public static final int DISPLAY_SLOT_2 = 8;
    public static final int DISPLAY_SLOT_3 = 16;

    public ItemCardVanilla() {
        super(14, "card_vanilla");
    }

    @Override
    public CardState update(World world, ICardReader reader, int range, BlockPos pos) {
        BlockPos target = reader.getTarget();
        if (target == null) {
            return CardState.NO_TARGET;
        }
        TileEntity te = world.func_175625_s(target);
        if (te instanceof TileEntityFurnace) {
            TileEntityFurnace furnace = (TileEntityFurnace)te;
            reader.setInt("type", 1);
            reader.setString("entity", "furnace");
            reader.setBoolean("burning", furnace.func_145950_i());
            reader.setInt("burnTime", furnace.func_174887_a_(0));
            NBTTagCompound tag = new NBTTagCompound();
            if (!furnace.func_70301_a(0).func_190926_b()) {
                tag.func_74778_a("Cooking", furnace.func_70301_a(0).func_82833_r());
                tag.func_74768_a("Csize", furnace.func_70301_a(0).func_190916_E());
            }
            if (!furnace.func_70301_a(1).func_190926_b()) {
                tag.func_74778_a("Fuel", furnace.func_70301_a(1).func_82833_r());
                tag.func_74768_a("Fsize", furnace.func_70301_a(1).func_190916_E());
            }
            if (!furnace.func_70301_a(2).func_190926_b()) {
                tag.func_74778_a("Output", furnace.func_70301_a(2).func_82833_r());
                tag.func_74768_a("Osize", furnace.func_70301_a(2).func_190916_E());
            }
            reader.setTag("Info", (NBTBase)tag);
            return CardState.OK;
        }
        return CardState.NO_TARGET;
    }

    @Override
    public List<PanelString> getStringData(int settings, ICardReader reader, boolean isServer, boolean showLabels) {
        LinkedList<PanelString> result = new LinkedList<PanelString>();
        int burnTime = reader.getInt("burnTime");
        NBTTagCompound tag = reader.getTag("Info");
        if (tag != null) {
            if ((settings & 2) > 0) {
                result.add(new PanelString("msg.burnTime", burnTime, showLabels));
            }
            if ((settings & 4) > 0) {
                String slot1pre;
                String string = slot1pre = isServer ? "N/A" : I18n.func_135052_a((String)"msg.ec.None", (Object[])new Object[0]);
                if (tag.func_74764_b("Cooking")) {
                    slot1pre = tag.func_74779_i("Cooking");
                }
                if (showLabels) {
                    result.add(PanelString.create("msg.cooking", tag.func_74762_e("Csize"), slot1pre));
                } else {
                    result.add(new PanelString(String.format("%sx - %s", tag.func_74762_e("Csize"), slot1pre)));
                }
            }
            if ((settings & 8) > 0) {
                String slot2pre;
                String string = slot2pre = isServer ? "N/A" : I18n.func_135052_a((String)"msg.ec.None", (Object[])new Object[0]);
                if (tag.func_74764_b("Fuel")) {
                    slot2pre = tag.func_74779_i("Fuel");
                }
                if (showLabels) {
                    result.add(PanelString.create("msg.fuel", tag.func_74762_e("Fsize"), slot2pre));
                } else {
                    result.add(new PanelString(String.format("%sx - %s", tag.func_74762_e("Fsize"), slot2pre)));
                }
            }
            if ((settings & 0x10) > 0) {
                String slot3pre;
                String string = slot3pre = isServer ? "N/A" : I18n.func_135052_a((String)"msg.ec.None", (Object[])new Object[0]);
                if (tag.func_74764_b("Output")) {
                    slot3pre = tag.func_74779_i("Output");
                }
                if (showLabels) {
                    result.add(PanelString.create("msg.output", tag.func_74762_e("Osize"), slot3pre));
                } else {
                    result.add(new PanelString(String.format("%sx - %s", tag.func_74762_e("Osize"), slot3pre)));
                }
            }
        }
        if ((settings & 1) > 0) {
            this.addOnOff(result, isServer, reader.getBoolean("burning"));
        }
        return result;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<PanelSetting> getSettingsList(ItemStack stack) {
        ArrayList<PanelSetting> result = new ArrayList<PanelSetting>();
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.ec.cbInfoPanelOnOff", (Object[])new Object[0]), 1));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.burnTimeText", (Object[])new Object[0]), 2));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.cookingText", (Object[])new Object[0]), 4));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.fuelText", (Object[])new Object[0]), 8));
        result.add(new PanelSetting(I18n.func_135052_a((String)"msg.outputText", (Object[])new Object[0]), 16));
        return result;
    }
}

