/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.recipes;

import com.zuxelus.energycontrol.tileentities.TileEntityKitAssembler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class KitAssemblerRecipe
implements IRecipe {
    private static List<KitAssemblerRecipe> recipes = new ArrayList<KitAssemblerRecipe>();
    private ResourceLocation id;
    public final Ingredient input1;
    public final Ingredient input2;
    public final Ingredient input3;
    public final int count1;
    public final int count2;
    public final int count3;
    public final ItemStack output;
    public final int time;

    public KitAssemblerRecipe(Ingredient input1, int count1, Ingredient input2, int count2, Ingredient input3, int count3, ItemStack output, int time) {
        this.input1 = input1;
        this.count1 = count1;
        this.input2 = input2;
        this.count2 = count2;
        this.input3 = input3;
        this.count3 = count3;
        this.output = output;
        this.time = time;
    }

    public KitAssemblerRecipe(ItemStack stack1, ItemStack stack2, ItemStack stack3, ItemStack result, int time) {
        this.input1 = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack1});
        this.count1 = stack1.func_190916_E();
        this.input2 = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack2});
        this.count2 = stack2.func_190916_E();
        this.input3 = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{stack3});
        this.count3 = stack3.func_190916_E();
        this.output = result;
        this.time = time;
    }

    public boolean isSuitable(TileEntityKitAssembler te) {
        return this.isSuitable(te.func_70301_a(1), te.func_70301_a(2), te.func_70301_a(3), te.func_70301_a(4));
    }

    public boolean isSuitable(ItemStack stack1, ItemStack stack2, ItemStack stack3, ItemStack result) {
        if (stack1.func_190926_b() || stack1.func_190916_E() < this.count1 || !this.input1.test((Object)stack1)) {
            return false;
        }
        if (stack2.func_190926_b() || stack2.func_190916_E() < this.count2 || !this.input2.test((Object)stack2)) {
            return false;
        }
        if (stack3.func_190926_b() || stack3.func_190916_E() < this.count3 || !this.input3.test((Object)stack3)) {
            return false;
        }
        if (!result.func_190926_b()) {
            if (!result.func_77969_a(this.output)) {
                return false;
            }
            if (result.func_190916_E() + this.output.func_190916_E() > result.func_77976_d()) {
                return false;
            }
        }
        return true;
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        return false;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        return this.output;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{this.input1, this.input2, this.input3});
    }

    public ResourceLocation getRegistryName() {
        return this.id;
    }

    public IRecipe setRegistryName(ResourceLocation id) {
        this.id = id;
        KitAssemblerRecipe.addRecipe(this);
        return this;
    }

    public Class<IRecipe> getRegistryType() {
        return IRecipe.class;
    }

    public static void addRecipe(KitAssemblerRecipe recipe) {
        recipes.add(recipe);
    }

    public static void removeRecipe(ItemStack stack1, ItemStack stack2, ItemStack stack3, ItemStack result) {
        for (KitAssemblerRecipe recipe : recipes) {
            if (!recipe.isSuitable(stack1, stack2, stack3, result)) continue;
            recipes.remove(recipe);
            return;
        }
    }

    public static List<KitAssemblerRecipe> getRecipes() {
        return recipes;
    }

    public static KitAssemblerRecipe findRecipe(TileEntityKitAssembler te) {
        for (KitAssemblerRecipe recipe : recipes) {
            if (!recipe.isSuitable(te)) continue;
            return recipe;
        }
        return null;
    }
}

