/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.energycontrol.tileentities;

import cofh.redstoneflux.api.IEnergyReceiver;
import com.zuxelus.energycontrol.blocks.KitAssembler;
import com.zuxelus.energycontrol.crossmod.CrossModLoader;
import com.zuxelus.energycontrol.items.cards.ItemCardMain;
import com.zuxelus.energycontrol.items.cards.ItemCardReader;
import com.zuxelus.energycontrol.recipes.KitAssemblerRecipe;
import com.zuxelus.zlib.containers.EnergyStorage;
import com.zuxelus.zlib.containers.slots.ISlotItemFilter;
import com.zuxelus.zlib.tileentities.ITilePacketHandler;
import com.zuxelus.zlib.tileentities.TileEntityItemHandler;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.info.Info;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;

@Optional.InterfaceList(value={@Optional.Interface(modid="ic2", iface="ic2.api.energy.tile.IEnergySink"), @Optional.Interface(modid="thermalexpansion", iface="cofh.redstoneflux.api.IEnergyReceiver")})
public class TileEntityKitAssembler
extends TileEntityItemHandler
implements ITickable,
ITilePacketHandler,
ISlotItemFilter,
IEnergySink,
IEnergyStorage,
IEnergyReceiver {
    public static final byte SLOT_INFO = 0;
    public static final byte SLOT_CARD1 = 1;
    public static final byte SLOT_ITEM = 2;
    public static final byte SLOT_CARD2 = 3;
    public static final byte SLOT_RESULT = 4;
    public static final byte SLOT_DISCHARGER = 5;
    public static final byte SLOT_TRANSFORMER = 6;
    private EnergyStorage storage = new EnergyStorage(5000, 32, 32, 0);
    private int buffer;
    private static final int CONSUMPTION = 5;
    private int upgrades;
    private KitAssemblerRecipe recipe;
    private int recipeTime;
    public static final int CAPACITY = 5000;
    public static final int OUTPUT = 32;
    private double production = 0.0;
    private boolean addedToEnet = false;
    private boolean active = false;

    public TileEntityKitAssembler() {
        super("tile.kit_assembler.name");
    }

    public double getEnergy() {
        return this.storage.getEnergyStored();
    }

    public int getEnergyFactor() {
        return Math.round((float)this.storage.getEnergyStored() * 52.0f / 5000.0f);
    }

    public double getProduction() {
        return this.production;
    }

    public int getProductionFactor() {
        if (this.recipeTime == 0) {
            return 0;
        }
        return (int)Math.round(this.production * 24.0 / (double)this.recipeTime);
    }

    public int getRecipeTime() {
        if (this.recipe == null) {
            return 0;
        }
        return this.recipe.time;
    }

    @Override
    public void onServerMessageReceived(NBTTagCompound tag) {
        if (!tag.func_74764_b("type")) {
            return;
        }
        switch (tag.func_74762_e("type")) {
            case 4: {
                ItemStack stack;
                if (!tag.func_74764_b("slot") || !tag.func_74764_b("title") || !ItemCardMain.isCard(stack = this.func_70301_a(tag.func_74762_e("slot")))) break;
                new ItemCardReader(stack).setTitle(tag.func_74779_i("title"));
            }
        }
    }

    @Override
    public void onClientMessageReceived(NBTTagCompound tag) {
        if (!tag.func_74764_b("type")) {
            return;
        }
        switch (tag.func_74762_e("type")) {
            case 1: {
                if (tag.func_74764_b("energy") && tag.func_74764_b("production")) {
                    this.storage.setEnergy(tag.func_74762_e("energy"));
                    this.production = tag.func_74769_h("production");
                }
                this.recipeTime = tag.func_74764_b("time") ? tag.func_74762_e("time") : 0;
            }
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readProperties(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = super.func_189517_E_();
        tag = this.writeProperties(tag);
        this.updateActive();
        tag.func_74757_a("active", this.active);
        return tag;
    }

    @Override
    protected void readProperties(NBTTagCompound tag) {
        super.readProperties(tag);
        if (tag.func_74764_b("energy")) {
            this.storage.setEnergy(tag.func_74762_e("energy"));
        }
        if (tag.func_74764_b("buffer")) {
            this.buffer = tag.func_74762_e("buffer");
        }
        if (tag.func_74764_b("production")) {
            this.production = tag.func_74769_h("production");
        }
        if (tag.func_74764_b("active")) {
            this.active = tag.func_74767_n("active");
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.readProperties(tag);
    }

    @Override
    protected NBTTagCompound writeProperties(NBTTagCompound tag) {
        tag = super.writeProperties(tag);
        tag.func_74768_a("energy", this.storage.getEnergyStored());
        tag.func_74768_a("buffer", this.buffer);
        tag.func_74780_a("production", this.production);
        return tag;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        return this.writeProperties(super.func_189515_b(tag));
    }

    @Optional.Method(modid="ic2")
    public void onLoad() {
        if (!this.addedToEnet && !this.field_145850_b.field_72995_K && Info.isIc2Available()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.addedToEnet = true;
            this.updateActive();
        }
    }

    public void func_145843_s() {
        this.onChunkUnload();
        super.func_145843_s();
    }

    @Optional.Method(modid="ic2")
    public void onChunkUnload() {
        if (this.addedToEnet && !this.field_145850_b.field_72995_K && Info.isIc2Available()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.addedToEnet = false;
        }
    }

    public void func_73660_a() {
        if (!this.addedToEnet) {
            this.onLoad();
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.handleDischarger(5);
        if (!this.active) {
            return;
        }
        int energyNeeded = 5 * (int)Math.pow(2.0, this.upgrades);
        if (this.storage.getEnergyStored() >= energyNeeded) {
            this.storage.extractEnergy(energyNeeded, false);
            this.production += Math.pow(2.0, this.upgrades);
            if (this.recipe != null && this.production >= (double)this.recipe.time) {
                ItemStack stack1 = this.func_70301_a(1);
                ItemStack stack2 = this.func_70301_a(2);
                ItemStack stack3 = this.func_70301_a(3);
                ItemStack result = this.func_70301_a(4);
                stack1.func_190918_g(this.recipe.count1);
                stack2.func_190918_g(this.recipe.count2);
                stack3.func_190918_g(this.recipe.count3);
                if (result.func_190926_b()) {
                    this.func_70299_a(4, this.recipe.output.func_77946_l());
                } else {
                    result.func_190917_f(this.recipe.output.func_190916_E());
                }
                this.production = 0.0;
                this.updateState();
            }
        } else {
            this.storage.setEnergy(0);
            this.production = 0.0;
            this.updateState();
        }
    }

    private void handleDischarger(int slot) {
        int needed = Math.min(32 * (int)Math.pow(4.0, this.upgrades), this.storage.getMaxEnergyStored() - this.storage.getEnergyStored());
        if (needed <= 0) {
            return;
        }
        if (this.buffer > 0) {
            this.buffer -= this.storage.receiveEnergy(this.buffer, false);
        }
        needed = Math.min(32 * (int)Math.pow(4.0, this.upgrades), this.storage.getMaxEnergyStored() - this.storage.getEnergyStored());
        ItemStack stack = this.func_70301_a(slot);
        if (!stack.func_190926_b() && needed > 0) {
            if (stack.func_77973_b().equals(Items.field_151129_at)) {
                this.buffer += 2000;
                this.buffer -= this.storage.receiveEnergy(this.buffer, false);
                this.func_70299_a(slot, new ItemStack(Items.field_151133_ar));
                return;
            }
            IEnergyStorage stackStorage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
            if (stackStorage != null) {
                if (this.storage.receiveEnergy(stackStorage.extractEnergy(needed, false), false) > 0) {
                    this.active = true;
                }
            } else if (CrossModLoader.isElectricItem(stack)) {
                double old = this.storage.getEnergyStored();
                this.storage.receiveEnergy((int)CrossModLoader.dischargeItem(stack, needed, this.getSinkTier()), false);
                if (!this.active && (double)this.storage.getEnergyStored() > old) {
                    this.func_70296_d();
                }
            }
        }
    }

    @Override
    public void notifyBlockUpdate() {
        IBlockState iblockstate = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, iblockstate, iblockstate, 2);
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        this.updateState();
    }

    private void updateActive() {
        this.active = false;
        ItemStack stack = this.func_70301_a(6);
        this.upgrades = stack.func_190916_E();
        this.storage.setMax(32 * (int)Math.pow(4.0, this.upgrades));
        int energyNeeded = 5 * (int)Math.pow(2.0, this.upgrades);
        if (this.storage.getEnergyStored() < energyNeeded) {
            return;
        }
        if (this.recipe == null) {
            KitAssemblerRecipe newRecipe = KitAssemblerRecipe.findRecipe(this);
            if (newRecipe == null) {
                return;
            }
            this.recipe = newRecipe;
        } else if (!this.recipe.isSuitable(this)) {
            KitAssemblerRecipe newRecipe = KitAssemblerRecipe.findRecipe(this);
            if (newRecipe == null) {
                this.recipe = null;
                return;
            }
            this.recipe = newRecipe;
        }
        this.active = true;
    }

    private void updateState() {
        boolean old = this.active;
        this.updateActive();
        if (this.active == old) {
            return;
        }
        this.production = 0.0;
        IBlockState iblockstate = this.field_145850_b.func_180495_p(this.field_174879_c);
        Block block = iblockstate.func_177230_c();
        if (!(block instanceof KitAssembler) || (Boolean)iblockstate.func_177229_b((IProperty)KitAssembler.ACTIVE) == this.active) {
            return;
        }
        IBlockState newState = block.func_176223_P().func_177226_a((IProperty)KitAssembler.field_185512_D, iblockstate.func_177229_b((IProperty)KitAssembler.field_185512_D)).func_177226_a((IProperty)KitAssembler.ACTIVE, (Comparable)Boolean.valueOf(this.active));
        this.field_145850_b.func_180501_a(this.field_174879_c, newState, 3);
    }

    public int func_70302_i_() {
        return 7;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return this.isItemValid(slot, stack);
    }

    @Override
    public boolean isItemValid(int slot, ItemStack stack) {
        switch (slot) {
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
            case 0: {
                return ItemCardMain.isCard(stack);
            }
            case 5: {
                return stack.getCapability(CapabilityEnergy.ENERGY, null) != null || CrossModLoader.isElectricItem(stack) || stack.func_77973_b().equals(Items.field_151129_at);
            }
            case 6: {
                return stack.func_77969_a(CrossModLoader.getCrossMod("ic2").getItemStack("transformer"));
            }
        }
        return false;
    }

    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing side) {
        return true;
    }

    public double getDemandedEnergy() {
        return Math.max(0, this.storage.getMaxEnergyStored() - this.storage.getEnergyStored());
    }

    public int getSinkTier() {
        return 1 + this.upgrades;
    }

    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        double left = 0.0;
        int input = 32 * (int)Math.pow(4.0, this.upgrades);
        if (amount > (double)input) {
            left = amount - (double)input;
            amount = input;
        }
        return left += amount - (double)this.storage.receiveEnergy((int)amount, false);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    @Override
    public <T> T getCapability(Capability<T> cap, EnumFacing side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return (T)this;
        }
        return super.getCapability(cap, side);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int energyReceived = Math.min(5000 - this.getEnergyStored(), Math.min(32, maxReceive));
        return this.storage.receiveEnergy(energyReceived, simulate);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return this.storage.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.storage.getMaxEnergyStored();
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }

    public int getEnergyStored(EnumFacing side) {
        return this.storage.getEnergyStored();
    }

    public int getMaxEnergyStored(EnumFacing side) {
        return this.storage.getMaxEnergyStored();
    }

    public boolean canConnectEnergy(EnumFacing side) {
        return true;
    }

    public int receiveEnergy(EnumFacing side, int maxReceive, boolean simulate) {
        int energyReceived = Math.min(5000 - this.getEnergyStored(), Math.min(32, maxReceive));
        return this.storage.receiveEnergy(energyReceived, simulate);
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.UP) {
            return new int[]{1, 2, 3};
        }
        if (side == EnumFacing.DOWN) {
            return new int[]{4};
        }
        return super.func_180463_a(side);
    }

    @Override
    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        return side == EnumFacing.UP && (slot == 1 || slot == 2 || slot == 3);
    }

    @Override
    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        return side == EnumFacing.DOWN && slot == 4;
    }
}

