/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.blocks;

import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import mctmods.immersivetechnology.ImmersiveTechnology;
import mctmods.immersivetechnology.common.ITContent;
import mctmods.immersivetechnology.common.blocks.ItemBlockITBase;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockITBase<E extends Enum<E>>
extends Block
implements IEBlockInterfaces.IIEMetaBlock {
    protected static IProperty[] tempProperties;
    protected static IUnlistedProperty[] tempUnlistedProperties;
    public final String name;
    public final PropertyEnum<E> property;
    public final IProperty[] additionalProperties;
    public final IUnlistedProperty[] additionalUnlistedProperties;
    public final E[] enumValues;
    boolean[] isMetaHidden;
    boolean[] hasFlavour;
    protected Set<BlockRenderLayer> renderLayers = Sets.newHashSet((Object[])new BlockRenderLayer[]{BlockRenderLayer.SOLID});
    protected Set<BlockRenderLayer>[] metaRenderLayers;
    protected Map<Integer, Integer> metaLightOpacities = new HashMap<Integer, Integer>();
    protected Map<Integer, Float> metaHardness = new HashMap<Integer, Float>();
    protected Map<Integer, Integer> metaResistances = new HashMap<Integer, Integer>();
    protected EnumPushReaction[] metaMobilityFlags;
    protected boolean[] canHammerHarvest;
    protected boolean[] metaNotNormalBlock;
    private boolean opaqueCube = false;

    public BlockITBase(String name, Material material, PropertyEnum<E> mainProperty, Class<? extends ItemBlockITBase> itemBlock, Object ... additionalProperties) {
        super(BlockITBase.setTempProperties(material, mainProperty, additionalProperties));
        this.name = name;
        this.property = mainProperty;
        this.enumValues = (Enum[])mainProperty.func_177699_b().getEnumConstants();
        this.isMetaHidden = new boolean[this.enumValues.length];
        this.hasFlavour = new boolean[this.enumValues.length];
        this.metaRenderLayers = new Set[this.enumValues.length];
        this.canHammerHarvest = new boolean[this.enumValues.length];
        this.metaMobilityFlags = new EnumPushReaction[this.enumValues.length];
        ArrayList<IProperty> propList = new ArrayList<IProperty>();
        ArrayList<IUnlistedProperty> unlistedPropList = new ArrayList<IUnlistedProperty>();
        for (Object o : additionalProperties) {
            if (o instanceof IProperty) {
                propList.add((IProperty)o);
            }
            if (o instanceof IProperty[]) {
                propList.addAll(Arrays.asList((IProperty[])o));
            }
            if (o instanceof IUnlistedProperty) {
                unlistedPropList.add((IUnlistedProperty)o);
            }
            if (!(o instanceof IUnlistedProperty[])) continue;
            unlistedPropList.addAll(Arrays.asList((IUnlistedProperty[])o));
        }
        this.additionalProperties = propList.toArray(new IProperty[propList.size()]);
        this.additionalUnlistedProperties = unlistedPropList.toArray(new IUnlistedProperty[unlistedPropList.size()]);
        this.func_180632_j(this.getInitDefaultState());
        String registryName = this.createRegistryName();
        this.func_149663_c(registryName.replace(':', '.'));
        this.func_149647_a(ImmersiveTechnology.creativeTab);
        this.adjustSound();
        ITContent.registeredITBlocks.add(this);
        try {
            ITContent.registeredITItems.add((Item)itemBlock.getConstructor(Block.class).newInstance(new Object[]{this}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.field_149786_r = 255;
    }

    public String getIEBlockName() {
        return this.name;
    }

    public Enum[] getMetaEnums() {
        return this.enumValues;
    }

    public IBlockState getInventoryState(int meta) {
        return this.func_176203_a(meta);
    }

    public PropertyEnum<E> getMetaProperty() {
        return this.property;
    }

    public boolean useCustomStateMapper() {
        return false;
    }

    public String getCustomStateMapping(int meta, boolean itemBlock) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public StateMapperBase getCustomMapper() {
        return null;
    }

    public boolean appendPropertiesToState() {
        return true;
    }

    public String getTranslationKey(ItemStack stack) {
        String subName = ((Enum)((Object)this.func_176203_a(stack.func_77952_i()).func_177229_b(this.property))).toString().toLowerCase(Locale.US);
        return super.func_149739_a() + "." + subName;
    }

    protected static Material setTempProperties(Material material, PropertyEnum<?> property, Object ... additionalProperties) {
        ArrayList<Object> propList = new ArrayList<Object>();
        ArrayList<IUnlistedProperty> unlistedPropList = new ArrayList<IUnlistedProperty>();
        propList.add(property);
        for (Object o : additionalProperties) {
            if (o instanceof IProperty) {
                propList.add((IProperty)o);
            }
            if (o instanceof IProperty[]) {
                propList.addAll(Arrays.asList((IProperty[])o));
            }
            if (o instanceof IUnlistedProperty) {
                unlistedPropList.add((IUnlistedProperty)o);
            }
            if (!(o instanceof IUnlistedProperty[])) continue;
            unlistedPropList.addAll(Arrays.asList((IUnlistedProperty[])o));
        }
        tempProperties = propList.toArray(new IProperty[propList.size()]);
        tempUnlistedProperties = unlistedPropList.toArray(new IUnlistedProperty[unlistedPropList.size()]);
        return material;
    }

    protected static Object[] combineProperties(Object[] currentProperties, Object ... addedProperties) {
        int i;
        Object[] array = new Object[currentProperties.length + addedProperties.length];
        for (i = 0; i < currentProperties.length; ++i) {
            array[i] = currentProperties[i];
        }
        for (i = 0; i < addedProperties.length; ++i) {
            array[currentProperties.length + i] = addedProperties[i];
        }
        return array;
    }

    public BlockITBase<?> setMetaHidden(int ... meta) {
        for (int i : meta) {
            if (i < 0 || i >= this.isMetaHidden.length) continue;
            this.isMetaHidden[i] = true;
        }
        return this;
    }

    public BlockITBase<?> setMetaUnhidden(int ... meta) {
        for (int i : meta) {
            if (i < 0 || i >= this.isMetaHidden.length) continue;
            this.isMetaHidden[i] = false;
        }
        return this;
    }

    public boolean isMetaHidden(int meta) {
        return this.isMetaHidden[Math.max(0, Math.min(meta, this.isMetaHidden.length - 1))];
    }

    public BlockITBase<?> setHasFlavour(int ... meta) {
        if (meta == null || meta.length < 1) {
            for (int i = 0; i < this.hasFlavour.length; ++i) {
                this.hasFlavour[i] = true;
            }
        } else {
            for (int i : meta) {
                if (i < 0 || i >= this.hasFlavour.length) continue;
                this.hasFlavour[i] = false;
            }
        }
        return this;
    }

    public boolean hasFlavour(ItemStack stack) {
        return this.hasFlavour[Math.max(0, Math.min(stack.func_77952_i(), this.hasFlavour.length - 1))];
    }

    public BlockITBase<E> setBlockLayer(BlockRenderLayer ... layer) {
        this.renderLayers = Sets.newHashSet((Object[])layer);
        return this;
    }

    public BlockITBase<E> setMetaBlockLayer(int meta, BlockRenderLayer ... layer) {
        this.metaRenderLayers[Math.max((int)0, (int)Math.min((int)meta, (int)(this.metaRenderLayers.length - 1)))] = Sets.newHashSet((Object[])layer);
        return this;
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        int meta = this.func_176201_c(state);
        if (meta >= 0 && meta < this.metaRenderLayers.length && this.metaRenderLayers[meta] != null) {
            return this.metaRenderLayers[meta].contains(layer);
        }
        return this.renderLayers.contains(layer);
    }

    public BlockITBase<E> setMetaLightOpacity(int meta, int opacity) {
        this.metaLightOpacities.put(meta, opacity);
        return this;
    }

    public int getLightOpacity(IBlockState state, IBlockAccess w, BlockPos pos) {
        int meta = this.func_176201_c(state);
        if (this.metaLightOpacities.containsKey(meta)) {
            return this.metaLightOpacities.get(meta);
        }
        return super.getLightOpacity(state, w, pos);
    }

    public BlockITBase<E> setMetaHardness(int meta, float hardness) {
        this.metaHardness.put(meta, Float.valueOf(hardness));
        return this;
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        int meta = this.func_176201_c(state);
        if (this.metaHardness.containsKey(meta)) {
            return this.metaHardness.get(meta).floatValue();
        }
        return super.func_176195_g(state, world, pos);
    }

    public BlockITBase<E> setMetaExplosionResistance(int meta, int resistance) {
        this.metaResistances.put(meta, resistance);
        return this;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        int meta = this.func_176201_c(world.func_180495_p(pos));
        if (this.metaResistances.containsKey(meta)) {
            return this.metaResistances.get(meta).intValue();
        }
        return super.getExplosionResistance(world, pos, exploder, explosion);
    }

    public BlockITBase<E> setMetaMobilityFlag(int meta, EnumPushReaction flag) {
        this.metaMobilityFlags[meta] = flag;
        return this;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        int meta = this.func_176201_c(state);
        if (this.metaMobilityFlags[meta] == null) {
            return EnumPushReaction.NORMAL;
        }
        return this.metaMobilityFlags[meta];
    }

    public BlockITBase<E> setNotNormalBlock(int meta) {
        if (this.metaNotNormalBlock == null) {
            this.metaNotNormalBlock = new boolean[this.enumValues.length];
        }
        this.metaNotNormalBlock[meta] = true;
        return this;
    }

    public BlockITBase<E> setAllNotNormalBlock() {
        if (this.metaNotNormalBlock == null) {
            this.metaNotNormalBlock = new boolean[this.enumValues.length];
        }
        for (int i = 0; i < this.metaNotNormalBlock.length; ++i) {
            this.metaNotNormalBlock[i] = true;
        }
        return this;
    }

    protected boolean normalBlockCheck(IBlockState state) {
        if (this.metaNotNormalBlock == null) {
            return true;
        }
        int meta = this.func_176201_c(state);
        return meta < 0 || meta >= this.metaNotNormalBlock.length || !this.metaNotNormalBlock[meta];
    }

    public boolean func_149730_j(IBlockState state) {
        return this.normalBlockCheck(state);
    }

    public boolean func_149686_d(IBlockState state) {
        return this.normalBlockCheck(state);
    }

    public boolean func_149662_c(IBlockState state) {
        return this.normalBlockCheck(state);
    }

    public boolean func_176214_u(IBlockState state) {
        if (this.metaNotNormalBlock == null) {
            return true;
        }
        int majority = 0;
        for (boolean b : this.metaNotNormalBlock) {
            if (!b) continue;
            ++majority;
        }
        return majority < this.metaNotNormalBlock.length / 2;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.normalBlockCheck(state);
    }

    protected BlockStateContainer createNotTempBlockState() {
        IProperty[] array = new IProperty[1 + this.additionalProperties.length];
        array[0] = this.property;
        for (int i = 0; i < this.additionalProperties.length; ++i) {
            array[1 + i] = this.additionalProperties[i];
        }
        if (this.additionalUnlistedProperties.length > 0) {
            return new ExtendedBlockState((Block)this, array, this.additionalUnlistedProperties);
        }
        return new BlockStateContainer((Block)this, array);
    }

    protected IBlockState getInitDefaultState() {
        IBlockState state = this.field_176227_L.func_177621_b().func_177226_a(this.property, this.enumValues[0]);
        for (int i = 0; i < this.additionalProperties.length; ++i) {
            if (this.additionalProperties[i] == null || this.additionalProperties[i].func_177700_c().isEmpty()) continue;
            state = this.applyProperty(state, this.additionalProperties[i], this.additionalProperties[i].func_177700_c().iterator().next());
        }
        return state;
    }

    protected <V extends Comparable<V>> IBlockState applyProperty(IBlockState in, IProperty<V> prop, Object val) {
        return in.func_177226_a(prop, (Comparable)val);
    }

    public void onITBlockPlacedBy(World world, BlockPos pos, IBlockState state, EnumFacing side, float hitX, float hitY, float hitZ, EntityLivingBase placer, ItemStack stack) {
    }

    public boolean canITBlockBePlaced(World world, BlockPos pos, IBlockState newState, EnumFacing side, float hitX, float hitY, float hitZ, EntityPlayer player, ItemStack stack) {
        return true;
    }

    protected BlockStateContainer func_180661_e() {
        if (this.property != null) {
            return this.createNotTempBlockState();
        }
        if (tempUnlistedProperties.length > 0) {
            return new ExtendedBlockState((Block)this, tempProperties, tempUnlistedProperties);
        }
        return new BlockStateContainer((Block)this, tempProperties);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    public int func_176201_c(IBlockState state) {
        if (state == null || !((Object)((Object)this)).equals(state.func_177230_c())) {
            return 0;
        }
        return ((IBlockEnum)((Object)((Enum)((Object)state.func_177229_b(this.property))))).getMeta();
    }

    protected E fromMeta(int meta) {
        if (meta < 0 || meta >= this.enumValues.length) {
            meta = 0;
        }
        return this.enumValues[meta];
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(this.property, this.fromMeta(meta));
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (E type : this.enumValues) {
            if (!((IBlockEnum)type).listForCreative() || this.isMetaHidden[((IBlockEnum)type).getMeta()]) continue;
            list.add((Object)new ItemStack((Block)this, 1, ((IBlockEnum)type).getMeta()));
        }
    }

    void adjustSound() {
        if (this.field_149764_J == Material.field_151574_g) {
            this.field_149762_H = SoundType.field_185858_k;
        } else if (this.field_149764_J == Material.field_151593_r || this.field_149764_J == Material.field_151580_n) {
            this.field_149762_H = SoundType.field_185854_g;
        } else if (this.field_149764_J == Material.field_151592_s || this.field_149764_J == Material.field_151588_w) {
            this.field_149762_H = SoundType.field_185853_f;
        } else if (this.field_149764_J == Material.field_151577_b || this.field_149764_J == Material.field_151590_u || this.field_149764_J == Material.field_151585_k || this.field_149764_J == Material.field_151582_l) {
            this.field_149762_H = SoundType.field_185850_c;
        } else if (this.field_149764_J == Material.field_151578_c) {
            this.field_149762_H = SoundType.field_185849_b;
        } else if (this.field_149764_J == Material.field_151573_f) {
            this.field_149762_H = SoundType.field_185852_e;
        } else if (this.field_149764_J == Material.field_151595_p) {
            this.field_149762_H = SoundType.field_185855_h;
        } else if (this.field_149764_J == Material.field_151597_y) {
            this.field_149762_H = SoundType.field_185856_i;
        } else if (this.field_149764_J == Material.field_151576_e) {
            this.field_149762_H = SoundType.field_185851_d;
        } else if (this.field_149764_J == Material.field_151575_d || this.field_149764_J == Material.field_151570_A) {
            this.field_149762_H = SoundType.field_185848_a;
        }
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int eventID, int eventParam) {
        if (worldIn.field_72995_K && eventID == 255) {
            worldIn.func_184138_a(pos, state, state, 3);
            return true;
        }
        return super.func_189539_a(state, worldIn, pos, eventID, eventParam);
    }

    public BlockITBase<E> setMetaHammerHarvest(int meta) {
        this.canHammerHarvest[meta] = true;
        return this;
    }

    public BlockITBase<E> setHammerHarvest() {
        for (int i = 0; i < this.metaNotNormalBlock.length; ++i) {
            this.canHammerHarvest[i] = true;
        }
        return this;
    }

    public boolean allowHammerHarvest(IBlockState blockState) {
        int meta = this.func_176201_c(blockState);
        if (meta >= 0 && meta < this.canHammerHarvest.length) {
            return this.canHammerHarvest[meta];
        }
        return false;
    }

    public boolean allowWirecutterHarvest(IBlockState blockState) {
        return false;
    }

    public boolean isOpaqueCube() {
        return this.opaqueCube;
    }

    public BlockITBase<E> setOpaque(boolean isOpaque) {
        this.opaqueCube = isOpaque;
        this.field_149787_q = isOpaque;
        return this;
    }

    public boolean isToolEffective(String type, IBlockState state) {
        if (this.allowHammerHarvest(state) && type.equals("IE_HAMMER")) {
            return true;
        }
        if (this.allowWirecutterHarvest(state) && type.equals("IE_WIRECUTTER")) {
            return true;
        }
        return super.isToolEffective(type, state);
    }

    public String createRegistryName() {
        return "immersivetech:" + this.name;
    }

    public static abstract class IPLadderBlock<E extends Enum<E>>
    extends BlockITBase<E> {
        public IPLadderBlock(String name, Material material, PropertyEnum<E> mainProperty, Class<? extends ItemBlockITBase> itemBlock, Object ... additionalProperties) {
            super(name, material, mainProperty, itemBlock, additionalProperties);
        }

        public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
            super.func_180634_a(worldIn, pos, state, entityIn);
            if (entityIn instanceof EntityLivingBase && !((EntityLivingBase)entityIn).func_70617_f_() && this.isLadder(state, (IBlockAccess)worldIn, pos, (EntityLivingBase)entityIn)) {
                float f5 = 0.15f;
                if (entityIn.field_70159_w < (double)(-f5)) {
                    entityIn.field_70159_w = -f5;
                }
                if (entityIn.field_70159_w > (double)f5) {
                    entityIn.field_70159_w = f5;
                }
                if (entityIn.field_70179_y < (double)(-f5)) {
                    entityIn.field_70179_y = -f5;
                }
                if (entityIn.field_70179_y > (double)f5) {
                    entityIn.field_70179_y = f5;
                }
                entityIn.field_70143_R = 0.0f;
                if (entityIn.field_70181_x < -0.15) {
                    entityIn.field_70181_x = -0.15;
                }
                if (entityIn.field_70181_x < 0.0 && entityIn instanceof EntityPlayer && entityIn.func_70093_af()) {
                    entityIn.field_70181_x = 0.05;
                    return;
                }
                if (entityIn.field_70123_F) {
                    entityIn.field_70181_x = 0.2;
                }
            }
        }
    }

    public static interface IBlockEnum
    extends IStringSerializable {
        public int getMeta();

        public boolean listForCreative();
    }
}

