/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.blocks.connectors.tileentities;

import blusunrize.immersiveengineering.api.energy.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.wires.ImmersiveNetHandler;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityConnectorRedstone;
import mctmods.immersivetechnology.ImmersiveTechnology;
import mctmods.immersivetechnology.common.util.network.MessageTileSync;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityTimer
extends TileEntityConnectorRedstone
implements IEBlockInterfaces.IGuiTile {
    private EnumFacing face;
    private BlockPos position;
    private int redstoneChannelsending = 0;
    private int lastOutput = 0;
    private int target = 40;
    private int tick = 1;
    private final int maxTarget = 600;
    private final int minTarget = 10;

    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74768_a("redstoneChannelsending", this.redstoneChannelsending);
        nbt.func_74768_a("target", this.target);
        nbt.func_74768_a("tick", this.tick);
    }

    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.redstoneChannelsending = nbt.func_74762_e("redstoneChannelsending");
        this.target = nbt.func_74762_e("target");
        this.tick = nbt.func_74762_e("tick");
    }

    public int getTarget() {
        return this.target;
    }

    private void setTarget(int increment) {
        if (increment < 0) {
            if (this.target != 10) {
                this.target = this.target < 200 && this.target > 100 ? (this.target -= 20) : (this.target < 100 ? (this.target -= 10) : (this.target -= 40));
            }
        } else if (increment > 0 && this.target != 600) {
            this.target = this.target < 200 && this.target > 100 ? (this.target += 20) : (this.target < 100 ? (this.target += 10) : (this.target += 40));
        }
        this.tick = 1;
    }

    private boolean stopTimer(BlockPos pos) {
        return this.field_145850_b.func_175709_b(pos, this.face);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.face == null) {
                EnumFacing enumFacing = this.facing == EnumFacing.SOUTH ? EnumFacing.UP : (this.facing == EnumFacing.NORTH ? EnumFacing.DOWN : (this.face = this.facing == EnumFacing.WEST ? EnumFacing.NORTH : EnumFacing.SOUTH));
            }
            if (this.position == null) {
                this.position = this.func_174877_v().func_177972_a(this.face);
            }
            if (!this.stopTimer(this.position)) {
                if (this.tick == this.target) {
                    this.lastOutput = 1;
                    this.tick = 1;
                    this.rsDirty = true;
                } else {
                    ++this.tick;
                    if (this.lastOutput == 1) {
                        this.lastOutput = 0;
                    }
                }
            }
        }
        super.func_73660_a();
    }

    public boolean isRSInput() {
        return true;
    }

    public boolean isRSOutput() {
        return true;
    }

    public void updateInput(byte[] signals) {
        signals[this.redstoneChannelsending] = (byte)Math.max(this.lastOutput, signals[this.redstoneChannelsending]);
        this.rsDirty = false;
    }

    public boolean hammerUseSide(EnumFacing side, EntityPlayer player, float hitX, float hitY, float hitZ) {
        this.redstoneChannelsending = (this.redstoneChannelsending + 1) % 16;
        this.func_70296_d();
        this.wireNetwork.updateValues();
        this.onChange();
        this.markContainingBlockForUpdate(null);
        this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_145838_q(), 254, 0);
        return true;
    }

    public void receiveMessageFromClient(NBTTagCompound message) {
        if (!message.func_74764_b("buttonId")) {
            return;
        }
        int id = message.func_74762_e("buttonId");
        this.setTarget(id == 0 ? 1 : -1);
        this.func_70296_d();
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("target", this.target);
        BlockPos center = this.func_174877_v();
        ImmersiveTechnology.packetHandler.sendToAllTracking((IMessage)new MessageTileSync((TileEntityIEBase)this, tag), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)center.func_177958_n(), (double)center.func_177956_o(), (double)center.func_177952_p(), 0.0));
    }

    public void receiveMessageFromServer(NBTTagCompound message) {
        if (!message.func_74764_b("target")) {
            return;
        }
        this.target = message.func_74762_e("target");
    }

    public Vec3d getRaytraceOffset(IImmersiveConnectable link) {
        EnumFacing side = this.facing.func_176734_d();
        return new Vec3d(0.5 + (double)side.func_82601_c() * 0.375, 0.5 + (double)side.func_96559_d() * 0.375, 0.5 + (double)side.func_82599_e() * 0.375);
    }

    public Vec3d getConnectionOffset(ImmersiveNetHandler.Connection con) {
        EnumFacing side = this.facing.func_176734_d();
        double conRadius = con.cableType.getRenderDiameter() / 2.0;
        return new Vec3d(0.5 + (double)side.func_82601_c() * (0.375 - conRadius), 0.5 + (double)side.func_96559_d() * (0.375 - conRadius), 0.5 + (double)side.func_82599_e() * (0.375 - conRadius));
    }

    public String getCacheKey(IBlockState object) {
        return this.redstoneChannel + ";" + this.redstoneChannelsending;
    }

    public String[] getOverlayText(EntityPlayer player, RayTraceResult mop, boolean hammer) {
        if (!hammer) {
            return null;
        }
        float time = (float)this.target / 20.0f;
        return new String[]{I18n.func_135052_a((String)"desc.immersiveengineering.info.redstoneChannel.send", (Object[])new Object[]{I18n.func_135052_a((String)("item.fireworksCharge." + EnumDyeColor.func_176764_b((int)this.redstoneChannelsending).func_176762_d()), (Object[])new Object[0])}), I18n.func_135052_a((String)(String.valueOf(time) + " Sec."), (Object[])new Object[0])};
    }

    public boolean useNixieFont(EntityPlayer player, RayTraceResult mop) {
        return false;
    }

    public boolean canOpenGui() {
        return true;
    }

    public int getGuiID() {
        return 4;
    }

    public TileEntity getGuiMaster() {
        return this;
    }

    public float[] getBlockBounds() {
        switch (this.facing) {
            case NORTH: {
                return new float[]{0.25f, 0.0f, 0.0f, 0.75f, 0.75f, 1.0f};
            }
            case SOUTH: {
                return new float[]{0.25f, 0.25f, 0.0f, 0.75f, 1.0f, 1.0f};
            }
            case EAST: {
                return new float[]{0.0f, 0.25f, 0.25f, 1.0f, 0.75f, 1.0f};
            }
            case WEST: {
                return new float[]{0.0f, 0.25f, 0.0f, 1.0f, 0.75f, 0.75f};
            }
        }
        return new float[]{0.25f, 0.0f, 0.25f, 0.75f, 1.0f, 1.0f};
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTextureReplacement(IBlockState object, String material) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldRenderGroup(IBlockState object, String group) {
        if (MinecraftForgeClient.getRenderLayer() == BlockRenderLayer.SOLID) {
            return false;
        }
        if ("glass".equals(group)) {
            return MinecraftForgeClient.getRenderLayer() == BlockRenderLayer.TRANSLUCENT;
        }
        return MinecraftForgeClient.getRenderLayer() == BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderColour(IBlockState object, String group) {
        if ("colour_out".equals(group)) {
            return 0xFF000000 | EnumDyeColor.func_176764_b((int)this.redstoneChannelsending).func_193350_e();
        }
        return -1;
    }
}

