/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.blocks.metal.tileentities;

import blusunrize.immersiveengineering.api.energy.immersiveflux.FluxStorage;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import mctmods.immersivetechnology.ImmersiveTechnology;
import mctmods.immersivetechnology.api.ITUtils;
import mctmods.immersivetechnology.api.client.MechanicalEnergyAnimation;
import mctmods.immersivetechnology.common.Config;
import mctmods.immersivetechnology.common.blocks.ITBlockInterfaces;
import mctmods.immersivetechnology.common.blocks.metal.tileentities.TileEntityAlternatorSlave;
import mctmods.immersivetechnology.common.util.ITSounds;
import mctmods.immersivetechnology.common.util.network.BinaryMessageTileSync;
import mctmods.immersivetechnology.common.util.network.IBinaryMessageReceiver;
import mctmods.immersivetechnology.common.util.network.MessageStopSound;
import mctmods.immersivetechnology.common.util.sound.ITSoundHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityAlternatorMaster
extends TileEntityAlternatorSlave
implements IBinaryMessageReceiver,
IEBlockInterfaces.IComparatorOverride {
    private static int maxSpeed = Config.ITConfig.MechanicalEnergy.mechanicalEnergy_speed_max;
    private static int rfPerTick = Config.ITConfig.Machines.Alternator.alternator_energy_perTick;
    private static double rfExponent = Config.ITConfig.Machines.Alternator.alternator_exponent;
    private static double rfThreshold = Config.ITConfig.Machines.Alternator.alternator_threshold;
    private static int rfPerTickPerPort = rfPerTick / 6;
    private static int speedLossPerTick = Config.ITConfig.Machines.SteamTurbine.steamTurbine_speed_lossPerTick;
    private static boolean soundRPM = Config.ITConfig.Machines.Alternator.alternator_sound_RPM;
    public FluxStorage energyStorage = new FluxStorage(Config.ITConfig.Machines.Alternator.alternator_energy_capacitorSize, rfPerTick, rfPerTickPerPort);
    private BlockPos[] EnergyOutputPositions = new BlockPos[6];
    public int speed;
    public float torqueMult = 1.0f;
    public ITBlockInterfaces.IMechanicalEnergy provider;
    private int clientUpdateCooldown = 20;
    private float clientEnergyPercentage;
    private int oldEnergy = this.energyStorage.getEnergyStored();
    private int oldSpeed = maxSpeed;
    MechanicalEnergyAnimation animation = new MechanicalEnergyAnimation();
    EnergyHelper.IEForgeEnergyWrapper wrapper = new EnergyHelper.IEForgeEnergyWrapper((EnergyHelper.IIEInternalFluxConnector)this, null);

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.energyStorage.readFromNBT(nbt);
        this.animation.readFromNBT(nbt);
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        this.energyStorage.writeToNBT(nbt);
        this.animation.writeToNBT(nbt);
    }

    public int energyGenerated() {
        if ((double)this.speed / (double)maxSpeed > rfThreshold) {
            return (int)Math.round(Math.pow((double)this.speed / (double)maxSpeed, rfExponent) * (double)this.torqueMult * (double)rfPerTick);
        }
        return 0;
    }

    public void handleSounds() {
        BlockPos center = this.func_174877_v();
        if (this.clientEnergyPercentage == 0.0f) {
            ITSoundHandler.StopSound(center);
        } else {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            float attenuation = Math.max((float)player.func_70092_e((double)center.func_177958_n(), (double)center.func_177956_o(), (double)center.func_177952_p()) / 8.0f, 1.0f);
            float level = ITUtils.remapRange(0.0f, 1.0f, 0.5f, 1.0f, this.clientEnergyPercentage);
            ITSounds.alternator.PlayRepeating(center, 5.0f * this.clientEnergyPercentage / attenuation, level);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onChunkUnload() {
        ITSoundHandler.StopSound(this.func_174877_v());
        super.onChunkUnload();
    }

    public void disassemble() {
        super.disassemble();
        BlockPos center = this.func_174877_v();
        ImmersiveTechnology.packetHandler.sendToAllTracking((IMessage)new MessageStopSound(center), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)center.func_177958_n(), (double)center.func_177956_o(), (double)center.func_177952_p(), 0.0));
    }

    public void notifyNearbyClients() {
        BlockPos center = this.func_174877_v();
        ImmersiveTechnology.packetHandler.sendToAllTracking((IMessage)new BinaryMessageTileSync(center, Unpooled.copyInt((int[])new int[]{this.energyStorage.getEnergyStored(), this.speed})), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)center.func_177958_n(), (double)center.func_177956_o(), (double)center.func_177952_p(), 0.0));
    }

    public void efficientMarkDirty() {
        this.field_145850_b.func_175726_f(this.func_174877_v()).func_76630_e();
    }

    public void checkProvider() {
        ITBlockInterfaces.IMechanicalEnergy possibleProvider;
        TileEntity tile;
        if ((this.provider == null || !this.provider.isValid()) && (tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177967_a(this.facing, 4))) instanceof ITBlockInterfaces.IMechanicalEnergy && (possibleProvider = (ITBlockInterfaces.IMechanicalEnergy)tile).isValid() && possibleProvider.isMechanicalEnergyTransmitter(this.facing.func_176734_d())) {
            this.provider = possibleProvider;
        }
        if (this.provider != null) {
            this.speed = this.provider.getSpeed();
            this.torqueMult = this.provider.getTorqueMultiplier();
        } else if (this.speed > 0) {
            this.speed = Math.max(this.speed - speedLossPerTick, 0);
        }
    }

    @Override
    public void func_73660_a() {
        if (!this.formed) {
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            this.checkProvider();
            if (this.speed > 0) {
                this.energyStorage.modifyEnergyStored(this.energyGenerated());
            }
            int currentEnergy = this.energyStorage.getEnergyStored();
            int transferRate = (int)Math.ceil((float)rfPerTickPerPort * this.torqueMult);
            for (int i = 0; i < 6 && currentEnergy != 0; ++i) {
                int canReceiveAmount;
                EnumFacing energyFacing;
                if (this.EnergyOutputPositions[i] == null) {
                    this.EnergyOutputPositions[i] = ITUtils.LocalOffsetToWorldBlockPos(this.func_174877_v(), i < 3 ? -2 : 2, i < 3 ? i - 1 : i - 4, 0, this.facing);
                }
                TileEntity tileEntity = Utils.getExistingTileEntity((World)this.field_145850_b, (BlockPos)this.EnergyOutputPositions[i]);
                EnumFacing enumFacing = energyFacing = i < 3 ? this.facing.func_176746_e() : this.facing.func_176735_f();
                if (!EnergyHelper.isFluxReceiver((TileEntity)tileEntity, (EnumFacing)energyFacing) || (canReceiveAmount = EnergyHelper.insertFlux((TileEntity)tileEntity, (EnumFacing)energyFacing, (int)Math.min(currentEnergy, transferRate), (boolean)true)) == 0) continue;
                EnergyHelper.insertFlux((TileEntity)tileEntity, (EnumFacing)energyFacing, (int)canReceiveAmount, (boolean)false);
                this.energyStorage.modifyEnergyStored(-canReceiveAmount);
                currentEnergy = this.energyStorage.getEnergyStored();
            }
            if (this.clientUpdateCooldown > 0) {
                --this.clientUpdateCooldown;
            }
            if (this.oldEnergy != currentEnergy || this.oldSpeed != this.speed) {
                this.efficientMarkDirty();
                this.markContainingBlockForUpdate(null);
                this.notifyNearbyClients();
                this.clientUpdateCooldown = 20;
            } else if (this.clientUpdateCooldown == 0) {
                this.notifyNearbyClients();
                this.clientUpdateCooldown = 20;
            }
            this.oldEnergy = currentEnergy;
            this.oldSpeed = this.speed;
        } else {
            this.handleSounds();
        }
    }

    @Override
    public boolean isDummy() {
        return false;
    }

    @Override
    public TileEntityAlternatorMaster master() {
        this.master = this;
        return this;
    }

    @Override
    public void receiveMessageFromServer(ByteBuf buf) {
        int energy = buf.readInt();
        int speed = buf.readInt();
        this.clientEnergyPercentage = !soundRPM ? (float)energy / (float)this.energyStorage.getMaxEnergyStored() : (float)speed / (float)maxSpeed;
    }

    public boolean isMechanicalEnergyReceiver(EnumFacing facing, int position) {
        return this.facing == facing && position == 22;
    }

    public int getComparatorInputOverride() {
        return 15 * this.energyStorage.getEnergyStored() / this.energyStorage.getMaxEnergyStored();
    }
}

