/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.blocks.metal.tileentities;

import blusunrize.immersiveengineering.common.util.Utils;
import mctmods.immersivetechnology.ImmersiveTechnology;
import mctmods.immersivetechnology.api.ITUtils;
import mctmods.immersivetechnology.api.crafting.RadiatorRecipe;
import mctmods.immersivetechnology.common.Config;
import mctmods.immersivetechnology.common.blocks.metal.tileentities.TileEntityRadiatorSlave;
import mctmods.immersivetechnology.common.util.ITFluidTank;
import mctmods.immersivetechnology.common.util.ITSounds;
import mctmods.immersivetechnology.common.util.compat.ITCompatModule;
import mctmods.immersivetechnology.common.util.compat.advancedrocketry.AdvancedRocketryHelper;
import mctmods.immersivetechnology.common.util.network.MessageStopSound;
import mctmods.immersivetechnology.common.util.sound.ITSoundHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityRadiatorMaster
extends TileEntityRadiatorSlave
implements ITFluidTank.TankListener {
    private static int inputTankSize = Config.ITConfig.Machines.Radiator.radiator_input_tankSize;
    private static int outputTankSize = Config.ITConfig.Machines.Radiator.radiator_output_tankSize;
    private static float speedMult = Config.ITConfig.Machines.Radiator.radiator_speed_multiplier;
    BlockPos fluidOutputPos;
    public FluidTank[] tanks = new FluidTank[]{new ITFluidTank(inputTankSize, this), new ITFluidTank(outputTankSize, this)};
    public int recipeTimeRemaining = 0;
    private int clientUpdateCooldown = 20;
    private double radiationEfficiency = 0.0;
    private RadiatorRecipe lastRecipe;

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.tanks[0].readFromNBT(nbt.func_74775_l("tank0"));
        this.tanks[1].readFromNBT(nbt.func_74775_l("tank1"));
        this.recipeTimeRemaining = nbt.func_74762_e("recipeTimeRemaining");
        this.radiationEfficiency = nbt.func_74769_h("radiationEfficiency");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        nbt.func_74782_a("tank0", (NBTBase)this.tanks[0].writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("tank1", (NBTBase)this.tanks[1].writeToNBT(new NBTTagCompound()));
        nbt.func_74768_a("recipeTimeRemaining", this.recipeTimeRemaining);
        nbt.func_74780_a("radiationEfficiency", this.radiationEfficiency);
    }

    private boolean gainProgress() {
        if (this.lastRecipe == null) {
            this.recipeTimeRemaining = 0;
            return true;
        }
        --this.recipeTimeRemaining;
        if (this.recipeTimeRemaining == 0) {
            int[] fluidAmounts = this.getProcessedFluidAmounts(this.lastRecipe);
            this.tanks[0].drain(fluidAmounts[0], true);
            this.tanks[1].fillInternal(new FluidStack(this.lastRecipe.fluidOutput.getFluid(), fluidAmounts[1]), true);
            this.markContainingBlockForUpdate(null);
            return true;
        }
        return false;
    }

    private void checkReflectorEfficiency() {
        this.radiationEfficiency = this.mirrored ? this.checkLineEfficiency(-2) + this.checkLineEfficiency(2) : this.checkRowEfficiency(-2) + this.checkRowEfficiency(2);
    }

    private double checkRowEfficiency(int offsetY) {
        double halfEfficiency = 0.0;
        BlockPos pos2 = this.func_174877_v().func_177967_a(this.facing, 1).func_177982_a(0, offsetY, 0);
        halfEfficiency += this.checkColumnEfficiency(pos2, this.facing.func_176746_e()) / 12.0;
        halfEfficiency += this.checkColumnEfficiency(pos2, this.facing.func_176735_f()) / 12.0;
        pos2 = this.func_174877_v().func_177967_a(this.facing, 3);
        halfEfficiency += this.checkColumnEfficiency(pos2, this.facing.func_176746_e()) / 12.0;
        halfEfficiency += this.checkColumnEfficiency(pos2, this.facing.func_176735_f()) / 12.0;
        pos2 = this.func_174877_v().func_177967_a(this.facing, 3);
        halfEfficiency += this.checkColumnEfficiency(pos2, this.facing.func_176746_e()) / 12.0;
        return halfEfficiency += this.checkColumnEfficiency(pos2, this.facing.func_176735_f()) / 12.0;
    }

    private double checkLineEfficiency(int offsetX) {
        double halfEfficiency = 0.0;
        BlockPos pos2 = this.func_174877_v().func_177967_a(this.facing, 1).func_177967_a(this.facing.func_176746_e(), offsetX);
        halfEfficiency += this.checkColumnEfficiency(pos2, EnumFacing.DOWN) / 12.0;
        halfEfficiency += this.checkColumnEfficiency(pos2, EnumFacing.UP) / 12.0;
        pos2 = this.func_174877_v().func_177967_a(this.facing, 3);
        halfEfficiency += this.checkColumnEfficiency(pos2, EnumFacing.DOWN) / 12.0;
        halfEfficiency += this.checkColumnEfficiency(pos2, EnumFacing.UP) / 12.0;
        pos2 = this.func_174877_v().func_177967_a(this.facing, 3);
        halfEfficiency += this.checkColumnEfficiency(pos2, EnumFacing.DOWN) / 12.0;
        return halfEfficiency += this.checkColumnEfficiency(pos2, EnumFacing.UP) / 12.0;
    }

    private double checkColumnEfficiency(BlockPos pos, EnumFacing facing) {
        double j = 1.0;
        for (int i = 1; i < 49; ++i) {
            if (this.field_145850_b.func_180495_p(pos.func_177967_a(facing, i)).func_177230_c() == Blocks.field_150350_a) continue;
            j = 1.0 / (double)((49 - i) * (49 - i));
            break;
        }
        return j;
    }

    private double getTotalRadiationEfficiency(int inputFluidTemperature) {
        if (this.field_145850_b.field_73011_w.func_177495_o()) {
            return 0.0;
        }
        return ITCompatModule.isAdvancedRocketryLoaded ? AdvancedRocketryHelper.getRadiatorHeatTransferCoefficient(this.field_145850_b, this.func_174877_v(), inputFluidTemperature, this.radiationEfficiency) : this.radiationEfficiency;
    }

    private void pumpOutputOut() {
        IFluidHandler output;
        if (this.tanks[1].getFluidAmount() == 0) {
            return;
        }
        if (this.fluidOutputPos == null) {
            this.fluidOutputPos = ITUtils.LocalOffsetToWorldBlockPos(this.func_174877_v(), 0, 0, 9, this.facing);
        }
        if ((output = FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)this.fluidOutputPos, (EnumFacing)this.facing.func_176734_d())) == null) {
            return;
        }
        FluidStack out = this.tanks[1].getFluid();
        int accepted = output.fill(out, false);
        if (accepted == 0) {
            return;
        }
        int drained = output.fill(Utils.copyFluidStackWithAmount((FluidStack)out, (int)Math.min(out.amount, accepted), (boolean)false), true);
        this.tanks[1].drain(drained, true);
    }

    public int[] getProcessedFluidAmounts(RadiatorRecipe recipe) {
        int inputToOutputRatio = recipe.fluidInput.amount / recipe.fluidOutput.amount;
        int outputFluidAmount = (int)(this.getTotalRadiationEfficiency(recipe.fluidInput.getFluid().getTemperature()) * (double)recipe.fluidOutput.amount);
        int inputFluidAmount = inputToOutputRatio * outputFluidAmount;
        return new int[]{inputFluidAmount, outputFluidAmount};
    }

    public void handleSounds() {
        BlockPos center = this.func_174877_v();
        float level = this.tickedProcesses;
        if (level == 0.0f) {
            ITSoundHandler.StopSound(center);
        } else {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            float attenuation = Math.max((float)player.func_70092_e((double)center.func_177958_n(), (double)center.func_177956_o(), (double)center.func_177952_p()) / 8.0f, 1.0f);
            ITSounds.solarTower.PlayRepeating(center, 2.0f * level / attenuation, level);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onChunkUnload() {
        if (!this.isDummy()) {
            ITSoundHandler.StopSound(this.func_174877_v());
        }
        super.onChunkUnload();
    }

    @Override
    public void disassemble() {
        BlockPos center = this.func_174877_v();
        ImmersiveTechnology.packetHandler.sendToAllTracking((IMessage)new MessageStopSound(center), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)center.func_177958_n(), (double)center.func_177956_o(), (double)center.func_177952_p(), 0.0));
        super.disassemble();
    }

    public void efficientMarkDirty() {
        this.field_145850_b.func_175726_f(this.func_174877_v()).func_76630_e();
    }

    private boolean recipeLogic() {
        boolean update = false;
        if (this.recipeTimeRemaining > 0) {
            if (this.gainProgress()) {
                update = true;
            }
        } else if (this.tanks[0].getFluid() != null) {
            RadiatorRecipe recipe;
            RadiatorRecipe radiatorRecipe = recipe = this.lastRecipe != null && this.tanks[0].getFluid().isFluidEqual(this.lastRecipe.fluidInput) ? this.lastRecipe : RadiatorRecipe.findRecipe(this.tanks[0].getFluid());
            if (recipe != null && recipe.fluidInput.amount <= this.tanks[0].getFluidAmount() && recipe.fluidOutput.amount == this.tanks[1].fillInternal(recipe.fluidOutput, false)) {
                this.lastRecipe = recipe;
                this.recipeTimeRemaining = (int)((float)recipe.getTotalProcessTime() / speedMult);
                this.gainProgress();
                update = true;
            }
        }
        return update;
    }

    private boolean outputTankLogic() {
        boolean update = false;
        if (this.tanks[1].getFluidAmount() > 0) {
            this.pumpOutputOut();
        }
        return update;
    }

    @Override
    public void func_73660_a() {
        if (!this.formed) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            this.handleSounds();
            return;
        }
        if (this.field_145850_b.func_82737_E() % 600L == 0L) {
            this.checkReflectorEfficiency();
        }
        boolean update = this.recipeLogic();
        if (this.outputTankLogic()) {
            update = true;
        }
        if (this.clientUpdateCooldown > 1) {
            --this.clientUpdateCooldown;
        }
        if (update) {
            this.efficientMarkDirty();
            if (this.clientUpdateCooldown == 1) {
                this.clientUpdateCooldown = 20;
            }
        }
    }

    @Override
    public void TankContentsChanged() {
        this.markContainingBlockForUpdate(null);
    }

    @Override
    public boolean isDummy() {
        return false;
    }

    @Override
    public TileEntityRadiatorMaster master() {
        this.master = this;
        return this;
    }
}

