/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.tileentities;

import blusunrize.immersiveengineering.api.fluid.IFluidPipe;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.util.Utils;
import javax.annotation.Nullable;
import mctmods.immersivetechnology.client.gui.GuiFluidValve;
import mctmods.immersivetechnology.common.tileentities.TileEntityCommonValve;
import mctmods.immersivetechnology.common.util.TranslationKey;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityFluidValve
extends TileEntityCommonValve
implements IFluidHandler,
IFluidPipe,
IEBlockInterfaces.IBlockBounds {
    public static DummyTank dummyTank = new DummyTank();
    IFluidTankProperties[] tank = new IFluidTankProperties[]{new FluidTankProperties(null, Integer.MAX_VALUE, true, false)};
    boolean busy = false;

    public TileEntityFluidValve() {
        super(TranslationKey.OVERLAY_OSD_FLUID_VALVE_NORMAL_FIRST_LINE, TranslationKey.OVERLAY_OSD_FLUID_VALVE_SNEAKING_FIRST_LINE, TranslationKey.OVERLAY_OSD_FLUID_VALVE_SNEAKING_SECOND_LINE, 6);
    }

    public boolean canOutputPressurized(boolean consumePower) {
        return false;
    }

    public boolean hasOutputConnection(EnumFacing side) {
        return side == this.facing;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void showGui() {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiFluidValve(this));
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (facing == null) {
            return false;
        }
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && facing.func_176740_k() == this.facing.func_176740_k();
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (facing == null) {
            return null;
        }
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (facing == this.facing) {
                return (T)this;
            }
            if (facing == this.facing.func_176734_d()) {
                return (T)dummyTank;
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.tank;
    }

    public int fill(FluidStack fluidStack, boolean doFill) {
        if (this.busy) {
            return 0;
        }
        IFluidHandler destination = this.getDestination();
        if (destination == null) {
            return 0;
        }
        int canAccept = fluidStack.amount;
        canAccept = this.timeLimit != -1 ? Math.min(Math.max(this.timeLimit - TileEntityFluidValve.longToInt(this.acceptedAmount), 0), canAccept) : canAccept;
        canAccept = this.keepSize != -1 ? Math.min(Math.max(this.keepSize - TileEntityFluidValve.getTankFill(destination.getTankProperties(), fluidStack), 0), canAccept) : canAccept;
        int n = canAccept = this.packetLimit != -1 ? Math.min(canAccept, this.packetLimit) : canAccept;
        if (this.redstoneMode > 0) {
            canAccept = (int)((double)canAccept * ((double)(this.redstoneMode == 1 ? 15 - this.getRSPower() : this.getRSPower()) / 15.0));
        }
        if (canAccept == 0) {
            return 0;
        }
        int toReturn = 0;
        this.busy = true;
        toReturn = destination.fill(new FluidStack(fluidStack, canAccept), doFill);
        this.busy = false;
        if (doFill) {
            this.acceptedAmount += (long)toReturn;
            ++this.packets;
        }
        return toReturn;
    }

    public static int getTankFill(IFluidTankProperties[] properties, FluidStack toFill) {
        int toReturn = 0;
        for (IFluidTankProperties property : properties) {
            FluidStack stored = property.getContents();
            if (stored == null || !stored.isFluidEqual(toFill)) continue;
            toReturn += stored.amount;
        }
        return toReturn;
    }

    @Nullable
    public FluidStack drain(FluidStack fluidStack, boolean b) {
        return null;
    }

    @Nullable
    public FluidStack drain(int i, boolean b) {
        return null;
    }

    public IFluidHandler getDestination() {
        TileEntity dst = Utils.getExistingTileEntity((World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177967_a(this.facing, -1));
        if (dst != null && dst.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.facing)) {
            return (IFluidHandler)dst.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.facing);
        }
        return null;
    }

    public float isX(float ifTrue, float ifFalse) {
        return this.facing.func_176740_k() == EnumFacing.Axis.X ? ifTrue : ifFalse;
    }

    public float isY(float ifTrue, float ifFalse) {
        return this.facing.func_176740_k() == EnumFacing.Axis.Y ? ifTrue : ifFalse;
    }

    public float isZ(float ifTrue, float ifFalse) {
        return this.facing.func_176740_k() == EnumFacing.Axis.Z ? ifTrue : ifFalse;
    }

    public float[] getBlockBounds() {
        return new float[]{this.isX(0.0f, 0.125f), this.isY(0.0f, 0.125f), this.isZ(0.0f, 0.125f), this.isX(1.0f, 0.875f), this.isY(1.0f, 0.875f), this.isZ(1.0f, 0.875f)};
    }

    public static class DummyTank
    implements IFluidHandler,
    IFluidTankProperties {
        IFluidTankProperties[] properties = new IFluidTankProperties[]{this};

        public IFluidTankProperties[] getTankProperties() {
            return this.properties;
        }

        public int fill(FluidStack fluidStack, boolean b) {
            return 0;
        }

        @Nullable
        public FluidStack drain(FluidStack fluidStack, boolean b) {
            return null;
        }

        @Nullable
        public FluidStack drain(int i, boolean b) {
            return null;
        }

        @Nullable
        public FluidStack getContents() {
            return null;
        }

        public int getCapacity() {
            return 0;
        }

        public boolean canFill() {
            return false;
        }

        public boolean canDrain() {
            return false;
        }

        public boolean canFillFluidType(FluidStack fluidStack) {
            return false;
        }

        public boolean canDrainFluidType(FluidStack fluidStack) {
            return false;
        }
    }
}

