/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.util.compat.advancedrocketry;

import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import zmaster587.advancedRocketry.api.ARConfiguration;
import zmaster587.advancedRocketry.atmosphere.AtmosphereHandler;
import zmaster587.advancedRocketry.atmosphere.AtmosphereType;
import zmaster587.advancedRocketry.dimension.DimensionManager;

public class AdvancedRocketryHelper {
    public static double getInsolation(World world, BlockPos pos) {
        return 1.0005 * (AdvancedRocketryHelper.isSpaceStation(world) ? DimensionManager.getEffectiveDimId((World)world, (BlockPos)pos).getPeakInsolationMultiplierWithoutAtmosphere() : DimensionManager.getEffectiveDimId((World)world, (BlockPos)pos).getPeakInsolationMultiplier());
    }

    public static double getHeatTransferCoefficient(World world, BlockPos pos) {
        double planetaryAtmosphereDensity = DimensionManager.getEffectiveDimId((World)world, (BlockPos)pos).getAtmosphereDensity();
        double actualAtmosphereDensity = AdvancedRocketryHelper.isSpaceStation(world) ? 0.0 : planetaryAtmosphereDensity;
        return Math.sqrt((4.0 + actualAtmosphereDensity) / 100.0);
    }

    public static double getRadiatorHeatTransferCoefficient(World world, BlockPos pos, double fluidTemperature, double radiationEfficiency) {
        if (AdvancedRocketryHelper.isAtmosphereArtificial(world, pos)) {
            return 0.0;
        }
        double planetaryAtmosphereDensity = DimensionManager.getEffectiveDimId((World)world, (BlockPos)pos).getAtmosphereDensity();
        double actualAtmosphereDensity = AdvancedRocketryHelper.isSpaceStation(world) ? 0.0 : planetaryAtmosphereDensity;
        double temperature = (double)DimensionManager.getEffectiveDimId((World)world, (BlockPos)pos).averageTemperature * (AdvancedRocketryHelper.isSpaceStation(world) ? 1.0 / Math.max(1.0, 1.125 * Math.pow(planetaryAtmosphereDensity / 100.0, 0.25)) : 1.0);
        if (temperature > fluidTemperature) {
            return 0.0;
        }
        double deltaTemperatureRatio = (fluidTemperature - temperature) / 212.9671;
        return (radiationEfficiency + 3.0 * Math.sqrt(actualAtmosphereDensity / 100.0)) * Math.pow(deltaTemperatureRatio, 4.0);
    }

    public static boolean isAtmosphereSuitableForCombustion(World world, BlockPos pos) {
        return !AtmosphereHandler.hasAtmosphereHandler((int)world.field_73011_w.getDimension()) || AtmosphereHandler.getOxygenHandler((int)world.field_73011_w.getDimension()).getAtmosphereType(pos).allowsCombustion();
    }

    public static double getWaterPartialPressureMultiplier(World world, BlockPos pos) {
        return (double)DimensionManager.getEffectiveDimId((World)world, (BlockPos)pos).getAtmosphereDensity() / 100.0;
    }

    public static boolean isAtmosphereUnsuitableForCooling(World world, BlockPos pos) {
        return AtmosphereHandler.hasAtmosphereHandler((int)world.field_73011_w.getDimension()) && (AdvancedRocketryHelper.isAtmosphereArtificial(world, pos) || AtmosphereHandler.getOxygenHandler((int)world.field_73011_w.getDimension()).getAtmosphereType(pos) == AtmosphereType.VACUUM);
    }

    public static boolean isAtmosphereArtificial(World world, BlockPos pos) {
        return AtmosphereHandler.hasAtmosphereHandler((int)world.field_73011_w.getDimension()) && AtmosphereHandler.getOxygenHandler((int)world.field_73011_w.getDimension()).getAtmosphereType(pos) == AtmosphereType.PRESSURIZEDAIR;
    }

    public static boolean isSpaceStation(World world) {
        return world.field_73011_w.getDimension() == ARConfiguration.getCurrentConfig().spaceDimId;
    }
}

