/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.util.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.ArrayList;
import java.util.Iterator;
import mctmods.immersivetechnology.api.crafting.GasTurbineRecipe;
import mctmods.immersivetechnology.common.util.compat.crafttweaker.CraftTweakerHelper;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.immersivetechnology.GasTurbine")
public class GasTurbine {
    @ZenMethod
    public static void addFuel(ILiquidStack outputFluid, ILiquidStack inputFluid, int time) {
        FluidStack fluidOut = CraftTweakerHelper.toFluidStack(outputFluid);
        FluidStack fluidIn = CraftTweakerHelper.toFluidStack(inputFluid);
        if (fluidIn == null) {
            return;
        }
        GasTurbineRecipe recipe = new GasTurbineRecipe(fluidOut, fluidIn, time);
        CraftTweakerAPI.apply((IAction)new Add(recipe));
    }

    @ZenMethod
    public static void removeFuel(ILiquidStack inputFluid) {
        if (CraftTweakerHelper.toFluidStack(inputFluid) != null) {
            CraftTweakerAPI.apply((IAction)new Remove(CraftTweakerHelper.toFluidStack(inputFluid)));
        }
    }

    private static class Remove
    implements IAction {
        private final FluidStack inputFluid;
        ArrayList<GasTurbineRecipe> removedRecipes = new ArrayList();

        public Remove(FluidStack inputFluid) {
            this.inputFluid = inputFluid;
        }

        public void apply() {
            Iterator<GasTurbineRecipe> iterator = GasTurbineRecipe.recipeList.iterator();
            while (iterator.hasNext()) {
                GasTurbineRecipe recipe = iterator.next();
                if (recipe == null || !recipe.fluidInput.isFluidEqual(this.inputFluid)) continue;
                this.removedRecipes.add(recipe);
                iterator.remove();
            }
        }

        public String describe() {
            return "Removing Gas Turbine Fuel for " + this.inputFluid.getLocalizedName();
        }
    }

    private static class Add
    implements IAction {
        public GasTurbineRecipe recipe;

        public Add(GasTurbineRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            GasTurbineRecipe.recipeList.add(this.recipe);
        }

        public String describe() {
            if (this.recipe.fluidOutput == null) {
                return "Adding Gas Turbine Fuel for " + this.recipe.fluidInput.getLocalizedName();
            }
            return "Adding Gas Turbine Fuel for " + this.recipe.fluidInput.getLocalizedName() + " -> " + this.recipe.fluidOutput.getLocalizedName();
        }
    }
}

