/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.util.compat.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.liquid.ILiquidStack;
import java.util.ArrayList;
import java.util.Iterator;
import mctmods.immersivetechnology.api.crafting.RadiatorRecipe;
import mctmods.immersivetechnology.common.util.compat.crafttweaker.CraftTweakerHelper;
import net.minecraftforge.fluids.FluidStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.immersivetechnology.Radiator")
public class Radiator {
    @ZenMethod
    public static void addRecipe(ILiquidStack outputFluid, ILiquidStack inputFluid, int time) {
        FluidStack fluidOut = CraftTweakerHelper.toFluidStack(outputFluid);
        FluidStack fluidIn = CraftTweakerHelper.toFluidStack(inputFluid);
        if (fluidOut == null || fluidIn == null) {
            return;
        }
        RadiatorRecipe recipe = new RadiatorRecipe(fluidOut, fluidIn, time);
        CraftTweakerAPI.apply((IAction)new Add(recipe));
    }

    @ZenMethod
    public static void removeRecipe(ILiquidStack inputFluid) {
        if (CraftTweakerHelper.toFluidStack(inputFluid) != null) {
            CraftTweakerAPI.apply((IAction)new Remove(CraftTweakerHelper.toFluidStack(inputFluid)));
        }
    }

    private static class Remove
    implements IAction {
        private final FluidStack inputFluid;
        ArrayList<RadiatorRecipe> removedRecipes = new ArrayList();

        public Remove(FluidStack inputFluid) {
            this.inputFluid = inputFluid;
        }

        public void apply() {
            Iterator<RadiatorRecipe> iterator = RadiatorRecipe.recipeList.iterator();
            while (iterator.hasNext()) {
                RadiatorRecipe recipe = iterator.next();
                if (recipe == null || !recipe.fluidInput.isFluidEqual(this.inputFluid)) continue;
                this.removedRecipes.add(recipe);
                iterator.remove();
            }
        }

        public String describe() {
            return "Removing Radiator Input Recipe for " + this.inputFluid.getLocalizedName();
        }
    }

    private static class Add
    implements IAction {
        public RadiatorRecipe recipe;

        public Add(RadiatorRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            RadiatorRecipe.recipeList.add(this.recipe);
        }

        public String describe() {
            return "Adding Radiator Recipe for " + this.recipe.fluidInput.getLocalizedName() + " -> " + this.recipe.fluidOutput.getLocalizedName();
        }
    }
}

