/*
 * Decompiled with CFR 0.152.
 */
package mctmods.immersivetechnology.common.util.compat.jei.solartower;

import java.util.Iterator;
import java.util.List;
import mctmods.immersivetechnology.api.crafting.SolarTowerRecipe;
import mctmods.immersivetechnology.common.util.compat.jei.GenericMultiblockIngredient;
import mctmods.immersivetechnology.common.util.compat.jei.ITRecipeCategory;
import mctmods.immersivetechnology.common.util.compat.jei.JEIHelper;
import mctmods.immersivetechnology.common.util.compat.jei.solartower.SolarTowerRecipeWrapper;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SolarTowerRecipeCategory
extends ITRecipeCategory<SolarTowerRecipe, SolarTowerRecipeWrapper> {
    public static ResourceLocation background = new ResourceLocation("immersivetech:textures/gui/gui_solar_tower_jei.png");
    private final IDrawable tankOverlay;
    private final IDrawable reflectorOverlay;
    private ITickTimer timer;

    public SolarTowerRecipeCategory(IGuiHelper helper) {
        super("solarTower", "tile.immersivetech.metal_multiblock.solar_tower.name", (IDrawable)helper.createDrawable(background, 0, 0, 176, 77), SolarTowerRecipe.class, GenericMultiblockIngredient.SOLAR_TOWER);
        this.tankOverlay = helper.createDrawable(background, 177, 31, 16, 47, -2, 2, -2, 2);
        this.reflectorOverlay = helper.createDrawable(background, 198, 31, 10, 10, 0, 0, 0, 0);
        this.timer = helper.createTickTimer(200, 3, false);
    }

    public void setRecipe(IRecipeLayout recipeLayout, SolarTowerRecipeWrapper recipeWrapper, IIngredients ingredients) {
        List inputs = ingredients.getInputs(FluidStack.class);
        int tankCapacity = 0;
        for (Object stacks : inputs) {
            Iterator iterator = stacks.iterator();
            while (iterator.hasNext()) {
                FluidStack stack = (FluidStack)iterator.next();
                if (stack.amount <= tankCapacity) continue;
                tankCapacity = stack.amount;
            }
        }
        List outputs = ingredients.getOutputs(FluidStack.class);
        for (List stacks : outputs) {
            for (FluidStack stack : stacks) {
                if (stack.amount <= tankCapacity) continue;
                tankCapacity = stack.amount;
            }
        }
        IGuiFluidStackGroup guiFluidStacks = recipeLayout.getFluidStacks();
        if (inputs.size() > 0) {
            guiFluidStacks.init(0, true, 102, 21, 16, 47, tankCapacity, false, this.tankOverlay);
            guiFluidStacks.set(0, (List)inputs.get(0));
        }
        guiFluidStacks.init(1, false, 126, 21, 16, 47, tankCapacity, false, this.tankOverlay);
        guiFluidStacks.set(1, (List)outputs.get(0));
        guiFluidStacks.addTooltipCallback(JEIHelper.fluidTooltipCallback);
        recipeWrapper.timer = this.timer;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawExtras(Minecraft minecraft) {
        int reflectors = this.timer.getValue();
        this.reflectorOverlay.draw(minecraft, 32, 24);
        if (reflectors >= 1) {
            this.reflectorOverlay.draw(minecraft, 16, 40);
        }
        if (reflectors >= 2) {
            this.reflectorOverlay.draw(minecraft, 48, 40);
        }
        if (reflectors == 3) {
            this.reflectorOverlay.draw(minecraft, 32, 56);
        }
    }

    public IRecipeWrapper getRecipeWrapper(SolarTowerRecipe recipe) {
        return new SolarTowerRecipeWrapper(recipe);
    }
}

