/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.handler.season;

import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockReed;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sereneseasons.api.SSBlocks;
import sereneseasons.config.FertilityConfig;
import sereneseasons.init.ModFertility;

public class SeasonalCropGrowthHandler {
    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onItemTooltipAdded(ItemTooltipEvent event) {
        ModFertility.setupTooltips(event);
    }

    @SubscribeEvent
    public void onCropGrowth(BlockEvent.CropGrowEvent event) {
        Block plant = event.getState().func_177230_c();
        boolean isFertile = ModFertility.isCropFertile(plant.getRegistryName().toString(), event.getWorld(), event.getPos());
        if (FertilityConfig.general_category.seasonal_crops && !isFertile && !this.isGreenhouseGlassAboveBlock(event.getWorld(), event.getPos())) {
            if (FertilityConfig.general_category.crops_break && !(plant instanceof BlockGrass) && !(plant instanceof BlockReed)) {
                event.getWorld().func_175655_b(event.getPos(), true);
            } else {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public void onApplyBonemeal(BonemealEvent event) {
        Block plant = event.getBlock().func_177230_c();
        boolean isFertile = ModFertility.isCropFertile(plant.getRegistryName().toString(), event.getWorld(), event.getPos());
        if (FertilityConfig.general_category.seasonal_crops && !isFertile && !this.isGreenhouseGlassAboveBlock(event.getWorld(), event.getPos())) {
            if (FertilityConfig.general_category.crops_break && !(plant instanceof BlockGrass) && !(plant instanceof BlockReed)) {
                event.getWorld().func_175655_b(event.getPos(), true);
            }
            event.setCanceled(true);
        }
    }

    private boolean isGreenhouseGlassAboveBlock(World world, BlockPos cropPos) {
        for (int i = 0; i < FertilityConfig.general_category.greenhouse_glass_max_height; ++i) {
            if (!world.func_180495_p(cropPos.func_177982_a(0, i + 1, 0)).func_177230_c().equals(SSBlocks.greenhouse_glass)) continue;
            return true;
        }
        return false;
    }
}

