/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.command;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import toughasnails.api.TANCapabilities;
import toughasnails.api.TANPotions;
import toughasnails.api.config.GameplayOption;
import toughasnails.api.config.SyncedConfig;
import toughasnails.api.temperature.Temperature;
import toughasnails.api.temperature.TemperatureScale;
import toughasnails.temperature.TemperatureDebugger;
import toughasnails.temperature.TemperatureHandler;

public class TANCommand
extends CommandBase {
    public String func_71517_b() {
        return "toughasnails";
    }

    public List func_71514_a() {
        return Lists.newArrayList((Object[])new String[]{"tan"});
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.toughasnails.usage";
    }

    public int func_82362_a() {
        return 2;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 1) {
            throw new WrongUsageException("commands.toughasnails.usage", new Object[0]);
        }
        if ("tempinfo".equals(args[0])) {
            this.displayTemperatureInfo(sender, args);
        } else if ("settemp".equals(args[0])) {
            this.setTemperature(sender, args);
        }
    }

    private void displayTemperatureInfo(ICommandSender sender, String[] args) throws CommandException {
        EntityPlayerMP player = TANCommand.func_71521_c((ICommandSender)sender);
        TemperatureHandler temperatureStats = (TemperatureHandler)player.getCapability(TANCapabilities.TEMPERATURE, null);
        TemperatureDebugger debugger = temperatureStats.debugger;
        if (SyncedConfig.getBooleanValue(GameplayOption.ENABLE_TEMPERATURE)) {
            debugger.setGuiVisible(!debugger.isGuiVisible(), player);
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.toughasnails.settemp.disabled", new Object[0]));
        }
    }

    private void setTemperature(ICommandSender sender, String[] args) throws CommandException {
        EntityPlayerMP player = TANCommand.func_71521_c((ICommandSender)sender);
        TemperatureHandler temperatureStats = (TemperatureHandler)player.getCapability(TANCapabilities.TEMPERATURE, null);
        int newTemp = TANCommand.func_175764_a((String)args[1], (int)0, (int)TemperatureScale.getScaleTotal());
        Temperature playerTemp = temperatureStats.getTemperature();
        if (SyncedConfig.getBooleanValue(GameplayOption.ENABLE_TEMPERATURE)) {
            player.func_184589_d(TANPotions.hypothermia);
            player.func_184589_d(TANPotions.hyperthermia);
            temperatureStats.setChangeTime(0);
            temperatureStats.setTemperature(new Temperature(newTemp));
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.toughasnails.settemp.success", new Object[]{newTemp}));
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.toughasnails.settemp.disabled", new Object[0]));
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length == 1) {
            return TANCommand.func_71530_a((String[])args, (String[])new String[]{"settemp", "tempinfo"});
        }
        return null;
    }
}

