/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.config.json;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import toughasnails.core.ToughAsNails;

public class ArmorTemperatureData {
    @SerializedName(value="names")
    public List<String> names;
    @SerializedName(value="modifier")
    public int modifier;
    @SerializedName(value="nbts")
    public List<String> nbts;
    private List<NBTTagCompound> nbtTagCompounds;

    public ArmorTemperatureData(@Nonnull List<String> names, int modifier, @Nonnull List<String> nbts) {
        this.names = names;
        this.modifier = modifier;
        this.nbts = nbts;
    }

    public ArmorTemperatureData(@Nonnull List<String> names, int modifier) {
        this(names, modifier, null);
    }

    public List<NBTTagCompound> getNBTTagCompounds() {
        if (this.nbtTagCompounds == null) {
            ArrayList<Object> compound = new ArrayList<Object>();
            if (this.nbts == null) {
                for (int i = 0; i < 4; ++i) {
                    compound.add(null);
                }
            } else {
                this.nbts.forEach(nbt -> {
                    try {
                        compound.add(JsonToNBT.func_180713_a((String)nbt));
                    }
                    catch (NBTException e) {
                        ToughAsNails.logger.error("Failed to parse NBT tag for ArmorTemperatureData: adding null NBT.  This is likely an error. (First armor name: " + this.names.get(0) + ")");
                    }
                });
            }
            this.nbtTagCompounds = Collections.unmodifiableList(compound);
        }
        return this.nbtTagCompounds;
    }
}

