/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.temperature.modifier;

import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import toughasnails.api.temperature.IModifierMonitor;
import toughasnails.api.temperature.Temperature;
import toughasnails.init.ModConfig;
import toughasnails.temperature.modifier.TemperatureModifier;
import toughasnails.util.BiomeUtils;
import toughasnails.util.TerrainUtils;

public class TimeModifier
extends TemperatureModifier {
    public TimeModifier(String id) {
        super(id);
    }

    @Override
    public Temperature applyEnvironmentModifiers(World world, BlockPos pos, Temperature initialTemperature, IModifierMonitor monitor) {
        int temperatureLevel;
        Biome biome = world.func_180494_b(pos);
        long worldTime = world.func_72820_D();
        float extremityModifier = BiomeUtils.getBiomeTempExtremity(biome);
        float timeNorm = (-Math.abs((float)(worldTime + 6000L) % 24000.0f - 12000.0f) + 6000.0f) / 6000.0f;
        int newTemperatureLevel = temperatureLevel = initialTemperature.getRawValue();
        if (world.field_73011_w.func_76569_d() && (timeNorm < 0.0f && ModConfig.temperature.enableNightTimeModifier || timeNorm > 0.0f && ModConfig.temperature.enableDayTimeModifier)) {
            int temperatureModifier = (int)((float)ModConfig.temperature.timeModifier * timeNorm * Math.max(1.0f, extremityModifier * ModConfig.temperature.timeExtremityMultiplier));
            if (ModConfig.temperature.enableUndergroundEffect) {
                temperatureModifier = Math.round(TerrainUtils.getAverageUndergroundCoefficient(world, pos) * (float)temperatureModifier);
            }
            newTemperatureLevel += temperatureModifier;
        }
        monitor.addEntry(new IModifierMonitor.Context(this.getId(), "Time", initialTemperature, new Temperature(newTemperatureLevel)));
        return new Temperature(newTemperatureLevel);
    }

    @Override
    public boolean isPlayerSpecific() {
        return false;
    }
}

