/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.temperature.modifier;

import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import toughasnails.api.temperature.IModifierMonitor;
import toughasnails.api.temperature.Temperature;
import toughasnails.init.ModCompat;
import toughasnails.init.ModConfig;
import toughasnails.temperature.modifier.TemperatureModifier;

public class WeatherModifier
extends TemperatureModifier {
    public WeatherModifier(String id) {
        super(id);
    }

    @Override
    public Temperature applyPlayerModifiers(EntityPlayer player, Temperature initialTemperature, IModifierMonitor monitor) {
        int temperatureLevel;
        World world = player.field_70170_p;
        int newTemperatureLevel = temperatureLevel = initialTemperature.getRawValue();
        BlockPos playerPos = player.func_180425_c();
        Block block = world.func_180495_p(playerPos).func_177230_c();
        if (player.func_70026_G()) {
            if (block != ModCompat.HOT_SPRING_WATER) {
                monitor.addEntry(new IModifierMonitor.Context(this.getId(), "Wet", initialTemperature, new Temperature(newTemperatureLevel += ModConfig.temperature.wetModifier)));
            }
        } else if (world.func_72896_J() && world.func_175678_i(playerPos) && world.func_180494_b(playerPos).func_76746_c()) {
            monitor.addEntry(new IModifierMonitor.Context(this.getId(), "Snow", initialTemperature, new Temperature(newTemperatureLevel += ModConfig.temperature.snowModifier)));
        }
        return new Temperature(newTemperatureLevel);
    }

    @Override
    public boolean isPlayerSpecific() {
        return true;
    }
}

