/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.schematics;

import buildcraft.api.core.BuildCraftAPI;
import buildcraft.api.schematics.ISchematicEntity;
import buildcraft.api.schematics.SchematicEntityContext;
import buildcraft.api.schematics.SchematicEntityFactory;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.util.ResourceLocation;

public class SchematicEntityFactoryRegistry {
    private static final Set<SchematicEntityFactory<?>> FACTORIES = new TreeSet();

    public static <S extends ISchematicEntity> void registerFactory(String name, int priority, Predicate<SchematicEntityContext> predicate, Supplier<S> supplier) {
        FACTORIES.add(new SchematicEntityFactory<S>(BuildCraftAPI.nameToResourceLocation(name), priority, predicate, supplier));
    }

    public static <S extends ISchematicEntity> void registerFactory(String name, int priority, List<ResourceLocation> entities, Supplier<S> supplier) {
        SchematicEntityFactoryRegistry.registerFactory(name, priority, (SchematicEntityContext context) -> entities.contains(EntityList.func_191301_a((Entity)context.entity)), supplier);
    }

    public static List<SchematicEntityFactory<?>> getFactories() {
        return ImmutableList.copyOf(FACTORIES);
    }

    @Nonnull
    public static <S extends ISchematicEntity> SchematicEntityFactory<S> getFactoryByInstance(S instance) {
        return FACTORIES.stream().filter(schematicEntityFactory -> schematicEntityFactory.clazz == instance.getClass()).findFirst().orElseThrow(() -> new IllegalStateException("Didn't find a factory for " + instance.getClass()));
    }

    @Nullable
    public static SchematicEntityFactory<?> getFactoryByName(ResourceLocation name) {
        return FACTORIES.stream().filter(schematicEntityFactory -> schematicEntityFactory.name.equals((Object)name)).findFirst().orElse(null);
    }
}

