/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy.tile;

import buildcraft.api.core.EnumPipePart;
import buildcraft.api.mj.IMjConnector;
import buildcraft.api.mj.MjAPI;
import buildcraft.api.transport.pipe.IItemPipe;
import buildcraft.core.BCCoreItems;
import buildcraft.energy.BCEnergyGuis;
import buildcraft.lib.BCLibConfig;
import buildcraft.lib.engine.EngineConnector;
import buildcraft.lib.engine.TileEngineBase_BC8;
import buildcraft.lib.misc.EntityUtil;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.lib.tile.item.ItemHandlerManager;
import buildcraft.lib.tile.item.ItemHandlerSimple;
import buildcraft.lib.tile.item.StackInsertionFunction;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class TileEngineRF
extends TileEngineBase_BC8 {
    public static final int MAX_RF = 10000;
    public static final double HEAT_RATE = 0.06;
    public static final double COOLDOWN_RATE = 0.01;
    public static final Map<Item, Long> RF_UPGRADE = new LinkedHashMap<Item, Long>();
    int currentRF;
    public final ItemHandlerSimple invUpgrades;

    public TileEngineRF() {
        this.caps.addCapabilityInstance(CapabilityEnergy.ENERGY, new Rf(), EnumPipePart.VALUES);
        this.invUpgrades = this.itemManager.addInvHandler("upgrades", 4, this::isValidUpgrade, StackInsertionFunction.getInsertionFunction(1), ItemHandlerManager.EnumAccess.NONE, new EnumPipePart[0]);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("currentRF", this.currentRF);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.currentRF = nbt.func_74762_e("currentRF");
    }

    @Override
    public void readPayload(int id, PacketBufferBC buffer, Side side, MessageContext ctx) throws IOException {
        super.readPayload(id, buffer, side, ctx);
        if (side == Side.CLIENT && (id == NET_GUI_DATA || id == NET_GUI_TICK)) {
            this.currentRF = buffer.readInt();
        }
    }

    @Override
    public void writePayload(int id, PacketBufferBC buffer, Side side) {
        super.writePayload(id, buffer, side);
        if (side == Side.SERVER && (id == NET_GUI_DATA || id == NET_GUI_TICK)) {
            buffer.writeInt(this.currentRF);
        }
    }

    protected boolean isValidUpgrade(int slot, ItemStack stack) {
        Item item = stack.func_77973_b();
        return RF_UPGRADE.containsKey(item);
    }

    @Override
    public boolean onActivated(EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack current = player.func_184586_b(hand).func_77946_l();
        if (super.onActivated(player, hand, side, hitX, hitY, hitZ)) {
            return true;
        }
        if (!current.func_190926_b()) {
            if (EntityUtil.getWrenchHand((EntityLivingBase)player) != null) {
                return false;
            }
            if (current.func_77973_b() instanceof IItemPipe) {
                return false;
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            BCEnergyGuis.ENGINE_RF.openGUI(player, this.func_174877_v());
        }
        return true;
    }

    @Override
    public double getPistonSpeed() {
        switch (this.getPowerStage()) {
            case BLUE: {
                return 0.04;
            }
            case GREEN: {
                return 0.05;
            }
            case YELLOW: {
                return 0.06;
            }
            case RED: {
                return 0.07;
            }
        }
        return 0.0;
    }

    @Override
    @Nonnull
    protected IMjConnector createConnector() {
        return new EngineConnector(false);
    }

    @Override
    public boolean isBurning() {
        return this.currentRF > 0 && this.isRedstonePowered;
    }

    public long getMjPerTick() {
        long value = MjAPI.MJ * 4L;
        for (int slot = 0; slot < this.invUpgrades.getSlots(); ++slot) {
            Long add;
            ItemStack stack = this.invUpgrades.getStackInSlot(slot);
            if (stack.func_190926_b() || (add = RF_UPGRADE.get(stack.func_77973_b())) == null) continue;
            value += add.longValue();
        }
        return value;
    }

    public int getRfConsumptionRate() {
        long mjPerTick = this.getMjPerTick();
        long mjPerRf = BCLibConfig.mjRfConversion.mjPerRf;
        return (int)(mjPerTick / mjPerRf);
    }

    @Override
    protected void burn() {
        if (this.currentRF <= 0) {
            return;
        }
        if (this.isRedstonePowered) {
            long mjPerRf = BCLibConfig.mjRfConversion.mjPerRf;
            int maxRf = this.getRfConsumptionRate();
            int rfConsumed = Math.min(this.currentRF, maxRf);
            long mjGenerated = (long)rfConsumed * mjPerRf;
            if (this.power + mjGenerated >= this.getMaxPower()) {
                return;
            }
            this.currentOutput = mjGenerated;
            this.addPower(mjGenerated);
            this.currentRF -= rfConsumed;
            this.heat += 0.06;
            if (this.heat >= 200.0) {
                this.heat = 200.0;
            }
        }
    }

    @Override
    public void updateHeatLevel() {
        if (this.heat > 20.0) {
            this.heat -= 0.01;
        }
        if (this.heat <= 20.0) {
            this.heat = 20.0;
        }
        this.getPowerStage();
    }

    @Override
    public long getMaxPower() {
        return 1000L * MjAPI.MJ;
    }

    @Override
    public long maxPowerReceived() {
        return 200L * MjAPI.MJ;
    }

    @Override
    public long maxPowerExtracted() {
        return 500L * MjAPI.MJ;
    }

    @Override
    public float explosionRange() {
        return 4.0f;
    }

    @Override
    protected int getMaxChainLength() {
        return 4;
    }

    @Override
    public long getCurrentOutput() {
        if (this.currentRF > 0) {
            return this.getMjPerTick();
        }
        return 0L;
    }

    public int getCurrentRF() {
        return this.currentRF;
    }

    static {
        RF_UPGRADE.put(BCCoreItems.gearIron, MjAPI.MJ * 2L);
        RF_UPGRADE.put(BCCoreItems.gearGold, MjAPI.MJ * 3L);
    }

    private final class Rf
    implements IEnergyStorage {
        private Rf() {
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int max = Math.min(10000 - TileEngineRF.this.currentRF, maxReceive);
            if (max <= 0) {
                return 0;
            }
            if (!simulate) {
                TileEngineRF.this.currentRF += max;
            }
            return max;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return TileEngineRF.this.currentRF;
        }

        public int getMaxEnergyStored() {
            return 10000;
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }
    }
}

