/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.expression.node.func;

import buildcraft.lib.expression.NodeInliningHelper;
import buildcraft.lib.expression.api.IDependancyVisitor;
import buildcraft.lib.expression.api.IDependantNode;
import buildcraft.lib.expression.api.IExpressionNode;
import buildcraft.lib.expression.api.INodeFunc;
import buildcraft.lib.expression.api.INodeStack;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.api.NodeTypes;
import buildcraft.lib.expression.node.func.NodeFuncBase;
import buildcraft.lib.expression.node.func.StringFunctionQuad;
import buildcraft.lib.expression.node.value.NodeConstantObject;
import java.util.Objects;

public class NodeFuncObjectBooleanDoubleToObject<A, R>
extends NodeFuncBase
implements INodeFunc.INodeFuncObject<R> {
    public final IFuncObjectBooleanDoubleToObject<A, R> function;
    private final StringFunctionQuad stringFunction;
    private final Class<A> argTypeA;
    private final Class<R> returnType;

    public NodeFuncObjectBooleanDoubleToObject(String name, Class<A> argTypeA, Class<R> returnType, IFuncObjectBooleanDoubleToObject<A, R> function) {
        this(argTypeA, returnType, function, (String a, String b, String c) -> "[ " + NodeTypes.getName(argTypeA) + ", boolean, double -> " + NodeTypes.getName(returnType) + " ] " + name + "(" + a + ", " + b + ", " + c + ")");
    }

    public NodeFuncObjectBooleanDoubleToObject(Class<A> argTypeA, Class<R> returnType, IFuncObjectBooleanDoubleToObject<A, R> function, StringFunctionQuad stringFunction) {
        this.argTypeA = argTypeA;
        this.returnType = returnType;
        this.function = function;
        this.stringFunction = stringFunction;
    }

    @Override
    public Class<R> getType() {
        return this.returnType;
    }

    public String toString() {
        return this.stringFunction.apply("{A}", "{B}", "{C}");
    }

    @Override
    public NodeFuncObjectBooleanDoubleToObject<A, R> setNeverInline() {
        super.setNeverInline();
        return this;
    }

    @Override
    public IExpressionNode.INodeObject<R> getNode(INodeStack stack) throws InvalidExpressionException {
        IExpressionNode.INodeDouble c = stack.popDouble();
        IExpressionNode.INodeBoolean b = stack.popBoolean();
        IExpressionNode.INodeObject<A> a = stack.popObject(this.argTypeA);
        return this.create(a, b, c);
    }

    public FuncObjectBooleanDoubleToObject create(IExpressionNode.INodeObject<A> argA, IExpressionNode.INodeBoolean argB, IExpressionNode.INodeDouble argC) {
        return new FuncObjectBooleanDoubleToObject(argA, argB, argC);
    }

    @FunctionalInterface
    public static interface IFuncObjectBooleanDoubleToObject<A, R> {
        public R apply(A var1, boolean var2, double var3);
    }

    public class FuncObjectBooleanDoubleToObject
    implements IExpressionNode.INodeObject<R>,
    IDependantNode,
    NodeFuncBase.IFunctionNode {
        public final IExpressionNode.INodeObject<A> argA;
        public final IExpressionNode.INodeBoolean argB;
        public final IExpressionNode.INodeDouble argC;

        public FuncObjectBooleanDoubleToObject(IExpressionNode.INodeObject<A> argA, IExpressionNode.INodeBoolean argB, IExpressionNode.INodeDouble argC) {
            this.argA = argA;
            this.argB = argB;
            this.argC = argC;
        }

        @Override
        public Class<R> getType() {
            return NodeFuncObjectBooleanDoubleToObject.this.returnType;
        }

        @Override
        public R evaluate() {
            return NodeFuncObjectBooleanDoubleToObject.this.function.apply(this.argA.evaluate(), this.argB.evaluate(), this.argC.evaluate());
        }

        @Override
        public IExpressionNode.INodeObject<R> inline() {
            if (!NodeFuncObjectBooleanDoubleToObject.this.canInline) {
                return NodeInliningHelper.tryInline(this, this.argA, this.argB, this.argC, (a, b, c) -> new FuncObjectBooleanDoubleToObject(a, (IExpressionNode.INodeBoolean)b, (IExpressionNode.INodeDouble)c), (a, b, c) -> new FuncObjectBooleanDoubleToObject(a, (IExpressionNode.INodeBoolean)b, (IExpressionNode.INodeDouble)c));
            }
            return NodeInliningHelper.tryInline(this, this.argA, this.argB, this.argC, (a, b, c) -> new FuncObjectBooleanDoubleToObject(a, (IExpressionNode.INodeBoolean)b, (IExpressionNode.INodeDouble)c), (a, b, c) -> new NodeConstantObject(NodeFuncObjectBooleanDoubleToObject.this.returnType, NodeFuncObjectBooleanDoubleToObject.this.function.apply(a.evaluate(), b.evaluate(), c.evaluate())));
        }

        @Override
        public void visitDependants(IDependancyVisitor visitor) {
            if (!NodeFuncObjectBooleanDoubleToObject.this.canInline) {
                if (NodeFuncObjectBooleanDoubleToObject.this.function instanceof IDependantNode) {
                    visitor.dependOn((IDependantNode)((Object)NodeFuncObjectBooleanDoubleToObject.this.function));
                } else {
                    visitor.dependOnExplictly(this);
                }
            }
            visitor.dependOn(this.argA, this.argB, this.argC);
        }

        public String toString() {
            return NodeFuncObjectBooleanDoubleToObject.this.stringFunction.apply(this.argA.toString(), this.argB.toString(), this.argC.toString());
        }

        @Override
        public NodeFuncBase getFunction() {
            return NodeFuncObjectBooleanDoubleToObject.this;
        }

        public int hashCode() {
            return Objects.hash(this.argA, this.argB, this.argC);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            FuncObjectBooleanDoubleToObject other = (FuncObjectBooleanDoubleToObject)obj;
            return Objects.equals(this.argA, other.argA) && Objects.equals(this.argB, other.argB) && Objects.equals(this.argC, other.argC);
        }
    }
}

