/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.api.crafting;

import blusunrize.immersiveengineering.api.DimensionChunkCoords;
import flaxbeard.immersivepetroleum.common.IPSaveData;
import flaxbeard.immersivepetroleum.common.network.IPPacketHandler;
import flaxbeard.immersivepetroleum.common.network.MessageReservoirListSync;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;

public class PumpjackHandler {
    public static LinkedHashMap<ReservoirType, Integer> reservoirList = new LinkedHashMap();
    private static Map<Integer, HashMap<String, Integer>> totalWeightMap = new HashMap<Integer, HashMap<String, Integer>>();
    public static HashMap<DimensionChunkCoords, Long> timeCache = new HashMap();
    public static HashMap<DimensionChunkCoords, OilWorldInfo> oilCache = new HashMap();
    public static double oilChance = 100.0;
    private static int depositSize = 1;
    private static HashMap<Biome, String> biomeNames = new HashMap();

    public static int getFluidAmount(World world, int chunkX, int chunkZ) {
        if (world.field_72995_K) {
            return 0;
        }
        OilWorldInfo info = PumpjackHandler.getOilWorldInfo(world, chunkX, chunkZ);
        if (info == null || info.capacity == 0 || info.getType() == null || info.getType().fluid == null || info.current == 0 && info.getType().replenishRate == 0) {
            return 0;
        }
        return info.current;
    }

    public static Fluid getFluid(World world, int chunkX, int chunkZ) {
        if (world.field_72995_K) {
            return null;
        }
        OilWorldInfo info = PumpjackHandler.getOilWorldInfo(world, chunkX, chunkZ);
        if (info.getType() == null) {
            return null;
        }
        return info.getType().getFluid();
    }

    public static int getResidualFluid(World world, int chunkX, int chunkZ) {
        OilWorldInfo info = PumpjackHandler.getOilWorldInfo(world, chunkX, chunkZ);
        if (info == null || info.getType() == null || info.getType().fluid == null || info.capacity == 0 || info.current == 0 && info.getType().replenishRate == 0) {
            return 0;
        }
        DimensionChunkCoords coords = new DimensionChunkCoords(world.field_73011_w.getDimension(), chunkX / depositSize, chunkZ / depositSize);
        Long l = timeCache.get(coords);
        if (l == null) {
            timeCache.put(coords, world.func_82737_E());
            return info.getType().replenishRate;
        }
        long lastTime = world.func_82737_E();
        timeCache.put(coords, world.func_82737_E());
        return lastTime != l ? info.getType().replenishRate : 0;
    }

    public static OilWorldInfo getOilWorldInfo(World world, int chunkX, int chunkZ) {
        if (world.field_72995_K) {
            return null;
        }
        int dim = world.field_73011_w.getDimension();
        DimensionChunkCoords coords = new DimensionChunkCoords(dim, chunkX / depositSize, chunkZ / depositSize);
        OilWorldInfo worldInfo = oilCache.get(coords);
        if (worldInfo == null) {
            ReservoirType res = null;
            Random r = world.func_72964_e(chunkX / depositSize, chunkZ / depositSize).func_76617_a(90210L);
            double dd = r.nextDouble();
            boolean empty = dd > oilChance;
            double size = r.nextDouble();
            int query = r.nextInt();
            if (!empty) {
                Biome biome = world.getBiomeForCoordsBody(new BlockPos(chunkX << 4, 64, chunkZ << 4));
                int weight = Math.abs(query % PumpjackHandler.getTotalWeight(dim, biome));
                for (Map.Entry<ReservoirType, Integer> e : reservoirList.entrySet()) {
                    if (!e.getKey().validDimension(dim) || !e.getKey().validBiome(biome) || (weight -= e.getValue().intValue()) >= 0) continue;
                    res = e.getKey();
                    break;
                }
            }
            int capacity = 0;
            if (res != null) {
                capacity = (int)(size * (double)(res.maxSize - res.minSize)) + res.minSize;
            }
            worldInfo = new OilWorldInfo();
            worldInfo.capacity = capacity;
            worldInfo.current = capacity;
            worldInfo.type = res;
            oilCache.put(coords, worldInfo);
        }
        return worldInfo;
    }

    public static void depleteFluid(World world, int chunkX, int chunkZ, int amount) {
        OilWorldInfo info = PumpjackHandler.getOilWorldInfo(world, chunkX, chunkZ);
        info.current = Math.max(0, info.current - amount);
        IPSaveData.setDirty(world.field_73011_w.getDimension());
    }

    public static int getTotalWeight(int dim, Biome biome) {
        String biomeName;
        Map dimMap;
        if (!totalWeightMap.containsKey(dim)) {
            totalWeightMap.put(dim, new HashMap());
        }
        if ((dimMap = (Map)totalWeightMap.get(dim)).containsKey(biomeName = PumpjackHandler.getBiomeName(biome))) {
            return (Integer)dimMap.get(biomeName);
        }
        int totalWeight = 0;
        for (Map.Entry<ReservoirType, Integer> e : reservoirList.entrySet()) {
            if (!e.getKey().validDimension(dim) || !e.getKey().validBiome(biome)) continue;
            totalWeight += e.getValue().intValue();
        }
        dimMap.put(biomeName, totalWeight);
        return totalWeight;
    }

    public static ReservoirType addReservoir(String name, String fluid, int minSize, int maxSize, int replenishRate, int weight) {
        ReservoirType mix = new ReservoirType(name, fluid, minSize, maxSize, replenishRate);
        reservoirList.put(mix, weight);
        return mix;
    }

    public static void recalculateChances(boolean mutePackets) {
        totalWeightMap.clear();
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER && !mutePackets) {
            HashMap<ReservoirType, Integer> packetMap = new HashMap<ReservoirType, Integer>();
            for (Map.Entry<ReservoirType, Integer> e : reservoirList.entrySet()) {
                if (e.getKey() == null || e.getValue() == null) continue;
                packetMap.put(e.getKey(), e.getValue());
            }
            IPPacketHandler.INSTANCE.sendToAll((IMessage)new MessageReservoirListSync(packetMap));
        }
    }

    public static String getBiomeName(Biome biome) {
        if (!biomeNames.containsKey(biome)) {
            String biomeName = (String)ReflectionHelper.getPrivateValue(Biome.class, (Object)biome, (int)17);
            biomeNames.put(biome, biomeName.replace(" ", "").replace("_", "").toLowerCase());
        }
        return biomeNames.get(biome);
    }

    public static String convertConfigName(String str) {
        return str.replace(" ", "").toUpperCase();
    }

    public static String getBiomeDisplayName(String str) {
        String ret = "";
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            ret = Character.isUpperCase(c) && i != 0 && str.charAt(i - 1) != ' ' ? ret + " " + c : ret + c;
        }
        return ret;
    }

    public static class ReservoirType {
        public String name;
        public String fluid;
        public int minSize;
        public int maxSize;
        public int replenishRate;
        public int[] dimensionWhitelist = new int[0];
        public int[] dimensionBlacklist = new int[0];
        public String[] biomeWhitelist = new String[0];
        public String[] biomeBlacklist = new String[0];
        private Fluid f;

        public ReservoirType(String name, String fluid, int minSize, int maxSize, int replenishRate) {
            this.name = name;
            this.fluid = fluid;
            this.minSize = minSize;
            this.maxSize = maxSize;
            this.replenishRate = replenishRate;
        }

        public Fluid getFluid() {
            if (this.fluid == null) {
                return null;
            }
            if (this.f == null) {
                this.f = FluidRegistry.getFluid((String)this.fluid);
            }
            return this.f;
        }

        public boolean validDimension(int dim) {
            if (this.dimensionWhitelist != null && this.dimensionWhitelist.length > 0) {
                for (int white : this.dimensionWhitelist) {
                    if (dim != white) continue;
                    return true;
                }
                return false;
            }
            if (this.dimensionBlacklist != null && this.dimensionBlacklist.length > 0) {
                for (int black : this.dimensionBlacklist) {
                    if (dim != black) continue;
                    return false;
                }
                return true;
            }
            return true;
        }

        public boolean validBiome(Biome biome) {
            if (biome == null) {
                return false;
            }
            if (this.biomeWhitelist != null && this.biomeWhitelist.length > 0) {
                for (String white : this.biomeWhitelist) {
                    for (BiomeDictionary.Type biomeType : BiomeDictionary.getTypes((Biome)biome)) {
                        if (!PumpjackHandler.convertConfigName(white).equals(biomeType.getName())) continue;
                        return true;
                    }
                }
                return false;
            }
            if (this.biomeBlacklist != null && this.biomeBlacklist.length > 0) {
                for (String black : this.biomeBlacklist) {
                    for (BiomeDictionary.Type biomeType : BiomeDictionary.getTypes((Biome)biome)) {
                        if (!PumpjackHandler.convertConfigName(black).equals(biomeType.getName())) continue;
                        return false;
                    }
                }
                return true;
            }
            return true;
        }

        public NBTTagCompound writeToNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("name", this.name);
            tag.func_74778_a("fluid", this.fluid);
            tag.func_74768_a("minSize", this.minSize);
            tag.func_74768_a("maxSize", this.maxSize);
            tag.func_74768_a("replenishRate", this.replenishRate);
            tag.func_74783_a("dimensionWhitelist", this.dimensionWhitelist);
            tag.func_74783_a("dimensionBlacklist", this.dimensionBlacklist);
            NBTTagList wl = new NBTTagList();
            for (String s : this.biomeWhitelist) {
                wl.func_74742_a((NBTBase)new NBTTagString(s));
            }
            tag.func_74782_a("biomeWhitelist", (NBTBase)wl);
            NBTTagList bl = new NBTTagList();
            for (String s : this.biomeBlacklist) {
                bl.func_74742_a((NBTBase)new NBTTagString(s));
            }
            tag.func_74782_a("biomeBlacklist", (NBTBase)wl);
            return tag;
        }

        public static ReservoirType readFromNBT(NBTTagCompound tag) {
            String name = tag.func_74779_i("name");
            String fluid = tag.func_74779_i("fluid");
            int minSize = tag.func_74762_e("minSize");
            int maxSize = tag.func_74762_e("maxSize");
            int replenishRate = tag.func_74762_e("replenishRate");
            ReservoirType res = new ReservoirType(name, fluid, minSize, maxSize, replenishRate);
            res.dimensionWhitelist = tag.func_74759_k("dimensionWhitelist");
            res.dimensionBlacklist = tag.func_74759_k("dimensionBlacklist");
            NBTTagList wl = (NBTTagList)tag.func_74781_a("biomeWhitelist");
            res.biomeWhitelist = new String[wl.func_74745_c()];
            for (int i = 0; i < wl.func_74745_c(); ++i) {
                res.biomeWhitelist[i] = wl.func_150307_f(i);
            }
            NBTTagList bl = (NBTTagList)tag.func_74781_a("biomeBlacklist");
            res.biomeBlacklist = new String[bl.func_74745_c()];
            for (int i = 0; i < bl.func_74745_c(); ++i) {
                res.biomeBlacklist[i] = bl.func_150307_f(i);
            }
            return res;
        }
    }

    public static class OilWorldInfo {
        public ReservoirType type;
        public ReservoirType overrideType;
        public int capacity;
        public int current;

        public ReservoirType getType() {
            return this.overrideType == null ? this.type : this.overrideType;
        }

        public NBTTagCompound writeToNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("capacity", this.capacity);
            tag.func_74768_a("oil", this.current);
            if (this.type != null) {
                tag.func_74778_a("type", this.type.name);
            }
            if (this.overrideType != null) {
                tag.func_74778_a("overrideType", this.overrideType.name);
            }
            return tag;
        }

        public static OilWorldInfo readFromNBT(NBTTagCompound tag) {
            Object s;
            OilWorldInfo info = new OilWorldInfo();
            info.capacity = tag.func_74762_e("capacity");
            info.current = tag.func_74762_e("oil");
            if (tag.func_74764_b("type")) {
                s = tag.func_74779_i("type");
                for (ReservoirType res : reservoirList.keySet()) {
                    if (!((String)s).equalsIgnoreCase(res.name)) continue;
                    info.type = res;
                }
            } else if (info.current > 0) {
                for (ReservoirType res : reservoirList.keySet()) {
                    if (!res.name.equalsIgnoreCase("oil")) continue;
                    info.type = res;
                }
                if (info.type == null) {
                    return null;
                }
            }
            if (tag.func_74764_b("overrideType")) {
                s = tag.func_74779_i("overrideType");
                for (ReservoirType res : reservoirList.keySet()) {
                    if (!((String)s).equalsIgnoreCase(res.name)) continue;
                    info.overrideType = res;
                }
            }
            return info;
        }
    }
}

