/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui;

import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.VoiceChatScreenBase;
import de.maxhenkel.voicechat.gui.VoiceChatSettingsScreen;
import de.maxhenkel.voicechat.gui.group.GroupScreen;
import de.maxhenkel.voicechat.gui.group.JoinGroupScreen;
import de.maxhenkel.voicechat.gui.tooltips.DisableTooltipSupplier;
import de.maxhenkel.voicechat.gui.tooltips.HideTooltipSupplier;
import de.maxhenkel.voicechat.gui.tooltips.MuteTooltipSupplier;
import de.maxhenkel.voicechat.gui.tooltips.RecordingTooltipSupplier;
import de.maxhenkel.voicechat.gui.volume.AdjustVolumesScreen;
import de.maxhenkel.voicechat.gui.widgets.ButtonBase;
import de.maxhenkel.voicechat.gui.widgets.ImageButton;
import de.maxhenkel.voicechat.gui.widgets.ToggleImageButton;
import de.maxhenkel.voicechat.voice.client.AudioRecorder;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientPlayerStateManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.KeyEvents;
import de.maxhenkel.voicechat.voice.common.ClientGroup;
import java.io.IOException;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class VoiceChatScreen
extends VoiceChatScreenBase {
    private static final ResourceLocation TEXTURE = new ResourceLocation("voicechat", "textures/gui/gui_voicechat.png");
    private static final ResourceLocation MICROPHONE = new ResourceLocation("voicechat", "textures/icons/microphone_button.png");
    private static final ResourceLocation HIDE = new ResourceLocation("voicechat", "textures/icons/hide_button.png");
    private static final ResourceLocation VOLUMES = new ResourceLocation("voicechat", "textures/icons/adjust_volumes.png");
    private static final ResourceLocation SPEAKER = new ResourceLocation("voicechat", "textures/icons/speaker_button.png");
    private static final ResourceLocation RECORD = new ResourceLocation("voicechat", "textures/icons/record_button.png");
    private static final ITextComponent TITLE = new TextComponentTranslation("gui.voicechat.voice_chat.title", new Object[0]);
    private static final ITextComponent SETTINGS = new TextComponentTranslation("message.voicechat.settings", new Object[0]);
    private static final ITextComponent GROUP = new TextComponentTranslation("message.voicechat.group", new Object[0]);
    private static final ITextComponent ADJUST_PLAYER_VOLUMES = new TextComponentTranslation("message.voicechat.adjust_volumes", new Object[0]);
    private ToggleImageButton mute;
    private ToggleImageButton disable;
    private VoiceChatScreenBase.HoverArea recordingHoverArea;
    private ClientPlayerStateManager stateManager = ClientManager.getPlayerStateManager();

    public VoiceChatScreen() {
        super(TITLE, 195, 76);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        ClientVoicechat client = ClientManager.getClient();
        this.mute = new ToggleImageButton(0, this.guiLeft + 6, this.guiTop + this.ySize - 6 - 20, MICROPHONE, this.stateManager::isMuted, button -> this.stateManager.setMuted(!this.stateManager.isMuted()), new MuteTooltipSupplier(this, this.stateManager));
        this.func_189646_b(this.mute);
        this.disable = new ToggleImageButton(1, this.guiLeft + 6 + 20 + 2, this.guiTop + this.ySize - 6 - 20, SPEAKER, this.stateManager::isDisabled, button -> this.stateManager.setDisabled(!this.stateManager.isDisabled()), new DisableTooltipSupplier(this, this.stateManager));
        this.func_189646_b(this.disable);
        ImageButton volumes = new ImageButton(2, this.guiLeft + 6 + 20 + 2 + 20 + 2, this.guiTop + this.ySize - 6 - 20, VOLUMES, button -> this.field_146297_k.func_147108_a((GuiScreen)new AdjustVolumesScreen()), (button, mouseX, mouseY) -> this.func_146279_a(ADJUST_PLAYER_VOLUMES.func_150261_e(), mouseX, mouseY));
        this.func_189646_b(volumes);
        if (client != null && VoicechatClient.CLIENT_CONFIG.useNatives.get().booleanValue() && (client.getRecorder() != null || client.getConnection() != null && client.getConnection().getData().allowRecording())) {
            ToggleImageButton record = new ToggleImageButton(3, this.guiLeft + this.xSize - 6 - 20 - 2 - 20, this.guiTop + this.ySize - 6 - 20, RECORD, () -> ClientManager.getClient() != null && ClientManager.getClient().getRecorder() != null, button -> this.toggleRecording(), new RecordingTooltipSupplier(this));
            this.func_189646_b(record);
        }
        ToggleImageButton hide = new ToggleImageButton(4, this.guiLeft + this.xSize - 6 - 20, this.guiTop + this.ySize - 6 - 20, HIDE, VoicechatClient.CLIENT_CONFIG.hideIcons::get, button -> VoicechatClient.CLIENT_CONFIG.hideIcons.set(VoicechatClient.CLIENT_CONFIG.hideIcons.get() == false).save(), new HideTooltipSupplier(this));
        this.func_189646_b(hide);
        ButtonBase settings = new ButtonBase(5, this.guiLeft + 6, this.guiTop + 6 + 15, 75, 20, SETTINGS){

            @Override
            public void onPress() {
                VoiceChatScreen.this.field_146297_k.func_147108_a((GuiScreen)new VoiceChatSettingsScreen());
            }
        };
        this.func_189646_b(settings);
        ButtonBase group = new ButtonBase(6, this.guiLeft + this.xSize - 6 - 75 + 1, this.guiTop + 6 + 15, 75, 20, GROUP){

            @Override
            public void onPress() {
                ClientGroup g = VoiceChatScreen.this.stateManager.getGroup();
                if (g != null) {
                    VoiceChatScreen.this.field_146297_k.func_147108_a((GuiScreen)new GroupScreen(g));
                } else {
                    VoiceChatScreen.this.field_146297_k.func_147108_a((GuiScreen)new JoinGroupScreen());
                }
            }
        };
        this.func_189646_b(group);
        group.field_146124_l = client != null && client.getConnection() != null && client.getConnection().getData().groupsEnabled();
        this.recordingHoverArea = new VoiceChatScreenBase.HoverArea(72, this.ySize - 6 - 20, this.xSize - 122, 20);
        this.checkButtons();
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.checkButtons();
    }

    private void checkButtons() {
        if (this.mute != null) {
            this.mute.field_146124_l = MuteTooltipSupplier.canMuteMic();
        }
        if (this.disable != null) {
            this.disable.field_146124_l = this.stateManager.canEnable();
        }
    }

    private void toggleRecording() {
        ClientVoicechat c = ClientManager.getClient();
        if (c == null) {
            return;
        }
        c.toggleRecording();
    }

    public void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == KeyEvents.KEY_VOICE_CHAT.func_151463_i()) {
            this.field_146297_k.func_147108_a(null);
            return;
        }
        super.func_73869_a(typedChar, keyCode);
    }

    @Override
    public void renderBackground(int mouseX, int mouseY, float delta) {
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
    }

    @Override
    public void renderForeground(int mouseX, int mouseY, float delta) {
        int titleWidth = this.field_146289_q.func_78256_a(TITLE.func_150261_e());
        this.field_146289_q.func_78276_b(TITLE.func_150261_e(), this.guiLeft + (this.xSize - titleWidth) / 2, this.guiTop + 7, 0x404040);
        ClientVoicechat client = ClientManager.getClient();
        if (client != null && client.getRecorder() != null) {
            AudioRecorder recorder = client.getRecorder();
            TextComponentString time = new TextComponentString(recorder.getDuration());
            this.field_146289_q.func_78276_b(time.func_150255_a(new Style().func_150238_a(TextFormatting.DARK_RED)).func_150254_d(), this.guiLeft + this.recordingHoverArea.getPosX() + this.recordingHoverArea.getWidth() / 2 - this.field_146289_q.func_78256_a(time.func_150261_e()) / 2, this.guiTop + this.recordingHoverArea.getPosY() + this.recordingHoverArea.getHeight() / 2 - this.field_146289_q.field_78288_b / 2, 0);
            if (this.recordingHoverArea.isHovered(this.guiLeft, this.guiTop, mouseX, mouseY)) {
                this.func_146279_a(new TextComponentTranslation("message.voicechat.storage_size", new Object[]{recorder.getStorage()}).func_150261_e(), mouseX, mouseY);
            }
        }
    }
}

