/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.audiodevice;

import de.maxhenkel.voicechat.configbuilder.entry.ConfigEntry;
import de.maxhenkel.voicechat.gui.audiodevice.AudioDeviceEntry;
import de.maxhenkel.voicechat.gui.widgets.ListScreenListBase;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.SoundManager;
import java.util.Collection;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public abstract class AudioDeviceList
extends ListScreenListBase<AudioDeviceEntry> {
    public static final int CELL_HEIGHT = 36;
    @Nullable
    protected ResourceLocation icon;
    @Nullable
    protected ITextComponent defaultDeviceText;
    @Nullable
    protected ConfigEntry<String> configEntry;

    public AudioDeviceList(int width, int height, int top) {
        super(width, height, top, 36);
    }

    public boolean func_148179_a(int mouseX, int mouseY, int button) {
        if (super.func_148179_a(mouseX, mouseY, button)) {
            return true;
        }
        for (AudioDeviceEntry entry : this.children()) {
            if (!entry.isSelected()) continue;
            this.field_148161_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            this.onSelect(entry);
            return true;
        }
        return super.func_148179_a(mouseX, mouseY, button);
    }

    protected void onSelect(AudioDeviceEntry entry) {
        ClientVoicechat client;
        if (this.configEntry != null) {
            this.configEntry.set(entry.device).save();
        }
        if ((client = ClientManager.getClient()) != null) {
            client.reloadAudio();
        }
    }

    @Override
    public void replaceEntries(Collection<AudioDeviceEntry> entries) {
        super.replaceEntries(entries);
    }

    public void setAudioDevices(Collection<String> entries) {
        this.replaceEntries(Stream.concat(Stream.of(""), entries.stream()).map(s -> this.createAudioDeviceEntry((String)s, this.getVisibleName((String)s), this.icon, () -> this.isSelected((String)s))).collect(Collectors.toList()));
    }

    public abstract AudioDeviceEntry createAudioDeviceEntry(String var1, ITextComponent var2, @Nullable ResourceLocation var3, Supplier<Boolean> var4);

    public boolean isSelected(String name) {
        if (this.configEntry == null) {
            return false;
        }
        return this.configEntry.get().equals(name);
    }

    public ITextComponent getVisibleName(String device) {
        if (device.isEmpty() && this.defaultDeviceText != null) {
            return this.defaultDeviceText;
        }
        return new TextComponentString(SoundManager.cleanDeviceName(device));
    }

    @Override
    public boolean isEmpty() {
        return this.children().isEmpty();
    }
}

