/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.volume;

import de.maxhenkel.voicechat.gui.widgets.DebouncedSlider;
import de.maxhenkel.voicechat.voice.common.AudioUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class AdjustVolumeSlider
extends DebouncedSlider {
    protected static final ITextComponent MUTED = new TextComponentTranslation("message.voicechat.muted", new Object[0]);
    protected static final double YELLOW_DB = -20.0;
    protected static final double RED_DB = -6.0;
    protected static final float MAXIMUM = 4.0f;
    protected final AdjustVolumeEntry volumeConfigEntry;

    public AdjustVolumeSlider(int id, int xIn, int yIn, int widthIn, int heightIn, AdjustVolumeEntry volumeConfigEntry) {
        super(id, xIn, yIn, widthIn, heightIn, volumeConfigEntry.get() / 4.0);
        this.volumeConfigEntry = volumeConfigEntry;
        this.updateMessage();
    }

    @Override
    protected void updateMessage() {
        if (this.value <= 0.0) {
            this.field_146126_j = MUTED.func_150261_e();
            return;
        }
        long amp = Math.round(this.value * 4.0 * 100.0 - 100.0);
        this.field_146126_j = new TextComponentTranslation("message.voicechat.volume_amplification", new Object[]{((float)amp > 0.0f ? "+" : "") + amp + "%"}).func_150261_e();
    }

    @Override
    public void func_146119_b(Minecraft mc, int mouseX, int mouseY) {
        super.func_146119_b(mc, mouseX, mouseY);
        double audioLevel = this.volumeConfigEntry.getAudioLevel();
        if (audioLevel <= -127.0) {
            return;
        }
        double adjustedLevel = AudioUtils.linearToDb(this.getMultiplier());
        int barWidth = (int)((double)this.field_146120_f * AudioUtils.dbToPerc(audioLevel + adjustedLevel));
        double yellowPerc = AudioUtils.dbToPerc(-20.0);
        double redPerc = AudioUtils.dbToPerc(-6.0);
        int greenWidth = (int)((double)this.field_146120_f * yellowPerc);
        int yellowWidth = (int)((double)this.field_146120_f * redPerc) - greenWidth;
        GuiScreen.func_73734_a((int)this.field_146128_h, (int)this.field_146129_i, (int)(this.field_146128_h + Math.min(greenWidth, barWidth)), (int)(this.field_146129_i + 1), (int)-16711936);
        if (barWidth > greenWidth) {
            GuiScreen.func_73734_a((int)(this.field_146128_h + greenWidth), (int)this.field_146129_i, (int)(this.field_146128_h + Math.min(greenWidth + yellowWidth, barWidth)), (int)(this.field_146129_i + 1), (int)-256);
            if (barWidth > greenWidth + yellowWidth) {
                GuiScreen.func_73734_a((int)(this.field_146128_h + greenWidth + yellowWidth), (int)this.field_146129_i, (int)(this.field_146128_h + Math.min(this.field_146120_f, barWidth)), (int)(this.field_146129_i + 1), (int)-65536);
            }
        }
    }

    @Override
    public void applyDebounced() {
        this.volumeConfigEntry.save(this.getMultiplier());
    }

    private double getMultiplier() {
        return this.value * 4.0;
    }

    public static interface AdjustVolumeEntry {
        public void save(double var1);

        public double get();

        public double getAudioLevel();
    }
}

