/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.natives;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class Cleaner {
    private final ReferenceQueue<Object> queue = new ReferenceQueue();
    private final ConcurrentMap<CleanableRef, Boolean> registry = new ConcurrentHashMap<CleanableRef, Boolean>();
    private final Thread cleanerThread = new Thread(() -> {
        while (true) {
            try {
                while (true) {
                    CleanableRef ref = (CleanableRef)this.queue.remove();
                    ref.clean();
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }, "CleanerThread");

    public static Cleaner create() {
        return new Cleaner();
    }

    private Cleaner() {
        this.cleanerThread.setDaemon(true);
        this.cleanerThread.start();
    }

    public Cleanable register(Object obj, Runnable action) {
        Objects.requireNonNull(obj, "obj");
        Objects.requireNonNull(action, "action");
        CleanableRef ref = new CleanableRef(this, obj, action);
        this.registry.put(ref, Boolean.TRUE);
        return ref;
    }

    public static interface Cleanable {
        public void clean();
    }

    private static final class CleanableRef
    extends PhantomReference<Object>
    implements Cleanable {
        private final Cleaner owner;
        private final Runnable action;
        private final AtomicBoolean cleaned = new AtomicBoolean(false);

        CleanableRef(Cleaner owner, Object obj, Runnable action) {
            super(obj, owner.queue);
            this.owner = owner;
            this.action = action;
        }

        @Override
        public void clean() {
            if (this.cleaned.compareAndSet(false, true)) {
                this.owner.registry.remove(this);
                try {
                    this.action.run();
                }
                catch (Throwable throwable) {
                }
                finally {
                    this.clear();
                }
            }
        }
    }
}

