/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.GameProfileUtils;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.GroupPlayerIconOrientation;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;

public class GroupChatManager {
    private static final ResourceLocation TALK_OUTLINE = new ResourceLocation("voicechat", "textures/icons/talk_outline.png");
    private static final ResourceLocation SPEAKER_OFF_ICON = new ResourceLocation("voicechat", "textures/icons/speaker_small_off.png");

    public static void renderIcons() {
        ClientVoicechat client = ClientManager.getClient();
        if (client == null) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution scaledResolution = new ScaledResolution(mc);
        List<PlayerState> groupMembers = GroupChatManager.getGroupMembers(VoicechatClient.CLIENT_CONFIG.showOwnGroupIcon.get());
        GlStateManager.func_179094_E();
        int posX = VoicechatClient.CLIENT_CONFIG.groupPlayerIconPosX.get();
        int posY = VoicechatClient.CLIENT_CONFIG.groupPlayerIconPosY.get();
        if (posX < 0) {
            GlStateManager.func_179137_b((double)scaledResolution.func_78326_a(), (double)0.0, (double)0.0);
        }
        if (posY < 0) {
            GlStateManager.func_179137_b((double)0.0, (double)scaledResolution.func_78328_b(), (double)0.0);
        }
        GlStateManager.func_179137_b((double)posX, (double)posY, (double)0.0);
        float scale = VoicechatClient.CLIENT_CONFIG.groupHudIconScale.get().floatValue();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        boolean vertical = VoicechatClient.CLIENT_CONFIG.groupPlayerIconOrientation.get().equals((Object)GroupPlayerIconOrientation.VERTICAL);
        for (int i = 0; i < groupMembers.size(); ++i) {
            PlayerState state = groupMembers.get(i);
            GlStateManager.func_179094_E();
            if (vertical) {
                if (posY < 0) {
                    GlStateManager.func_179137_b((double)0.0, (double)((double)i * -11.0), (double)0.0);
                } else {
                    GlStateManager.func_179137_b((double)0.0, (double)((double)i * 11.0), (double)0.0);
                }
            } else if (posX < 0) {
                GlStateManager.func_179137_b((double)((double)i * -11.0), (double)0.0, (double)0.0);
            } else {
                GlStateManager.func_179137_b((double)((double)i * 11.0), (double)0.0, (double)0.0);
            }
            if (client.getTalkCache().isTalking(state.getUuid())) {
                mc.func_110434_K().func_110577_a(TALK_OUTLINE);
                GuiScreen.func_146110_a((int)(posX < 0 ? -10 : 0), (int)(posY < 0 ? -10 : 0), (float)0.0f, (float)0.0f, (int)10, (int)10, (float)16.0f, (float)16.0f);
            }
            GlStateManager.func_179147_l();
            mc.func_110434_K().func_110577_a(GameProfileUtils.getSkin(state.getUuid()));
            GuiScreen.func_146110_a((int)(posX < 0 ? -9 : 1), (int)(posY < 0 ? -9 : 1), (float)8.0f, (float)8.0f, (int)8, (int)8, (float)64.0f, (float)64.0f);
            GuiScreen.func_146110_a((int)(posX < 0 ? -9 : 1), (int)(posY < 0 ? -9 : 1), (float)40.0f, (float)8.0f, (int)8, (int)8, (float)64.0f, (float)64.0f);
            if (state.isDisabled()) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)(posX < 0 ? -9.0 : 1.0), (double)(posY < 0 ? -9.0 : 1.0), (double)0.0);
                GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)1.0f);
                mc.func_110434_K().func_110577_a(SPEAKER_OFF_ICON);
                GuiScreen.func_146110_a((int)0, (int)0, (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
    }

    public static List<PlayerState> getGroupMembers() {
        return GroupChatManager.getGroupMembers(true);
    }

    public static List<PlayerState> getGroupMembers(boolean includeSelf) {
        ArrayList<PlayerState> entries = new ArrayList<PlayerState>();
        UUID group = ClientManager.getPlayerStateManager().getGroupID();
        if (group == null) {
            return entries;
        }
        for (PlayerState state : ClientManager.getPlayerStateManager().getPlayerStates(includeSelf)) {
            if (!state.hasGroup() || !state.getGroup().equals(group)) continue;
            entries.add(state);
        }
        entries.sort(Comparator.comparing(PlayerState::getName));
        return entries;
    }
}

