/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.buffer;

import pro.gravit.repackage.io.netty.buffer.AbstractByteBufAllocator;
import pro.gravit.repackage.io.netty.buffer.AdaptiveByteBufAllocator$AdaptiveAllocatorApi;
import pro.gravit.repackage.io.netty.buffer.AdaptiveByteBufAllocator$DirectChunkAllocator;
import pro.gravit.repackage.io.netty.buffer.AdaptiveByteBufAllocator$HeapChunkAllocator;
import pro.gravit.repackage.io.netty.buffer.AdaptivePoolingAllocator;
import pro.gravit.repackage.io.netty.buffer.AdaptivePoolingAllocator$MagazineCaching;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.buffer.ByteBufAllocatorMetric;
import pro.gravit.repackage.io.netty.buffer.ByteBufAllocatorMetricProvider;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;
import pro.gravit.repackage.io.netty.util.internal.SystemPropertyUtil;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;

public final class AdaptiveByteBufAllocator
extends AbstractByteBufAllocator
implements ByteBufAllocatorMetric,
ByteBufAllocatorMetricProvider {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AdaptiveByteBufAllocator.class);
    private static final boolean DEFAULT_USE_CACHED_MAGAZINES_FOR_NON_EVENT_LOOP_THREADS = SystemPropertyUtil.getBoolean("pro.gravit.repackage.io.netty.allocator.useCachedMagazinesForNonEventLoopThreads", false);
    private final AdaptiveByteBufAllocator$AdaptiveAllocatorApi direct;
    private final AdaptiveByteBufAllocator$AdaptiveAllocatorApi heap;

    public AdaptiveByteBufAllocator() {
        this(PlatformDependent.directBufferPreferred());
    }

    public AdaptiveByteBufAllocator(boolean bl) {
        this(bl, DEFAULT_USE_CACHED_MAGAZINES_FOR_NON_EVENT_LOOP_THREADS);
    }

    public AdaptiveByteBufAllocator(boolean bl, boolean bl2) {
        super(bl);
        if (PlatformDependent.javaVersion() < 8) {
            throw new IllegalStateException("This allocator require Java 8 or newer.");
        }
        AdaptivePoolingAllocator$MagazineCaching adaptivePoolingAllocator$MagazineCaching = bl2 ? AdaptivePoolingAllocator$MagazineCaching.FastThreadLocalThreads : AdaptivePoolingAllocator$MagazineCaching.EventLoopThreads;
        this.direct = new AdaptivePoolingAllocator(new AdaptiveByteBufAllocator$DirectChunkAllocator(this, null), adaptivePoolingAllocator$MagazineCaching);
        this.heap = new AdaptivePoolingAllocator(new AdaptiveByteBufAllocator$HeapChunkAllocator(this), adaptivePoolingAllocator$MagazineCaching);
    }

    @Override
    protected ByteBuf newHeapBuffer(int n, int n2) {
        return this.heap.allocate(n, n2);
    }

    @Override
    protected ByteBuf newDirectBuffer(int n, int n2) {
        return this.direct.allocate(n, n2);
    }

    @Override
    public boolean isDirectBufferPooled() {
        return true;
    }

    @Override
    public long usedHeapMemory() {
        return this.heap.usedMemory();
    }

    @Override
    public long usedDirectMemory() {
        return this.direct.usedMemory();
    }

    @Override
    public ByteBufAllocatorMetric metric() {
        return this;
    }

    static {
        logger.debug("-Dio.netty.allocator.useCachedMagazinesForNonEventLoopThreads: {}", (Object)DEFAULT_USE_CACHED_MAGAZINES_FOR_NON_EVENT_LOOP_THREADS);
    }
}

