/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.buffer;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import pro.gravit.repackage.io.netty.buffer.AbstractByteBuf;
import pro.gravit.repackage.io.netty.buffer.AbstractReferenceCountedByteBuf;
import pro.gravit.repackage.io.netty.buffer.AdaptivePoolingAllocator;
import pro.gravit.repackage.io.netty.buffer.AdaptivePoolingAllocator$Chunk;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.buffer.ByteBufAllocator;
import pro.gravit.repackage.io.netty.buffer.ByteBufUtil;
import pro.gravit.repackage.io.netty.util.ByteProcessor;
import pro.gravit.repackage.io.netty.util.IllegalReferenceCountException;
import pro.gravit.repackage.io.netty.util.Recycler$EnhancedHandle;
import pro.gravit.repackage.io.netty.util.internal.ObjectPool$Handle;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

final class AdaptivePoolingAllocator$AdaptiveByteBuf
extends AbstractReferenceCountedByteBuf {
    private final ObjectPool$Handle<AdaptivePoolingAllocator$AdaptiveByteBuf> handle;
    private int adjustment;
    private AbstractByteBuf rootParent;
    AdaptivePoolingAllocator$Chunk chunk;
    private int length;
    private ByteBuffer tmpNioBuf;
    private boolean hasArray;
    private boolean hasMemoryAddress;

    AdaptivePoolingAllocator$AdaptiveByteBuf(ObjectPool$Handle<AdaptivePoolingAllocator$AdaptiveByteBuf> objectPool$Handle) {
        super(0);
        this.handle = ObjectUtil.checkNotNull(objectPool$Handle, "recyclerHandle");
    }

    void init(AbstractByteBuf abstractByteBuf, AdaptivePoolingAllocator$Chunk adaptivePoolingAllocator$Chunk, int n, int n2, int n3, int n4, int n5) {
        this.adjustment = n3;
        this.chunk = adaptivePoolingAllocator$Chunk;
        this.length = n4;
        this.maxCapacity(n5);
        this.setIndex0(n, n2);
        this.hasArray = abstractByteBuf.hasArray();
        this.hasMemoryAddress = abstractByteBuf.hasMemoryAddress();
        this.rootParent = abstractByteBuf;
        this.tmpNioBuf = abstractByteBuf.internalNioBuffer(n3, n4).slice();
    }

    private AbstractByteBuf rootParent() {
        AbstractByteBuf abstractByteBuf = this.rootParent;
        if (abstractByteBuf != null) {
            return abstractByteBuf;
        }
        throw new IllegalReferenceCountException();
    }

    @Override
    public int capacity() {
        return this.length;
    }

    @Override
    public ByteBuf capacity(int n) {
        if (n == this.capacity()) {
            this.ensureAccessible();
            return this;
        }
        this.checkNewCapacity(n);
        if (n < this.capacity()) {
            this.length = n;
            this.setIndex0(Math.min(this.readerIndex(), n), Math.min(this.writerIndex(), n));
            return this;
        }
        ByteBuffer byteBuffer = this.tmpNioBuf;
        byteBuffer.clear();
        this.tmpNioBuf = null;
        AdaptivePoolingAllocator$Chunk adaptivePoolingAllocator$Chunk = this.chunk;
        AdaptivePoolingAllocator adaptivePoolingAllocator = AdaptivePoolingAllocator$Chunk.access$1400(adaptivePoolingAllocator$Chunk);
        int n2 = this.readerIndex;
        int n3 = this.writerIndex;
        adaptivePoolingAllocator.allocate(n, this.maxCapacity(), this);
        this.tmpNioBuf.put(byteBuffer);
        this.tmpNioBuf.clear();
        adaptivePoolingAllocator$Chunk.release();
        this.readerIndex = n2;
        this.writerIndex = n3;
        return this;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.rootParent().alloc();
    }

    @Override
    public ByteOrder order() {
        return this.rootParent().order();
    }

    @Override
    public ByteBuf unwrap() {
        return null;
    }

    @Override
    public boolean isDirect() {
        return this.rootParent().isDirect();
    }

    @Override
    public int arrayOffset() {
        return this.idx(this.rootParent().arrayOffset());
    }

    @Override
    public boolean hasMemoryAddress() {
        return this.hasMemoryAddress;
    }

    @Override
    public long memoryAddress() {
        this.ensureAccessible();
        return this.rootParent().memoryAddress() + (long)this.adjustment;
    }

    @Override
    public ByteBuffer nioBuffer(int n, int n2) {
        this.checkIndex(n, n2);
        return this.rootParent().nioBuffer(this.idx(n), n2);
    }

    @Override
    public ByteBuffer internalNioBuffer(int n, int n2) {
        this.checkIndex(n, n2);
        return (ByteBuffer)this.internalNioBuffer().position(n).limit(n + n2);
    }

    private ByteBuffer internalNioBuffer() {
        return (ByteBuffer)this.tmpNioBuf.clear();
    }

    @Override
    public ByteBuffer[] nioBuffers(int n, int n2) {
        this.checkIndex(n, n2);
        return this.rootParent().nioBuffers(this.idx(n), n2);
    }

    @Override
    public boolean hasArray() {
        return this.hasArray;
    }

    @Override
    public byte[] array() {
        this.ensureAccessible();
        return this.rootParent().array();
    }

    @Override
    public ByteBuf copy(int n, int n2) {
        this.checkIndex(n, n2);
        return this.rootParent().copy(this.idx(n), n2);
    }

    @Override
    public int nioBufferCount() {
        return this.rootParent().nioBufferCount();
    }

    @Override
    protected byte _getByte(int n) {
        return this.rootParent()._getByte(this.idx(n));
    }

    @Override
    protected short _getShort(int n) {
        return this.rootParent()._getShort(this.idx(n));
    }

    @Override
    protected short _getShortLE(int n) {
        return this.rootParent()._getShortLE(this.idx(n));
    }

    @Override
    protected int _getUnsignedMedium(int n) {
        return this.rootParent()._getUnsignedMedium(this.idx(n));
    }

    @Override
    protected int _getUnsignedMediumLE(int n) {
        return this.rootParent()._getUnsignedMediumLE(this.idx(n));
    }

    @Override
    protected int _getInt(int n) {
        return this.rootParent()._getInt(this.idx(n));
    }

    @Override
    protected int _getIntLE(int n) {
        return this.rootParent()._getIntLE(this.idx(n));
    }

    @Override
    protected long _getLong(int n) {
        return this.rootParent()._getLong(this.idx(n));
    }

    @Override
    protected long _getLongLE(int n) {
        return this.rootParent()._getLongLE(this.idx(n));
    }

    @Override
    public ByteBuf getBytes(int n, ByteBuf byteBuf, int n2, int n3) {
        this.checkIndex(n, n3);
        this.rootParent().getBytes(this.idx(n), byteBuf, n2, n3);
        return this;
    }

    @Override
    public ByteBuf getBytes(int n, byte[] byArray, int n2, int n3) {
        this.checkIndex(n, n3);
        this.rootParent().getBytes(this.idx(n), byArray, n2, n3);
        return this;
    }

    @Override
    public ByteBuf getBytes(int n, ByteBuffer byteBuffer) {
        this.checkIndex(n, byteBuffer.remaining());
        this.rootParent().getBytes(this.idx(n), byteBuffer);
        return this;
    }

    @Override
    protected void _setByte(int n, int n2) {
        this.rootParent()._setByte(this.idx(n), n2);
    }

    @Override
    protected void _setShort(int n, int n2) {
        this.rootParent()._setShort(this.idx(n), n2);
    }

    @Override
    protected void _setShortLE(int n, int n2) {
        this.rootParent()._setShortLE(this.idx(n), n2);
    }

    @Override
    protected void _setMedium(int n, int n2) {
        this.rootParent()._setMedium(this.idx(n), n2);
    }

    @Override
    protected void _setMediumLE(int n, int n2) {
        this.rootParent()._setMediumLE(this.idx(n), n2);
    }

    @Override
    protected void _setInt(int n, int n2) {
        this.rootParent()._setInt(this.idx(n), n2);
    }

    @Override
    protected void _setIntLE(int n, int n2) {
        this.rootParent()._setIntLE(this.idx(n), n2);
    }

    @Override
    protected void _setLong(int n, long l) {
        this.rootParent()._setLong(this.idx(n), l);
    }

    @Override
    protected void _setLongLE(int n, long l) {
        this.rootParent().setLongLE(this.idx(n), l);
    }

    @Override
    public ByteBuf setBytes(int n, byte[] byArray, int n2, int n3) {
        this.checkIndex(n, n3);
        this.rootParent().setBytes(this.idx(n), byArray, n2, n3);
        return this;
    }

    @Override
    public ByteBuf setBytes(int n, ByteBuf byteBuf, int n2, int n3) {
        this.checkIndex(n, n3);
        this.rootParent().setBytes(this.idx(n), byteBuf, n2, n3);
        return this;
    }

    @Override
    public ByteBuf setBytes(int n, ByteBuffer byteBuffer) {
        this.checkIndex(n, byteBuffer.remaining());
        this.rootParent().setBytes(this.idx(n), byteBuffer);
        return this;
    }

    @Override
    public ByteBuf getBytes(int n, OutputStream outputStream, int n2) {
        this.checkIndex(n, n2);
        if (n2 != 0) {
            ByteBufUtil.readBytes(this.alloc(), this.internalNioBuffer().duplicate(), n, n2, outputStream);
        }
        return this;
    }

    @Override
    public int getBytes(int n, GatheringByteChannel gatheringByteChannel, int n2) {
        return gatheringByteChannel.write(this.internalNioBuffer(n, n2).duplicate());
    }

    @Override
    public int getBytes(int n, FileChannel fileChannel, long l, int n2) {
        return fileChannel.write(this.internalNioBuffer(n, n2).duplicate(), l);
    }

    @Override
    public int setBytes(int n, InputStream inputStream, int n2) {
        this.checkIndex(n, n2);
        AbstractByteBuf abstractByteBuf = this.rootParent();
        if (abstractByteBuf.hasArray()) {
            return abstractByteBuf.setBytes(this.idx(n), inputStream, n2);
        }
        byte[] byArray = ByteBufUtil.threadLocalTempArray(n2);
        int n3 = inputStream.read(byArray, 0, n2);
        if (n3 <= 0) {
            return n3;
        }
        this.setBytes(n, byArray, 0, n3);
        return n3;
    }

    @Override
    public int setBytes(int n, ScatteringByteChannel scatteringByteChannel, int n2) {
        try {
            return scatteringByteChannel.read(this.internalNioBuffer(n, n2).duplicate());
        }
        catch (ClosedChannelException closedChannelException) {
            return -1;
        }
    }

    @Override
    public int setBytes(int n, FileChannel fileChannel, long l, int n2) {
        try {
            return fileChannel.read(this.internalNioBuffer(n, n2).duplicate(), l);
        }
        catch (ClosedChannelException closedChannelException) {
            return -1;
        }
    }

    @Override
    public int forEachByte(int n, int n2, ByteProcessor byteProcessor) {
        this.checkIndex(n, n2);
        int n3 = this.rootParent().forEachByte(this.idx(n), n2, byteProcessor);
        return this.forEachResult(n3);
    }

    @Override
    public int forEachByteDesc(int n, int n2, ByteProcessor byteProcessor) {
        this.checkIndex(n, n2);
        int n3 = this.rootParent().forEachByteDesc(this.idx(n), n2, byteProcessor);
        return this.forEachResult(n3);
    }

    private int forEachResult(int n) {
        if (n < this.adjustment) {
            return -1;
        }
        return n - this.adjustment;
    }

    @Override
    public boolean isContiguous() {
        return this.rootParent().isContiguous();
    }

    private int idx(int n) {
        return n + this.adjustment;
    }

    @Override
    protected void deallocate() {
        if (this.chunk != null) {
            this.chunk.release();
        }
        this.tmpNioBuf = null;
        this.chunk = null;
        this.rootParent = null;
        if (this.handle instanceof Recycler$EnhancedHandle) {
            Recycler$EnhancedHandle recycler$EnhancedHandle = (Recycler$EnhancedHandle)this.handle;
            recycler$EnhancedHandle.unguardedRecycle(this);
        } else {
            this.handle.recycle(this);
        }
    }
}

