/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.buffer;

import java.util.Arrays;
import pro.gravit.repackage.io.netty.buffer.AdaptivePoolingAllocator;
import pro.gravit.repackage.io.netty.buffer.AdaptivePoolingAllocator$1;
import pro.gravit.repackage.io.netty.buffer.AdaptivePoolingAllocator$Magazine;

class AdaptivePoolingAllocator$AllocationStatistics {
    private static final int MIN_DATUM_TARGET = 1024;
    private static final int MAX_DATUM_TARGET = 65534;
    private static final int INIT_DATUM_TARGET = 9;
    private static final int HISTO_MIN_BUCKET_SHIFT = 13;
    private static final int HISTO_MAX_BUCKET_SHIFT = 20;
    private static final int HISTO_BUCKET_COUNT = 8;
    private static final int HISTO_MAX_BUCKET_MASK = 7;
    private static final int SIZE_MAX_MASK = 0x9FFFFF;
    protected final AdaptivePoolingAllocator parent;
    private final boolean shareable;
    private final short[][] histos = new short[][]{new short[8], new short[8], new short[8], new short[8]};
    private short[] histo = this.histos[0];
    private final int[] sums = new int[8];
    private int histoIndex;
    private int datumCount;
    private int datumTarget = 9;
    protected volatile int sharedPrefChunkSize = 131072;
    protected volatile int localPrefChunkSize = 131072;

    private AdaptivePoolingAllocator$AllocationStatistics(AdaptivePoolingAllocator adaptivePoolingAllocator, boolean bl) {
        this.parent = adaptivePoolingAllocator;
        this.shareable = bl;
    }

    protected void recordAllocationSize(int n) {
        int n2 = n;
        this.histo[n2] = (short)(this.histo[n2] + 1);
        if (this.datumCount++ == this.datumTarget) {
            this.rotateHistograms();
        }
    }

    static int sizeBucket(int n) {
        if (n == 0) {
            return 0;
        }
        int n2 = n - 1 >> 13 & 0x9FFFFF;
        return Math.min(32 - Integer.numberOfLeadingZeros(n2), 7);
    }

    private void rotateHistograms() {
        int n;
        int n2;
        int n3;
        short[][] sArray = this.histos;
        for (n3 = 0; n3 < 8; ++n3) {
            this.sums[n3] = (sArray[0][n3] & 0xFFFF) + (sArray[1][n3] & 0xFFFF) + (sArray[2][n3] & 0xFFFF) + (sArray[3][n3] & 0xFFFF);
        }
        n3 = 0;
        int[] nArray = this.sums;
        int n4 = nArray.length;
        for (n2 = 0; n2 < n4; ++n2) {
            n = nArray[n2];
            n3 += n;
        }
        int n5 = (int)((double)n3 * 0.99);
        for (n4 = 0; n4 < this.sums.length && this.sums[n4] <= n5; n5 -= this.sums[n4], ++n4) {
        }
        n2 = 1 << n4 + 13;
        this.localPrefChunkSize = n = Math.max(n2 * 10, 131072);
        if (this.shareable) {
            for (AdaptivePoolingAllocator$Magazine adaptivePoolingAllocator$Magazine : AdaptivePoolingAllocator.access$500(this.parent)) {
                n = Math.max(n, adaptivePoolingAllocator$Magazine.localPrefChunkSize);
            }
        }
        if (this.sharedPrefChunkSize != n) {
            this.datumTarget = Math.max(this.datumTarget >> 1, 1024);
            this.sharedPrefChunkSize = n;
        } else {
            this.datumTarget = Math.min(this.datumTarget << 1, 65534);
        }
        this.histoIndex = this.histoIndex + 1 & 3;
        this.histo = this.histos[this.histoIndex];
        this.datumCount = 0;
        Arrays.fill(this.histo, (short)0);
    }

    protected int preferredChunkSize() {
        return this.sharedPrefChunkSize;
    }

    /* synthetic */ AdaptivePoolingAllocator$AllocationStatistics(AdaptivePoolingAllocator adaptivePoolingAllocator, boolean bl, AdaptivePoolingAllocator$1 adaptivePoolingAllocator$1) {
        this(adaptivePoolingAllocator, bl);
    }
}

