/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.buffer;

import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.StampedLock;
import pro.gravit.repackage.io.netty.buffer.AbstractByteBuf;
import pro.gravit.repackage.io.netty.buffer.AdaptiveByteBufAllocator$AdaptiveAllocatorApi;
import pro.gravit.repackage.io.netty.buffer.AdaptivePoolingAllocator$1;
import pro.gravit.repackage.io.netty.buffer.AdaptivePoolingAllocator$AdaptiveByteBuf;
import pro.gravit.repackage.io.netty.buffer.AdaptivePoolingAllocator$AllocationStatistics;
import pro.gravit.repackage.io.netty.buffer.AdaptivePoolingAllocator$Chunk;
import pro.gravit.repackage.io.netty.buffer.AdaptivePoolingAllocator$ChunkAllocator;
import pro.gravit.repackage.io.netty.buffer.AdaptivePoolingAllocator$Magazine;
import pro.gravit.repackage.io.netty.buffer.AdaptivePoolingAllocator$MagazineCaching;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.util.NettyRuntime;
import pro.gravit.repackage.io.netty.util.ReferenceCounted;
import pro.gravit.repackage.io.netty.util.concurrent.FastThreadLocal;
import pro.gravit.repackage.io.netty.util.concurrent.FastThreadLocalThread;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;
import pro.gravit.repackage.io.netty.util.internal.SuppressJava6Requirement;
import pro.gravit.repackage.io.netty.util.internal.SystemPropertyUtil;

@SuppressJava6Requirement(reason="Guarded by version check")
final class AdaptivePoolingAllocator
implements AdaptiveByteBufAllocator$AdaptiveAllocatorApi {
    private static final int MIN_CHUNK_SIZE = 131072;
    private static final int EXPANSION_ATTEMPTS = 3;
    private static final int INITIAL_MAGAZINES = 4;
    private static final int RETIRE_CAPACITY = 4096;
    private static final int MAX_STRIPES = NettyRuntime.availableProcessors() * 2;
    private static final int BUFS_PER_CHUNK = 10;
    private static final int MAX_CHUNK_SIZE = 0xA00000;
    private static final int CENTRAL_QUEUE_CAPACITY = Math.max(2, SystemPropertyUtil.getInt("pro.gravit.repackage.io.netty.allocator.centralQueueCapacity", NettyRuntime.availableProcessors()));
    private static final int MAGAZINE_BUFFER_QUEUE_CAPACITY = SystemPropertyUtil.getInt("pro.gravit.repackage.io.netty.allocator.magazineBufferQueueCapacity", 1024);
    private static final Object NO_MAGAZINE = Boolean.TRUE;
    private final AdaptivePoolingAllocator$ChunkAllocator chunkAllocator;
    private final Queue<AdaptivePoolingAllocator$Chunk> centralQueue;
    private final StampedLock magazineExpandLock;
    private volatile AdaptivePoolingAllocator$Magazine[] magazines;
    private final FastThreadLocal<Object> threadLocalMagazine;
    private final Set<AdaptivePoolingAllocator$Magazine> liveCachedMagazines;
    private volatile boolean freed;

    AdaptivePoolingAllocator(AdaptivePoolingAllocator$ChunkAllocator adaptivePoolingAllocator$ChunkAllocator, AdaptivePoolingAllocator$MagazineCaching adaptivePoolingAllocator$MagazineCaching) {
        ObjectUtil.checkNotNull(adaptivePoolingAllocator$ChunkAllocator, "chunkAllocator");
        ObjectUtil.checkNotNull(adaptivePoolingAllocator$MagazineCaching, "magazineCaching");
        this.chunkAllocator = adaptivePoolingAllocator$ChunkAllocator;
        this.centralQueue = ObjectUtil.checkNotNull(AdaptivePoolingAllocator.createSharedChunkQueue(), "centralQueue");
        this.magazineExpandLock = new StampedLock();
        if (adaptivePoolingAllocator$MagazineCaching != AdaptivePoolingAllocator$MagazineCaching.None) {
            assert (adaptivePoolingAllocator$MagazineCaching == AdaptivePoolingAllocator$MagazineCaching.EventLoopThreads || adaptivePoolingAllocator$MagazineCaching == AdaptivePoolingAllocator$MagazineCaching.FastThreadLocalThreads);
            boolean bl = adaptivePoolingAllocator$MagazineCaching == AdaptivePoolingAllocator$MagazineCaching.FastThreadLocalThreads;
            CopyOnWriteArraySet<AdaptivePoolingAllocator$Magazine> copyOnWriteArraySet = new CopyOnWriteArraySet<AdaptivePoolingAllocator$Magazine>();
            this.threadLocalMagazine = new AdaptivePoolingAllocator$1(this, bl, copyOnWriteArraySet);
            this.liveCachedMagazines = copyOnWriteArraySet;
        } else {
            this.threadLocalMagazine = null;
            this.liveCachedMagazines = null;
        }
        AdaptivePoolingAllocator$Magazine[] adaptivePoolingAllocator$MagazineArray = new AdaptivePoolingAllocator$Magazine[4];
        for (int i = 0; i < adaptivePoolingAllocator$MagazineArray.length; ++i) {
            adaptivePoolingAllocator$MagazineArray[i] = new AdaptivePoolingAllocator$Magazine(this);
        }
        this.magazines = adaptivePoolingAllocator$MagazineArray;
    }

    private static Queue<AdaptivePoolingAllocator$Chunk> createSharedChunkQueue() {
        return PlatformDependent.newFixedMpmcQueue(CENTRAL_QUEUE_CAPACITY);
    }

    @Override
    public ByteBuf allocate(int n, int n2) {
        return this.allocate(n, n2, Thread.currentThread(), null);
    }

    private AdaptivePoolingAllocator$AdaptiveByteBuf allocate(int n, int n2, Thread thread, AdaptivePoolingAllocator$AdaptiveByteBuf adaptivePoolingAllocator$AdaptiveByteBuf) {
        if (n <= 0xA00000) {
            AdaptivePoolingAllocator$Magazine[] adaptivePoolingAllocator$MagazineArray;
            Object object;
            int n3 = AdaptivePoolingAllocator$AllocationStatistics.sizeBucket(n);
            FastThreadLocal<Object> fastThreadLocal = this.threadLocalMagazine;
            if (fastThreadLocal != null && thread instanceof FastThreadLocalThread && (object = fastThreadLocal.get()) != NO_MAGAZINE) {
                AdaptivePoolingAllocator$Magazine adaptivePoolingAllocator$Magazine = (AdaptivePoolingAllocator$Magazine)object;
                if (adaptivePoolingAllocator$AdaptiveByteBuf == null) {
                    adaptivePoolingAllocator$AdaptiveByteBuf = adaptivePoolingAllocator$Magazine.newBuffer();
                }
                boolean bl = adaptivePoolingAllocator$Magazine.tryAllocate(n, n3, n2, adaptivePoolingAllocator$AdaptiveByteBuf);
                assert (bl) : "Allocation of threadLocalMagazine must always succeed";
                return adaptivePoolingAllocator$AdaptiveByteBuf;
            }
            long l = thread.getId();
            int n4 = 0;
            do {
                adaptivePoolingAllocator$MagazineArray = this.magazines;
                int n5 = adaptivePoolingAllocator$MagazineArray.length - 1;
                int n6 = (int)(l & (long)n5);
                int n7 = Integer.numberOfTrailingZeros(~n5);
                for (int i = 0; i < n7; ++i) {
                    AdaptivePoolingAllocator$Magazine adaptivePoolingAllocator$Magazine = adaptivePoolingAllocator$MagazineArray[n6 + i & n5];
                    if (adaptivePoolingAllocator$AdaptiveByteBuf == null) {
                        adaptivePoolingAllocator$AdaptiveByteBuf = adaptivePoolingAllocator$Magazine.newBuffer();
                    }
                    if (!adaptivePoolingAllocator$Magazine.tryAllocate(n, n3, n2, adaptivePoolingAllocator$AdaptiveByteBuf)) continue;
                    return adaptivePoolingAllocator$AdaptiveByteBuf;
                }
            } while (++n4 <= 3 && this.tryExpandMagazines(adaptivePoolingAllocator$MagazineArray.length));
        }
        return this.allocateFallback(n, n2, thread, adaptivePoolingAllocator$AdaptiveByteBuf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AdaptivePoolingAllocator$AdaptiveByteBuf allocateFallback(int n, int n2, Thread thread, AdaptivePoolingAllocator$AdaptiveByteBuf adaptivePoolingAllocator$AdaptiveByteBuf) {
        AdaptivePoolingAllocator$Magazine adaptivePoolingAllocator$Magazine;
        ReferenceCounted referenceCounted;
        if (adaptivePoolingAllocator$AdaptiveByteBuf != null) {
            referenceCounted = adaptivePoolingAllocator$AdaptiveByteBuf.chunk;
            if (referenceCounted == null || referenceCounted == AdaptivePoolingAllocator$Magazine.access$100() || (adaptivePoolingAllocator$Magazine = referenceCounted.currentMagazine()) == null) {
                adaptivePoolingAllocator$Magazine = this.getFallbackMagazine(thread);
            }
        } else {
            adaptivePoolingAllocator$Magazine = this.getFallbackMagazine(thread);
            adaptivePoolingAllocator$AdaptiveByteBuf = adaptivePoolingAllocator$Magazine.newBuffer();
        }
        referenceCounted = this.chunkAllocator.allocate(n, n2);
        AdaptivePoolingAllocator$Chunk adaptivePoolingAllocator$Chunk = new AdaptivePoolingAllocator$Chunk((AbstractByteBuf)referenceCounted, adaptivePoolingAllocator$Magazine, false);
        try {
            adaptivePoolingAllocator$Chunk.readInitInto(adaptivePoolingAllocator$AdaptiveByteBuf, n, n2);
        }
        finally {
            adaptivePoolingAllocator$Chunk.release();
        }
        return adaptivePoolingAllocator$AdaptiveByteBuf;
    }

    private AdaptivePoolingAllocator$Magazine getFallbackMagazine(Thread thread) {
        Object object;
        FastThreadLocal<Object> fastThreadLocal = this.threadLocalMagazine;
        if (fastThreadLocal != null && thread instanceof FastThreadLocalThread && (object = fastThreadLocal.get()) != NO_MAGAZINE) {
            return (AdaptivePoolingAllocator$Magazine)object;
        }
        AdaptivePoolingAllocator$Magazine[] adaptivePoolingAllocator$MagazineArray = this.magazines;
        return adaptivePoolingAllocator$MagazineArray[(int)thread.getId() & adaptivePoolingAllocator$MagazineArray.length - 1];
    }

    void allocate(int n, int n2, AdaptivePoolingAllocator$AdaptiveByteBuf adaptivePoolingAllocator$AdaptiveByteBuf) {
        AdaptivePoolingAllocator$AdaptiveByteBuf adaptivePoolingAllocator$AdaptiveByteBuf2 = this.allocate(n, n2, Thread.currentThread(), adaptivePoolingAllocator$AdaptiveByteBuf);
        assert (adaptivePoolingAllocator$AdaptiveByteBuf2 == adaptivePoolingAllocator$AdaptiveByteBuf) : "Re-allocation created separate buffer instance";
    }

    @Override
    public long usedMemory() {
        long l = 0L;
        for (AdaptivePoolingAllocator$Chunk adaptivePoolingAllocator$Chunk : this.centralQueue) {
            l += (long)adaptivePoolingAllocator$Chunk.capacity();
        }
        for (AdaptivePoolingAllocator$Magazine adaptivePoolingAllocator$Magazine : this.magazines) {
            l += AdaptivePoolingAllocator$Magazine.access$200(adaptivePoolingAllocator$Magazine).get();
        }
        if (this.liveCachedMagazines != null) {
            for (AdaptivePoolingAllocator$Magazine adaptivePoolingAllocator$Magazine : this.liveCachedMagazines) {
                l += AdaptivePoolingAllocator$Magazine.access$200(adaptivePoolingAllocator$Magazine).get();
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryExpandMagazines(int n) {
        if (n >= MAX_STRIPES) {
            return true;
        }
        long l = this.magazineExpandLock.tryWriteLock();
        if (l != 0L) {
            AdaptivePoolingAllocator$Magazine[] adaptivePoolingAllocator$MagazineArray;
            try {
                adaptivePoolingAllocator$MagazineArray = this.magazines;
                if (adaptivePoolingAllocator$MagazineArray.length >= MAX_STRIPES || adaptivePoolingAllocator$MagazineArray.length > n || this.freed) {
                    boolean bl = true;
                    return bl;
                }
                int n2 = adaptivePoolingAllocator$MagazineArray[0].sharedPrefChunkSize;
                AdaptivePoolingAllocator$Magazine[] adaptivePoolingAllocator$MagazineArray2 = new AdaptivePoolingAllocator$Magazine[adaptivePoolingAllocator$MagazineArray.length * 2];
                int n3 = adaptivePoolingAllocator$MagazineArray2.length;
                for (int i = 0; i < n3; ++i) {
                    AdaptivePoolingAllocator$Magazine adaptivePoolingAllocator$Magazine = new AdaptivePoolingAllocator$Magazine(this);
                    adaptivePoolingAllocator$Magazine.localPrefChunkSize = n2;
                    adaptivePoolingAllocator$Magazine.sharedPrefChunkSize = n2;
                    adaptivePoolingAllocator$MagazineArray2[i] = adaptivePoolingAllocator$Magazine;
                }
                this.magazines = adaptivePoolingAllocator$MagazineArray2;
            }
            finally {
                this.magazineExpandLock.unlockWrite(l);
            }
            for (AdaptivePoolingAllocator$Magazine adaptivePoolingAllocator$Magazine : adaptivePoolingAllocator$MagazineArray) {
                adaptivePoolingAllocator$Magazine.free();
            }
        }
        return true;
    }

    private boolean offerToQueue(AdaptivePoolingAllocator$Chunk adaptivePoolingAllocator$Chunk) {
        if (this.freed) {
            return false;
        }
        assert (AdaptivePoolingAllocator$Chunk.access$300(adaptivePoolingAllocator$Chunk) == 0);
        assert (AdaptivePoolingAllocator$Chunk.access$400(adaptivePoolingAllocator$Chunk) == null);
        boolean bl = this.centralQueue.offer(adaptivePoolingAllocator$Chunk);
        if (this.freed && bl) {
            this.freeCentralQueue();
        }
        return bl;
    }

    protected void finalize() {
        try {
            super.finalize();
        }
        finally {
            this.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void free() {
        this.freed = true;
        long l = this.magazineExpandLock.writeLock();
        try {
            AdaptivePoolingAllocator$Magazine[] adaptivePoolingAllocator$MagazineArray;
            for (AdaptivePoolingAllocator$Magazine adaptivePoolingAllocator$Magazine : adaptivePoolingAllocator$MagazineArray = this.magazines) {
                adaptivePoolingAllocator$Magazine.free();
            }
        }
        finally {
            this.magazineExpandLock.unlockWrite(l);
        }
        this.freeCentralQueue();
    }

    private void freeCentralQueue() {
        AdaptivePoolingAllocator$Chunk adaptivePoolingAllocator$Chunk;
        while ((adaptivePoolingAllocator$Chunk = this.centralQueue.poll()) != null) {
            adaptivePoolingAllocator$Chunk.release();
        }
    }

    static int sizeBucket(int n) {
        return AdaptivePoolingAllocator$AllocationStatistics.sizeBucket(n);
    }

    static /* synthetic */ Object access$000() {
        return NO_MAGAZINE;
    }

    static /* synthetic */ AdaptivePoolingAllocator$Magazine[] access$500(AdaptivePoolingAllocator adaptivePoolingAllocator) {
        return adaptivePoolingAllocator.magazines;
    }

    static /* synthetic */ int access$700() {
        return MAGAZINE_BUFFER_QUEUE_CAPACITY;
    }

    static /* synthetic */ Queue access$900(AdaptivePoolingAllocator adaptivePoolingAllocator) {
        return adaptivePoolingAllocator.centralQueue;
    }

    static /* synthetic */ AdaptivePoolingAllocator$ChunkAllocator access$1000(AdaptivePoolingAllocator adaptivePoolingAllocator) {
        return adaptivePoolingAllocator.chunkAllocator;
    }

    static /* synthetic */ boolean access$1300(AdaptivePoolingAllocator adaptivePoolingAllocator, AdaptivePoolingAllocator$Chunk adaptivePoolingAllocator$Chunk) {
        return adaptivePoolingAllocator.offerToQueue(adaptivePoolingAllocator$Chunk);
    }

    static {
        if (CENTRAL_QUEUE_CAPACITY < 2) {
            throw new IllegalArgumentException("CENTRAL_QUEUE_CAPACITY: " + CENTRAL_QUEUE_CAPACITY + " (expected: >= " + 2 + ')');
        }
        if (MAGAZINE_BUFFER_QUEUE_CAPACITY < 2) {
            throw new IllegalArgumentException("MAGAZINE_BUFFER_QUEUE_CAPACITY: " + MAGAZINE_BUFFER_QUEUE_CAPACITY + " (expected: >= " + 2 + ')');
        }
    }
}

