/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.buffer;

import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Arrays;
import pro.gravit.repackage.io.netty.buffer.AbstractByteBuf;
import pro.gravit.repackage.io.netty.buffer.AbstractByteBufAllocator;
import pro.gravit.repackage.io.netty.buffer.AdaptiveByteBufAllocator;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.buffer.ByteBufAllocator;
import pro.gravit.repackage.io.netty.buffer.ByteBufUtil$1;
import pro.gravit.repackage.io.netty.buffer.ByteBufUtil$2;
import pro.gravit.repackage.io.netty.buffer.ByteBufUtil$HexUtil;
import pro.gravit.repackage.io.netty.buffer.ByteBufUtil$ThreadLocalDirectByteBuf;
import pro.gravit.repackage.io.netty.buffer.ByteBufUtil$ThreadLocalUnsafeDirectByteBuf;
import pro.gravit.repackage.io.netty.buffer.PooledByteBufAllocator;
import pro.gravit.repackage.io.netty.buffer.UnpooledByteBufAllocator;
import pro.gravit.repackage.io.netty.buffer.WrappedByteBuf;
import pro.gravit.repackage.io.netty.buffer.WrappedCompositeByteBuf;
import pro.gravit.repackage.io.netty.util.AsciiString;
import pro.gravit.repackage.io.netty.util.ByteProcessor;
import pro.gravit.repackage.io.netty.util.CharsetUtil;
import pro.gravit.repackage.io.netty.util.IllegalReferenceCountException;
import pro.gravit.repackage.io.netty.util.ResourceLeakDetector;
import pro.gravit.repackage.io.netty.util.concurrent.FastThreadLocal;
import pro.gravit.repackage.io.netty.util.concurrent.FastThreadLocalThread;
import pro.gravit.repackage.io.netty.util.internal.MathUtil;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;
import pro.gravit.repackage.io.netty.util.internal.SWARUtil;
import pro.gravit.repackage.io.netty.util.internal.StringUtil;
import pro.gravit.repackage.io.netty.util.internal.SystemPropertyUtil;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;

public final class ByteBufUtil {
    private static final InternalLogger logger;
    private static final FastThreadLocal<byte[]> BYTE_ARRAYS;
    private static final byte WRITE_UTF_UNKNOWN = 63;
    private static final int MAX_CHAR_BUFFER_SIZE;
    private static final int THREAD_LOCAL_BUFFER_SIZE;
    private static final int MAX_BYTES_PER_CHAR_UTF8;
    static final int WRITE_CHUNK_SIZE = 8192;
    static final ByteBufAllocator DEFAULT_ALLOCATOR;
    static final int MAX_TL_ARRAY_LEN = 1024;
    private static final ByteProcessor FIND_NON_ASCII;

    static byte[] threadLocalTempArray(int n) {
        if (n <= 1024 && Thread.currentThread() instanceof FastThreadLocalThread) {
            return BYTE_ARRAYS.get();
        }
        return PlatformDependent.allocateUninitializedArray(n);
    }

    public static boolean isAccessible(ByteBuf byteBuf) {
        return byteBuf.isAccessible();
    }

    public static ByteBuf ensureAccessible(ByteBuf byteBuf) {
        if (!byteBuf.isAccessible()) {
            throw new IllegalReferenceCountException(byteBuf.refCnt());
        }
        return byteBuf;
    }

    public static String hexDump(ByteBuf byteBuf) {
        return ByteBufUtil.hexDump(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes());
    }

    public static String hexDump(ByteBuf byteBuf, int n, int n2) {
        return ByteBufUtil$HexUtil.access$000(byteBuf, n, n2);
    }

    public static String hexDump(byte[] byArray) {
        return ByteBufUtil.hexDump(byArray, 0, byArray.length);
    }

    public static String hexDump(byte[] byArray, int n, int n2) {
        return ByteBufUtil$HexUtil.access$100(byArray, n, n2);
    }

    public static byte decodeHexByte(CharSequence charSequence, int n) {
        return StringUtil.decodeHexByte(charSequence, n);
    }

    public static byte[] decodeHexDump(CharSequence charSequence) {
        return StringUtil.decodeHexDump(charSequence, 0, charSequence.length());
    }

    public static byte[] decodeHexDump(CharSequence charSequence, int n, int n2) {
        return StringUtil.decodeHexDump(charSequence, n, n2);
    }

    public static boolean ensureWritableSuccess(int n) {
        return n == 0 || n == 2;
    }

    public static int hashCode(ByteBuf byteBuf) {
        int n;
        int n2 = byteBuf.readableBytes();
        int n3 = n2 >>> 2;
        int n4 = n2 & 3;
        int n5 = 1;
        int n6 = byteBuf.readerIndex();
        if (byteBuf.order() == ByteOrder.BIG_ENDIAN) {
            for (n = n3; n > 0; --n) {
                n5 = 31 * n5 + byteBuf.getInt(n6);
                n6 += 4;
            }
        } else {
            for (n = n3; n > 0; --n) {
                n5 = 31 * n5 + ByteBufUtil.swapInt(byteBuf.getInt(n6));
                n6 += 4;
            }
        }
        for (n = n4; n > 0; --n) {
            n5 = 31 * n5 + byteBuf.getByte(n6++);
        }
        if (n5 == 0) {
            n5 = 1;
        }
        return n5;
    }

    public static int indexOf(ByteBuf byteBuf, ByteBuf byteBuf2) {
        int n;
        if (byteBuf2 == null || byteBuf == null) {
            return -1;
        }
        if (byteBuf.readableBytes() > byteBuf2.readableBytes()) {
            return -1;
        }
        int n2 = byteBuf2.readableBytes();
        int n3 = byteBuf.readableBytes();
        if (n3 == 0) {
            return 0;
        }
        if (n3 == 1) {
            return byteBuf2.indexOf(byteBuf2.readerIndex(), byteBuf2.writerIndex(), byteBuf.getByte(byteBuf.readerIndex()));
        }
        int n4 = 0;
        int n5 = byteBuf.readerIndex();
        int n6 = byteBuf2.readerIndex();
        long l = ByteBufUtil.maxSuf(byteBuf, n3, n5, true);
        long l2 = ByteBufUtil.maxSuf(byteBuf, n3, n5, false);
        int n7 = Math.max((int)(l >> 32), (int)(l2 >> 32));
        int n8 = Math.max((int)l, (int)l2);
        if (ByteBufUtil.equals(byteBuf, n5, byteBuf, n5 + n8, n = Math.min(n3 - n8, n7 + 1))) {
            int n9 = -1;
            while (n4 <= n2 - n3) {
                int n10;
                for (n10 = Math.max(n7, n9) + 1; n10 < n3 && byteBuf.getByte(n10 + n5) == byteBuf2.getByte(n10 + n4 + n6); ++n10) {
                }
                if (n10 > n2) {
                    return -1;
                }
                if (n10 >= n3) {
                    for (n10 = n7; n10 > n9 && byteBuf.getByte(n10 + n5) == byteBuf2.getByte(n10 + n4 + n6); --n10) {
                    }
                    if (n10 <= n9) {
                        return n4 + n6;
                    }
                    n4 += n8;
                    n9 = n3 - n8 - 1;
                    continue;
                }
                n4 += n10 - n7;
                n9 = -1;
            }
        } else {
            n8 = Math.max(n7 + 1, n3 - n7 - 1) + 1;
            while (n4 <= n2 - n3) {
                int n11;
                for (n11 = n7 + 1; n11 < n3 && byteBuf.getByte(n11 + n5) == byteBuf2.getByte(n11 + n4 + n6); ++n11) {
                }
                if (n11 > n2) {
                    return -1;
                }
                if (n11 >= n3) {
                    for (n11 = n7; n11 >= 0 && byteBuf.getByte(n11 + n5) == byteBuf2.getByte(n11 + n4 + n6); --n11) {
                    }
                    if (n11 < 0) {
                        return n4 + n6;
                    }
                    n4 += n8;
                    continue;
                }
                n4 += n11 - n7;
            }
        }
        return -1;
    }

    private static long maxSuf(ByteBuf byteBuf, int n, int n2, boolean bl) {
        int n3 = 1;
        int n4 = -1;
        int n5 = n2;
        int n6 = 1;
        while (n5 + n6 < n) {
            boolean bl2;
            byte by = byteBuf.getByte(n5 + n6);
            byte by2 = byteBuf.getByte(n4 + n6);
            boolean bl3 = bl ? by < by2 : (bl2 = by > by2);
            if (bl2) {
                n6 = 1;
                n3 = (n5 += n6) - n4;
                continue;
            }
            if (by == by2) {
                if (n6 != n3) {
                    ++n6;
                    continue;
                }
                n5 += n3;
                n6 = 1;
                continue;
            }
            n4 = n5;
            n5 = n4 + 1;
            n3 = 1;
            n6 = 1;
        }
        return ((long)n4 << 32) + (long)n3;
    }

    public static boolean equals(ByteBuf byteBuf, int n, ByteBuf byteBuf2, int n2, int n3) {
        int n4;
        ObjectUtil.checkNotNull(byteBuf, "a");
        ObjectUtil.checkNotNull(byteBuf2, "b");
        ObjectUtil.checkPositiveOrZero(n, "aStartIndex");
        ObjectUtil.checkPositiveOrZero(n2, "bStartIndex");
        ObjectUtil.checkPositiveOrZero(n3, "length");
        if (byteBuf.writerIndex() - n3 < n || byteBuf2.writerIndex() - n3 < n2) {
            return false;
        }
        int n5 = n3 >>> 3;
        int n6 = n3 & 7;
        if (byteBuf.order() == byteBuf2.order()) {
            for (n4 = n5; n4 > 0; --n4) {
                if (byteBuf.getLong(n) != byteBuf2.getLong(n2)) {
                    return false;
                }
                n += 8;
                n2 += 8;
            }
        } else {
            for (n4 = n5; n4 > 0; --n4) {
                if (byteBuf.getLong(n) != ByteBufUtil.swapLong(byteBuf2.getLong(n2))) {
                    return false;
                }
                n += 8;
                n2 += 8;
            }
        }
        for (n4 = n6; n4 > 0; --n4) {
            if (byteBuf.getByte(n) != byteBuf2.getByte(n2)) {
                return false;
            }
            ++n;
            ++n2;
        }
        return true;
    }

    public static boolean equals(ByteBuf byteBuf, ByteBuf byteBuf2) {
        if (byteBuf == byteBuf2) {
            return true;
        }
        int n = byteBuf.readableBytes();
        if (n != byteBuf2.readableBytes()) {
            return false;
        }
        return ByteBufUtil.equals(byteBuf, byteBuf.readerIndex(), byteBuf2, byteBuf2.readerIndex(), n);
    }

    public static int compare(ByteBuf byteBuf, ByteBuf byteBuf2) {
        int n;
        if (byteBuf == byteBuf2) {
            return 0;
        }
        int n2 = byteBuf.readableBytes();
        int n3 = byteBuf2.readableBytes();
        int n4 = Math.min(n2, n3);
        int n5 = n4 >>> 2;
        int n6 = n4 & 3;
        int n7 = byteBuf.readerIndex();
        int n8 = byteBuf2.readerIndex();
        if (n5 > 0) {
            long l;
            n = byteBuf.order() == ByteOrder.BIG_ENDIAN ? 1 : 0;
            int n9 = n5 << 2;
            if (byteBuf.order() == byteBuf2.order()) {
                l = n != 0 ? ByteBufUtil.compareUintBigEndian(byteBuf, byteBuf2, n7, n8, n9) : ByteBufUtil.compareUintLittleEndian(byteBuf, byteBuf2, n7, n8, n9);
            } else {
                long l2 = l = n != 0 ? ByteBufUtil.compareUintBigEndianA(byteBuf, byteBuf2, n7, n8, n9) : ByteBufUtil.compareUintBigEndianB(byteBuf, byteBuf2, n7, n8, n9);
            }
            if (l != 0L) {
                return (int)Math.min(Integer.MAX_VALUE, Math.max(Integer.MIN_VALUE, l));
            }
            n7 += n9;
            n8 += n9;
        }
        n = n7 + n6;
        while (n7 < n) {
            int n10 = byteBuf.getUnsignedByte(n7) - byteBuf2.getUnsignedByte(n8);
            if (n10 != 0) {
                return n10;
            }
            ++n7;
            ++n8;
        }
        return n2 - n3;
    }

    private static long compareUintBigEndian(ByteBuf byteBuf, ByteBuf byteBuf2, int n, int n2, int n3) {
        int n4 = n + n3;
        while (n < n4) {
            long l = byteBuf.getUnsignedInt(n) - byteBuf2.getUnsignedInt(n2);
            if (l != 0L) {
                return l;
            }
            n += 4;
            n2 += 4;
        }
        return 0L;
    }

    private static long compareUintLittleEndian(ByteBuf byteBuf, ByteBuf byteBuf2, int n, int n2, int n3) {
        int n4 = n + n3;
        while (n < n4) {
            long l = ByteBufUtil.uintFromLE(byteBuf.getUnsignedIntLE(n)) - ByteBufUtil.uintFromLE(byteBuf2.getUnsignedIntLE(n2));
            if (l != 0L) {
                return l;
            }
            n += 4;
            n2 += 4;
        }
        return 0L;
    }

    private static long compareUintBigEndianA(ByteBuf byteBuf, ByteBuf byteBuf2, int n, int n2, int n3) {
        int n4 = n + n3;
        while (n < n4) {
            long l;
            long l2 = byteBuf.getUnsignedInt(n);
            long l3 = l2 - (l = ByteBufUtil.uintFromLE(byteBuf2.getUnsignedIntLE(n2)));
            if (l3 != 0L) {
                return l3;
            }
            n += 4;
            n2 += 4;
        }
        return 0L;
    }

    private static long compareUintBigEndianB(ByteBuf byteBuf, ByteBuf byteBuf2, int n, int n2, int n3) {
        int n4 = n + n3;
        while (n < n4) {
            long l;
            long l2 = ByteBufUtil.uintFromLE(byteBuf.getUnsignedIntLE(n));
            long l3 = l2 - (l = byteBuf2.getUnsignedInt(n2));
            if (l3 != 0L) {
                return l3;
            }
            n += 4;
            n2 += 4;
        }
        return 0L;
    }

    private static long uintFromLE(long l) {
        return Long.reverseBytes(l) >>> 32;
    }

    private static int unrolledFirstIndexOf(AbstractByteBuf abstractByteBuf, int n, int n2, byte by) {
        assert (n2 > 0 && n2 < 8);
        if (abstractByteBuf._getByte(n) == by) {
            return n;
        }
        if (n2 == 1) {
            return -1;
        }
        if (abstractByteBuf._getByte(n + 1) == by) {
            return n + 1;
        }
        if (n2 == 2) {
            return -1;
        }
        if (abstractByteBuf._getByte(n + 2) == by) {
            return n + 2;
        }
        if (n2 == 3) {
            return -1;
        }
        if (abstractByteBuf._getByte(n + 3) == by) {
            return n + 3;
        }
        if (n2 == 4) {
            return -1;
        }
        if (abstractByteBuf._getByte(n + 4) == by) {
            return n + 4;
        }
        if (n2 == 5) {
            return -1;
        }
        if (abstractByteBuf._getByte(n + 5) == by) {
            return n + 5;
        }
        if (n2 == 6) {
            return -1;
        }
        if (abstractByteBuf._getByte(n + 6) == by) {
            return n + 6;
        }
        return -1;
    }

    static int firstIndexOf(AbstractByteBuf abstractByteBuf, int n, int n2, byte by) {
        int n3;
        if ((n = Math.max(n, 0)) >= n2 || abstractByteBuf.capacity() == 0) {
            return -1;
        }
        int n4 = n2 - n;
        abstractByteBuf.checkIndex(n, n4);
        if (!PlatformDependent.isUnaligned()) {
            return ByteBufUtil.linearFirstIndexOf(abstractByteBuf, n, n2, by);
        }
        assert (PlatformDependent.isUnaligned());
        int n5 = n;
        int n6 = n4 & 7;
        if (n6 > 0) {
            n3 = ByteBufUtil.unrolledFirstIndexOf(abstractByteBuf, n, n6, by);
            if (n3 != -1) {
                return n3;
            }
            if ((n5 += n6) == n2) {
                return -1;
            }
        }
        n3 = n4 >>> 3;
        ByteOrder byteOrder = ByteOrder.nativeOrder();
        boolean bl = byteOrder == abstractByteBuf.order();
        boolean bl2 = byteOrder == ByteOrder.LITTLE_ENDIAN;
        long l = SWARUtil.compilePattern(by);
        for (int i = 0; i < n3; ++i) {
            long l2 = bl2 ? abstractByteBuf._getLongLE(n5) : abstractByteBuf._getLong(n5);
            long l3 = SWARUtil.applyPattern(l2, l);
            if (l3 != 0L) {
                return n5 + SWARUtil.getIndex(l3, bl);
            }
            n5 += 8;
        }
        return -1;
    }

    private static int linearFirstIndexOf(AbstractByteBuf abstractByteBuf, int n, int n2, byte by) {
        for (int i = n; i < n2; ++i) {
            if (abstractByteBuf._getByte(i) != by) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(ByteBuf byteBuf, int n, int n2, byte by) {
        return byteBuf.indexOf(n, n2, by);
    }

    public static short swapShort(short s) {
        return Short.reverseBytes(s);
    }

    public static int swapMedium(int n) {
        int n2 = n << 16 & 0xFF0000 | n & 0xFF00 | n >>> 16 & 0xFF;
        if ((n2 & 0x800000) != 0) {
            n2 |= 0xFF000000;
        }
        return n2;
    }

    public static int swapInt(int n) {
        return Integer.reverseBytes(n);
    }

    public static long swapLong(long l) {
        return Long.reverseBytes(l);
    }

    public static ByteBuf writeShortBE(ByteBuf byteBuf, int n) {
        return byteBuf.order() == ByteOrder.BIG_ENDIAN ? byteBuf.writeShort(n) : byteBuf.writeShort(ByteBufUtil.swapShort((short)n));
    }

    public static ByteBuf setShortBE(ByteBuf byteBuf, int n, int n2) {
        return byteBuf.order() == ByteOrder.BIG_ENDIAN ? byteBuf.setShort(n, n2) : byteBuf.setShort(n, ByteBufUtil.swapShort((short)n2));
    }

    public static ByteBuf writeMediumBE(ByteBuf byteBuf, int n) {
        return byteBuf.order() == ByteOrder.BIG_ENDIAN ? byteBuf.writeMedium(n) : byteBuf.writeMedium(ByteBufUtil.swapMedium(n));
    }

    public static int readUnsignedShortBE(ByteBuf byteBuf) {
        return byteBuf.order() == ByteOrder.BIG_ENDIAN ? byteBuf.readUnsignedShort() : ByteBufUtil.swapShort((short)byteBuf.readUnsignedShort()) & 0xFFFF;
    }

    public static int readIntBE(ByteBuf byteBuf) {
        return byteBuf.order() == ByteOrder.BIG_ENDIAN ? byteBuf.readInt() : ByteBufUtil.swapInt(byteBuf.readInt());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuf readBytes(ByteBufAllocator byteBufAllocator, ByteBuf byteBuf, int n) {
        boolean bl = true;
        ByteBuf byteBuf2 = byteBufAllocator.buffer(n);
        try {
            byteBuf.readBytes(byteBuf2);
            bl = false;
            ByteBuf byteBuf3 = byteBuf2;
            return byteBuf3;
        }
        finally {
            if (bl) {
                byteBuf2.release();
            }
        }
    }

    static int lastIndexOf(AbstractByteBuf abstractByteBuf, int n, int n2, byte by) {
        assert (n > n2);
        int n3 = abstractByteBuf.capacity();
        if ((n = Math.min(n, n3)) <= 0) {
            return -1;
        }
        int n4 = n - n2;
        abstractByteBuf.checkIndex(n2, n4);
        if (!PlatformDependent.isUnaligned()) {
            return ByteBufUtil.linearLastIndexOf(abstractByteBuf, n, n2, by);
        }
        int n5 = n4 >>> 3;
        if (n5 > 0) {
            ByteOrder byteOrder = ByteOrder.nativeOrder();
            boolean bl = byteOrder == abstractByteBuf.order();
            boolean bl2 = byteOrder == ByteOrder.LITTLE_ENDIAN;
            long l = SWARUtil.compilePattern(by);
            int n6 = 0;
            int n7 = n - 8;
            while (n6 < n5) {
                long l2 = bl2 ? abstractByteBuf._getLongLE(n7) : abstractByteBuf._getLong(n7);
                long l3 = SWARUtil.applyPattern(l2, l);
                if (l3 != 0L) {
                    return n7 + 8 - 1 - SWARUtil.getIndex(l3, !bl);
                }
                ++n6;
                n7 -= 8;
            }
        }
        return ByteBufUtil.unrolledLastIndexOf(abstractByteBuf, n - (n5 << 3), n4 & 7, by);
    }

    private static int linearLastIndexOf(AbstractByteBuf abstractByteBuf, int n, int n2, byte by) {
        for (int i = n - 1; i >= n2; --i) {
            if (abstractByteBuf._getByte(i) != by) continue;
            return i;
        }
        return -1;
    }

    private static int unrolledLastIndexOf(AbstractByteBuf abstractByteBuf, int n, int n2, byte by) {
        assert (n2 >= 0 && n2 < 8);
        if (n2 == 0) {
            return -1;
        }
        if (abstractByteBuf._getByte(n - 1) == by) {
            return n - 1;
        }
        if (n2 == 1) {
            return -1;
        }
        if (abstractByteBuf._getByte(n - 2) == by) {
            return n - 2;
        }
        if (n2 == 2) {
            return -1;
        }
        if (abstractByteBuf._getByte(n - 3) == by) {
            return n - 3;
        }
        if (n2 == 3) {
            return -1;
        }
        if (abstractByteBuf._getByte(n - 4) == by) {
            return n - 4;
        }
        if (n2 == 4) {
            return -1;
        }
        if (abstractByteBuf._getByte(n - 5) == by) {
            return n - 5;
        }
        if (n2 == 5) {
            return -1;
        }
        if (abstractByteBuf._getByte(n - 6) == by) {
            return n - 6;
        }
        if (n2 == 6) {
            return -1;
        }
        if (abstractByteBuf._getByte(n - 7) == by) {
            return n - 7;
        }
        return -1;
    }

    private static CharSequence checkCharSequenceBounds(CharSequence charSequence, int n, int n2) {
        if (MathUtil.isOutOfBounds(n, n2 - n, charSequence.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + n + ") <= end (" + n2 + ") <= seq.length(" + charSequence.length() + ')');
        }
        return charSequence;
    }

    public static ByteBuf writeUtf8(ByteBufAllocator byteBufAllocator, CharSequence charSequence) {
        ByteBuf byteBuf = byteBufAllocator.buffer(ByteBufUtil.utf8MaxBytes(charSequence));
        ByteBufUtil.writeUtf8(byteBuf, charSequence);
        return byteBuf;
    }

    public static int writeUtf8(ByteBuf byteBuf, CharSequence charSequence) {
        int n = charSequence.length();
        return ByteBufUtil.reserveAndWriteUtf8Seq(byteBuf, charSequence, 0, n, ByteBufUtil.utf8MaxBytes(n));
    }

    public static int writeUtf8(ByteBuf byteBuf, CharSequence charSequence, int n, int n2) {
        ByteBufUtil.checkCharSequenceBounds(charSequence, n, n2);
        return ByteBufUtil.reserveAndWriteUtf8Seq(byteBuf, charSequence, n, n2, ByteBufUtil.utf8MaxBytes(n2 - n));
    }

    public static int reserveAndWriteUtf8(ByteBuf byteBuf, CharSequence charSequence, int n) {
        return ByteBufUtil.reserveAndWriteUtf8Seq(byteBuf, charSequence, 0, charSequence.length(), n);
    }

    public static int reserveAndWriteUtf8(ByteBuf byteBuf, CharSequence charSequence, int n, int n2, int n3) {
        return ByteBufUtil.reserveAndWriteUtf8Seq(byteBuf, ByteBufUtil.checkCharSequenceBounds(charSequence, n, n2), n, n2, n3);
    }

    private static int reserveAndWriteUtf8Seq(ByteBuf byteBuf, CharSequence charSequence, int n, int n2, int n3) {
        while (true) {
            if (byteBuf instanceof WrappedCompositeByteBuf) {
                byteBuf = byteBuf.unwrap();
                continue;
            }
            if (byteBuf instanceof AbstractByteBuf) {
                AbstractByteBuf abstractByteBuf = (AbstractByteBuf)byteBuf;
                abstractByteBuf.ensureWritable0(n3);
                int n4 = ByteBufUtil.writeUtf8(abstractByteBuf, abstractByteBuf.writerIndex, n3, charSequence, n, n2);
                abstractByteBuf.writerIndex += n4;
                return n4;
            }
            if (!(byteBuf instanceof WrappedByteBuf)) break;
            byteBuf = byteBuf.unwrap();
        }
        byte[] byArray = charSequence.subSequence(n, n2).toString().getBytes(CharsetUtil.UTF_8);
        byteBuf.writeBytes(byArray);
        return byArray.length;
    }

    static int writeUtf8(AbstractByteBuf abstractByteBuf, int n, int n2, CharSequence charSequence, int n3) {
        return ByteBufUtil.writeUtf8(abstractByteBuf, n, n2, charSequence, 0, n3);
    }

    static int writeUtf8(AbstractByteBuf abstractByteBuf, int n, int n2, CharSequence charSequence, int n3, int n4) {
        if (charSequence instanceof AsciiString) {
            ByteBufUtil.writeAsciiString(abstractByteBuf, n, (AsciiString)charSequence, n3, n4);
            return n4 - n3;
        }
        if (PlatformDependent.hasUnsafe()) {
            if (abstractByteBuf.hasArray()) {
                return ByteBufUtil.unsafeWriteUtf8(abstractByteBuf.array(), PlatformDependent.byteArrayBaseOffset(), abstractByteBuf.arrayOffset() + n, charSequence, n3, n4);
            }
            if (abstractByteBuf.hasMemoryAddress()) {
                return ByteBufUtil.unsafeWriteUtf8(null, abstractByteBuf.memoryAddress(), n, charSequence, n3, n4);
            }
        } else {
            if (abstractByteBuf.hasArray()) {
                return ByteBufUtil.safeArrayWriteUtf8(abstractByteBuf.array(), abstractByteBuf.arrayOffset() + n, charSequence, n3, n4);
            }
            if (abstractByteBuf.isDirect()) {
                assert (abstractByteBuf.nioBufferCount() == 1);
                ByteBuffer byteBuffer = abstractByteBuf.internalNioBuffer(n, n2);
                int n5 = byteBuffer.position();
                return ByteBufUtil.safeDirectWriteUtf8(byteBuffer, n5, charSequence, n3, n4);
            }
        }
        return ByteBufUtil.safeWriteUtf8(abstractByteBuf, n, charSequence, n3, n4);
    }

    static void writeAsciiString(AbstractByteBuf abstractByteBuf, int n, AsciiString asciiString, int n2, int n3) {
        int n4 = asciiString.arrayOffset() + n2;
        int n5 = n3 - n2;
        if (PlatformDependent.hasUnsafe()) {
            if (abstractByteBuf.hasArray()) {
                PlatformDependent.copyMemory(asciiString.array(), n4, abstractByteBuf.array(), abstractByteBuf.arrayOffset() + n, n5);
                return;
            }
            if (abstractByteBuf.hasMemoryAddress()) {
                PlatformDependent.copyMemory(asciiString.array(), n4, abstractByteBuf.memoryAddress() + (long)n, (long)n5);
                return;
            }
        }
        if (abstractByteBuf.hasArray()) {
            System.arraycopy(asciiString.array(), n4, abstractByteBuf.array(), abstractByteBuf.arrayOffset() + n, n5);
            return;
        }
        abstractByteBuf.setBytes(n, asciiString.array(), n4, n5);
    }

    private static int safeDirectWriteUtf8(ByteBuffer byteBuffer, int n, CharSequence charSequence, int n2, int n3) {
        assert (!(charSequence instanceof AsciiString));
        int n4 = n;
        for (int i = n2; i < n3; ++i) {
            char c = charSequence.charAt(i);
            if (c < '\u0080') {
                byteBuffer.put(n++, (byte)c);
                continue;
            }
            if (c < '\u0800') {
                byteBuffer.put(n++, (byte)(0xC0 | c >> 6));
                byteBuffer.put(n++, (byte)(0x80 | c & 0x3F));
                continue;
            }
            if (StringUtil.isSurrogate(c)) {
                if (!Character.isHighSurrogate(c)) {
                    byteBuffer.put(n++, (byte)63);
                    continue;
                }
                if (++i == n3) {
                    byteBuffer.put(n++, (byte)63);
                    break;
                }
                char c2 = charSequence.charAt(i);
                if (!Character.isLowSurrogate(c2)) {
                    byteBuffer.put(n++, (byte)63);
                    byteBuffer.put(n++, (byte)(Character.isHighSurrogate(c2) ? 63 : (byte)c2));
                    continue;
                }
                int n5 = Character.toCodePoint(c, c2);
                byteBuffer.put(n++, (byte)(0xF0 | n5 >> 18));
                byteBuffer.put(n++, (byte)(0x80 | n5 >> 12 & 0x3F));
                byteBuffer.put(n++, (byte)(0x80 | n5 >> 6 & 0x3F));
                byteBuffer.put(n++, (byte)(0x80 | n5 & 0x3F));
                continue;
            }
            byteBuffer.put(n++, (byte)(0xE0 | c >> 12));
            byteBuffer.put(n++, (byte)(0x80 | c >> 6 & 0x3F));
            byteBuffer.put(n++, (byte)(0x80 | c & 0x3F));
        }
        return n - n4;
    }

    private static int safeWriteUtf8(AbstractByteBuf abstractByteBuf, int n, CharSequence charSequence, int n2, int n3) {
        assert (!(charSequence instanceof AsciiString));
        int n4 = n;
        for (int i = n2; i < n3; ++i) {
            char c = charSequence.charAt(i);
            if (c < '\u0080') {
                abstractByteBuf._setByte(n++, (byte)c);
                continue;
            }
            if (c < '\u0800') {
                abstractByteBuf._setByte(n++, (byte)(0xC0 | c >> 6));
                abstractByteBuf._setByte(n++, (byte)(0x80 | c & 0x3F));
                continue;
            }
            if (StringUtil.isSurrogate(c)) {
                if (!Character.isHighSurrogate(c)) {
                    abstractByteBuf._setByte(n++, 63);
                    continue;
                }
                if (++i == n3) {
                    abstractByteBuf._setByte(n++, 63);
                    break;
                }
                char c2 = charSequence.charAt(i);
                if (!Character.isLowSurrogate(c2)) {
                    abstractByteBuf._setByte(n++, 63);
                    abstractByteBuf._setByte(n++, Character.isHighSurrogate(c2) ? 63 : (int)c2);
                    continue;
                }
                int n5 = Character.toCodePoint(c, c2);
                abstractByteBuf._setByte(n++, (byte)(0xF0 | n5 >> 18));
                abstractByteBuf._setByte(n++, (byte)(0x80 | n5 >> 12 & 0x3F));
                abstractByteBuf._setByte(n++, (byte)(0x80 | n5 >> 6 & 0x3F));
                abstractByteBuf._setByte(n++, (byte)(0x80 | n5 & 0x3F));
                continue;
            }
            abstractByteBuf._setByte(n++, (byte)(0xE0 | c >> 12));
            abstractByteBuf._setByte(n++, (byte)(0x80 | c >> 6 & 0x3F));
            abstractByteBuf._setByte(n++, (byte)(0x80 | c & 0x3F));
        }
        return n - n4;
    }

    private static int safeArrayWriteUtf8(byte[] byArray, int n, CharSequence charSequence, int n2, int n3) {
        int n4 = n;
        for (int i = n2; i < n3; ++i) {
            char c = charSequence.charAt(i);
            if (c < '\u0080') {
                byArray[n++] = (byte)c;
                continue;
            }
            if (c < '\u0800') {
                byArray[n++] = (byte)(0xC0 | c >> 6);
                byArray[n++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (StringUtil.isSurrogate(c)) {
                if (!Character.isHighSurrogate(c)) {
                    byArray[n++] = 63;
                    continue;
                }
                if (++i == n3) {
                    byArray[n++] = 63;
                    break;
                }
                char c2 = charSequence.charAt(i);
                if (!Character.isLowSurrogate(c2)) {
                    byArray[n++] = 63;
                    byArray[n++] = (byte)(Character.isHighSurrogate(c2) ? 63 : (int)c2);
                    continue;
                }
                int n5 = Character.toCodePoint(c, c2);
                byArray[n++] = (byte)(0xF0 | n5 >> 18);
                byArray[n++] = (byte)(0x80 | n5 >> 12 & 0x3F);
                byArray[n++] = (byte)(0x80 | n5 >> 6 & 0x3F);
                byArray[n++] = (byte)(0x80 | n5 & 0x3F);
                continue;
            }
            byArray[n++] = (byte)(0xE0 | c >> 12);
            byArray[n++] = (byte)(0x80 | c >> 6 & 0x3F);
            byArray[n++] = (byte)(0x80 | c & 0x3F);
        }
        return n - n4;
    }

    private static int unsafeWriteUtf8(byte[] byArray, long l, int n, CharSequence charSequence, int n2, int n3) {
        long l2;
        assert (!(charSequence instanceof AsciiString));
        long l3 = l2 = l + (long)n;
        for (int i = n2; i < n3; ++i) {
            char c = charSequence.charAt(i);
            if (c < '\u0080') {
                PlatformDependent.putByte((Object)byArray, l2++, (byte)c);
                continue;
            }
            if (c < '\u0800') {
                PlatformDependent.putByte((Object)byArray, l2++, (byte)(0xC0 | c >> 6));
                PlatformDependent.putByte((Object)byArray, l2++, (byte)(0x80 | c & 0x3F));
                continue;
            }
            if (StringUtil.isSurrogate(c)) {
                if (!Character.isHighSurrogate(c)) {
                    PlatformDependent.putByte((Object)byArray, l2++, (byte)63);
                    continue;
                }
                if (++i == n3) {
                    PlatformDependent.putByte((Object)byArray, l2++, (byte)63);
                    break;
                }
                char c2 = charSequence.charAt(i);
                if (!Character.isLowSurrogate(c2)) {
                    PlatformDependent.putByte((Object)byArray, l2++, (byte)63);
                    PlatformDependent.putByte((Object)byArray, l2++, (byte)(Character.isHighSurrogate(c2) ? 63 : (int)c2));
                    continue;
                }
                int n4 = Character.toCodePoint(c, c2);
                PlatformDependent.putByte((Object)byArray, l2++, (byte)(0xF0 | n4 >> 18));
                PlatformDependent.putByte((Object)byArray, l2++, (byte)(0x80 | n4 >> 12 & 0x3F));
                PlatformDependent.putByte((Object)byArray, l2++, (byte)(0x80 | n4 >> 6 & 0x3F));
                PlatformDependent.putByte((Object)byArray, l2++, (byte)(0x80 | n4 & 0x3F));
                continue;
            }
            PlatformDependent.putByte((Object)byArray, l2++, (byte)(0xE0 | c >> 12));
            PlatformDependent.putByte((Object)byArray, l2++, (byte)(0x80 | c >> 6 & 0x3F));
            PlatformDependent.putByte((Object)byArray, l2++, (byte)(0x80 | c & 0x3F));
        }
        return (int)(l2 - l3);
    }

    public static int utf8MaxBytes(int n) {
        return n * MAX_BYTES_PER_CHAR_UTF8;
    }

    public static int utf8MaxBytes(CharSequence charSequence) {
        if (charSequence instanceof AsciiString) {
            return charSequence.length();
        }
        return ByteBufUtil.utf8MaxBytes(charSequence.length());
    }

    public static int utf8Bytes(CharSequence charSequence) {
        return ByteBufUtil.utf8ByteCount(charSequence, 0, charSequence.length());
    }

    public static int utf8Bytes(CharSequence charSequence, int n, int n2) {
        return ByteBufUtil.utf8ByteCount(ByteBufUtil.checkCharSequenceBounds(charSequence, n, n2), n, n2);
    }

    private static int utf8ByteCount(CharSequence charSequence, int n, int n2) {
        int n3;
        if (charSequence instanceof AsciiString) {
            return n2 - n;
        }
        for (n3 = n; n3 < n2 && charSequence.charAt(n3) < '\u0080'; ++n3) {
        }
        return n3 < n2 ? n3 - n + ByteBufUtil.utf8BytesNonAscii(charSequence, n3, n2) : n3 - n;
    }

    private static int utf8BytesNonAscii(CharSequence charSequence, int n, int n2) {
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            char c = charSequence.charAt(i);
            if (c < '\u0800') {
                n3 += (127 - c >>> 31) + 1;
                continue;
            }
            if (StringUtil.isSurrogate(c)) {
                if (!Character.isHighSurrogate(c)) {
                    ++n3;
                    continue;
                }
                if (++i == n2) {
                    ++n3;
                    break;
                }
                if (!Character.isLowSurrogate(charSequence.charAt(i))) {
                    n3 += 2;
                    continue;
                }
                n3 += 4;
                continue;
            }
            n3 += 3;
        }
        return n3;
    }

    public static ByteBuf writeAscii(ByteBufAllocator byteBufAllocator, CharSequence charSequence) {
        ByteBuf byteBuf = byteBufAllocator.buffer(charSequence.length());
        ByteBufUtil.writeAscii(byteBuf, charSequence);
        return byteBuf;
    }

    public static int writeAscii(ByteBuf byteBuf, CharSequence charSequence) {
        while (true) {
            if (byteBuf instanceof WrappedCompositeByteBuf) {
                byteBuf = byteBuf.unwrap();
                continue;
            }
            if (byteBuf instanceof AbstractByteBuf) {
                int n = charSequence.length();
                AbstractByteBuf abstractByteBuf = (AbstractByteBuf)byteBuf;
                abstractByteBuf.ensureWritable0(n);
                if (charSequence instanceof AsciiString) {
                    ByteBufUtil.writeAsciiString(abstractByteBuf, abstractByteBuf.writerIndex, (AsciiString)charSequence, 0, n);
                } else {
                    int n2 = ByteBufUtil.writeAscii(abstractByteBuf, abstractByteBuf.writerIndex, charSequence, n);
                    assert (n2 == n);
                }
                abstractByteBuf.writerIndex += n;
                return n;
            }
            if (!(byteBuf instanceof WrappedByteBuf)) break;
            byteBuf = byteBuf.unwrap();
        }
        byte[] byArray = charSequence.toString().getBytes(CharsetUtil.US_ASCII);
        byteBuf.writeBytes(byArray);
        return byArray.length;
    }

    static int writeAscii(AbstractByteBuf abstractByteBuf, int n, CharSequence charSequence, int n2) {
        if (charSequence instanceof AsciiString) {
            ByteBufUtil.writeAsciiString(abstractByteBuf, n, (AsciiString)charSequence, 0, n2);
        } else {
            ByteBufUtil.writeAsciiCharSequence(abstractByteBuf, n, charSequence, n2);
        }
        return n2;
    }

    private static int writeAsciiCharSequence(AbstractByteBuf abstractByteBuf, int n, CharSequence charSequence, int n2) {
        for (int i = 0; i < n2; ++i) {
            abstractByteBuf._setByte(n++, AsciiString.c2b(charSequence.charAt(i)));
        }
        return n2;
    }

    public static ByteBuf encodeString(ByteBufAllocator byteBufAllocator, CharBuffer charBuffer, Charset charset) {
        return ByteBufUtil.encodeString0(byteBufAllocator, false, charBuffer, charset, 0);
    }

    public static ByteBuf encodeString(ByteBufAllocator byteBufAllocator, CharBuffer charBuffer, Charset charset, int n) {
        return ByteBufUtil.encodeString0(byteBufAllocator, false, charBuffer, charset, n);
    }

    static ByteBuf encodeString0(ByteBufAllocator byteBufAllocator, boolean bl, CharBuffer charBuffer, Charset charset, int n) {
        CharsetEncoder charsetEncoder = CharsetUtil.encoder(charset);
        int n2 = (int)((double)charBuffer.remaining() * (double)charsetEncoder.maxBytesPerChar()) + n;
        boolean bl2 = true;
        ByteBuf byteBuf = bl ? byteBufAllocator.heapBuffer(n2) : byteBufAllocator.buffer(n2);
        try {
            ByteBuffer byteBuffer = byteBuf.internalNioBuffer(byteBuf.readerIndex(), n2);
            int n3 = byteBuffer.position();
            CoderResult coderResult = charsetEncoder.encode(charBuffer, byteBuffer, true);
            if (!coderResult.isUnderflow()) {
                coderResult.throwException();
            }
            if (!(coderResult = charsetEncoder.flush(byteBuffer)).isUnderflow()) {
                coderResult.throwException();
            }
            byteBuf.writerIndex(byteBuf.writerIndex() + byteBuffer.position() - n3);
            bl2 = false;
            ByteBuf byteBuf2 = byteBuf;
            return byteBuf2;
        }
        catch (CharacterCodingException characterCodingException) {
            throw new IllegalStateException(characterCodingException);
        }
        finally {
            if (bl2) {
                byteBuf.release();
            }
        }
    }

    static String decodeString(ByteBuf byteBuf, int n, int n2, Charset charset) {
        int n3;
        byte[] byArray;
        if (n2 == 0) {
            return "";
        }
        if (byteBuf.hasArray()) {
            byArray = byteBuf.array();
            n3 = byteBuf.arrayOffset() + n;
        } else {
            byArray = ByteBufUtil.threadLocalTempArray(n2);
            n3 = 0;
            byteBuf.getBytes(n, byArray, 0, n2);
        }
        if (CharsetUtil.US_ASCII.equals(charset)) {
            return new String(byArray, 0, n3, n2);
        }
        return new String(byArray, n3, n2, charset);
    }

    public static ByteBuf threadLocalDirectBuffer() {
        if (THREAD_LOCAL_BUFFER_SIZE <= 0) {
            return null;
        }
        if (PlatformDependent.hasUnsafe()) {
            return ByteBufUtil$ThreadLocalUnsafeDirectByteBuf.newInstance();
        }
        return ByteBufUtil$ThreadLocalDirectByteBuf.newInstance();
    }

    public static byte[] getBytes(ByteBuf byteBuf) {
        return ByteBufUtil.getBytes(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes());
    }

    public static byte[] getBytes(ByteBuf byteBuf, int n, int n2) {
        return ByteBufUtil.getBytes(byteBuf, n, n2, true);
    }

    public static byte[] getBytes(ByteBuf byteBuf, int n, int n2, boolean bl) {
        int n3 = byteBuf.capacity();
        if (MathUtil.isOutOfBounds(n, n2, n3)) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + n + ") <= start + length(" + n2 + ") <= buf.capacity(" + n3 + ')');
        }
        if (byteBuf.hasArray()) {
            int n4 = byteBuf.arrayOffset() + n;
            byte[] byArray = byteBuf.array();
            if (bl || n4 != 0 || n2 != byArray.length) {
                return Arrays.copyOfRange(byArray, n4, n4 + n2);
            }
            return byArray;
        }
        byte[] byArray = PlatformDependent.allocateUninitializedArray(n2);
        byteBuf.getBytes(n, byArray);
        return byArray;
    }

    public static void copy(AsciiString asciiString, ByteBuf byteBuf) {
        ByteBufUtil.copy(asciiString, 0, byteBuf, asciiString.length());
    }

    public static void copy(AsciiString asciiString, int n, ByteBuf byteBuf, int n2, int n3) {
        if (MathUtil.isOutOfBounds(n, n3, asciiString.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= srcIdx(" + n + ") <= srcIdx + length(" + n3 + ") <= srcLen(" + asciiString.length() + ')');
        }
        ObjectUtil.checkNotNull(byteBuf, "dst").setBytes(n2, asciiString.array(), n + asciiString.arrayOffset(), n3);
    }

    public static void copy(AsciiString asciiString, int n, ByteBuf byteBuf, int n2) {
        if (MathUtil.isOutOfBounds(n, n2, asciiString.length())) {
            throw new IndexOutOfBoundsException("expected: 0 <= srcIdx(" + n + ") <= srcIdx + length(" + n2 + ") <= srcLen(" + asciiString.length() + ')');
        }
        ObjectUtil.checkNotNull(byteBuf, "dst").writeBytes(asciiString.array(), n + asciiString.arrayOffset(), n2);
    }

    public static String prettyHexDump(ByteBuf byteBuf) {
        return ByteBufUtil.prettyHexDump(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes());
    }

    public static String prettyHexDump(ByteBuf byteBuf, int n, int n2) {
        return ByteBufUtil$HexUtil.access$200(byteBuf, n, n2);
    }

    public static void appendPrettyHexDump(StringBuilder stringBuilder, ByteBuf byteBuf) {
        ByteBufUtil.appendPrettyHexDump(stringBuilder, byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes());
    }

    public static void appendPrettyHexDump(StringBuilder stringBuilder, ByteBuf byteBuf, int n, int n2) {
        ByteBufUtil$HexUtil.access$300(stringBuilder, byteBuf, n, n2);
    }

    public static boolean isText(ByteBuf byteBuf, Charset charset) {
        return ByteBufUtil.isText(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes(), charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isText(ByteBuf byteBuf, int n, int n2, Charset charset) {
        ObjectUtil.checkNotNull(byteBuf, "buf");
        ObjectUtil.checkNotNull(charset, "charset");
        int n3 = byteBuf.readerIndex() + byteBuf.readableBytes();
        if (n < 0 || n2 < 0 || n > n3 - n2) {
            throw new IndexOutOfBoundsException("index: " + n + " length: " + n2);
        }
        if (charset.equals(CharsetUtil.UTF_8)) {
            return ByteBufUtil.isUtf8(byteBuf, n, n2);
        }
        if (charset.equals(CharsetUtil.US_ASCII)) {
            return ByteBufUtil.isAscii(byteBuf, n, n2);
        }
        CharsetDecoder charsetDecoder = CharsetUtil.decoder(charset, CodingErrorAction.REPORT, CodingErrorAction.REPORT);
        try {
            if (byteBuf.nioBufferCount() == 1) {
                charsetDecoder.decode(byteBuf.nioBuffer(n, n2));
            } else {
                ByteBuf byteBuf2 = byteBuf.alloc().heapBuffer(n2);
                try {
                    byteBuf2.writeBytes(byteBuf, n, n2);
                    charsetDecoder.decode(byteBuf2.internalNioBuffer(byteBuf2.readerIndex(), n2));
                }
                finally {
                    byteBuf2.release();
                }
            }
            return true;
        }
        catch (CharacterCodingException characterCodingException) {
            return false;
        }
    }

    private static boolean isAscii(ByteBuf byteBuf, int n, int n2) {
        return byteBuf.forEachByte(n, n2, FIND_NON_ASCII) == -1;
    }

    private static boolean isUtf8(ByteBuf byteBuf, int n, int n2) {
        int n3 = n + n2;
        while (n < n3) {
            byte by;
            byte by2;
            byte by3;
            if (((by3 = byteBuf.getByte(n++)) & 0x80) == 0) continue;
            if ((by3 & 0xE0) == 192) {
                if (n >= n3) {
                    return false;
                }
                if (((by2 = byteBuf.getByte(n++)) & 0xC0) != 128) {
                    return false;
                }
                if ((by3 & 0xFF) >= 194) continue;
                return false;
            }
            if ((by3 & 0xF0) == 224) {
                if (n > n3 - 2) {
                    return false;
                }
                by2 = byteBuf.getByte(n++);
                by = byteBuf.getByte(n++);
                if ((by2 & 0xC0) != 128 || (by & 0xC0) != 128) {
                    return false;
                }
                if ((by3 & 0xF) == 0 && (by2 & 0xFF) < 160) {
                    return false;
                }
                if ((by3 & 0xF) != 13 || (by2 & 0xFF) <= 159) continue;
                return false;
            }
            if ((by3 & 0xF8) == 240) {
                if (n > n3 - 3) {
                    return false;
                }
                by2 = byteBuf.getByte(n++);
                by = byteBuf.getByte(n++);
                byte by4 = byteBuf.getByte(n++);
                if ((by2 & 0xC0) != 128 || (by & 0xC0) != 128 || (by4 & 0xC0) != 128) {
                    return false;
                }
                if ((by3 & 0xFF) <= 244 && ((by3 & 0xFF) != 240 || (by2 & 0xFF) >= 144) && ((by3 & 0xFF) != 244 || (by2 & 0xFF) <= 143)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void readBytes(ByteBufAllocator byteBufAllocator, ByteBuffer byteBuffer, int n, int n2, OutputStream outputStream) {
        if (byteBuffer.hasArray()) {
            outputStream.write(byteBuffer.array(), n + byteBuffer.arrayOffset(), n2);
        } else {
            int n3 = Math.min(n2, 8192);
            byteBuffer.clear().position(n);
            if (n2 <= 1024 || !byteBufAllocator.isDirectBufferPooled()) {
                ByteBufUtil.getBytes(byteBuffer, ByteBufUtil.threadLocalTempArray(n3), 0, n3, outputStream, n2);
            } else {
                ByteBuf byteBuf = byteBufAllocator.heapBuffer(n3);
                try {
                    byte[] byArray = byteBuf.array();
                    int n4 = byteBuf.arrayOffset();
                    ByteBufUtil.getBytes(byteBuffer, byArray, n4, n3, outputStream, n2);
                }
                finally {
                    byteBuf.release();
                }
            }
        }
    }

    private static void getBytes(ByteBuffer byteBuffer, byte[] byArray, int n, int n2, OutputStream outputStream, int n3) {
        int n4;
        do {
            n4 = Math.min(n2, n3);
            byteBuffer.get(byArray, n, n4);
            outputStream.write(byArray, n, n4);
        } while ((n3 -= n4) > 0);
    }

    public static void setLeakListener(ResourceLeakDetector.LeakListener leakListener) {
        AbstractByteBuf.leakDetector.setLeakListener(leakListener);
    }

    private ByteBufUtil() {
    }

    static /* synthetic */ int access$500() {
        return THREAD_LOCAL_BUFFER_SIZE;
    }

    static {
        AbstractByteBufAllocator abstractByteBufAllocator;
        logger = InternalLoggerFactory.getInstance(ByteBufUtil.class);
        BYTE_ARRAYS = new ByteBufUtil$1();
        MAX_BYTES_PER_CHAR_UTF8 = (int)CharsetUtil.encoder(CharsetUtil.UTF_8).maxBytesPerChar();
        String string = SystemPropertyUtil.get("pro.gravit.repackage.io.netty.allocator.type", PlatformDependent.isAndroid() ? "unpooled" : "pooled");
        if ("unpooled".equals(string)) {
            abstractByteBufAllocator = UnpooledByteBufAllocator.DEFAULT;
            logger.debug("-Dio.netty.allocator.type: {}", (Object)string);
        } else if ("pooled".equals(string)) {
            abstractByteBufAllocator = PooledByteBufAllocator.DEFAULT;
            logger.debug("-Dio.netty.allocator.type: {}", (Object)string);
        } else if ("adaptive".equals(string)) {
            abstractByteBufAllocator = new AdaptiveByteBufAllocator();
            logger.debug("-Dio.netty.allocator.type: {}", (Object)string);
        } else {
            abstractByteBufAllocator = PooledByteBufAllocator.DEFAULT;
            logger.debug("-Dio.netty.allocator.type: pooled (unknown: {})", (Object)string);
        }
        DEFAULT_ALLOCATOR = abstractByteBufAllocator;
        THREAD_LOCAL_BUFFER_SIZE = SystemPropertyUtil.getInt("pro.gravit.repackage.io.netty.threadLocalDirectBufferSize", 0);
        logger.debug("-Dio.netty.threadLocalDirectBufferSize: {}", (Object)THREAD_LOCAL_BUFFER_SIZE);
        MAX_CHAR_BUFFER_SIZE = SystemPropertyUtil.getInt("pro.gravit.repackage.io.netty.maxThreadLocalCharBufferSize", 16384);
        logger.debug("-Dio.netty.maxThreadLocalCharBufferSize: {}", (Object)MAX_CHAR_BUFFER_SIZE);
        FIND_NON_ASCII = new ByteBufUtil$2();
    }
}

