/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.channel;

import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import pro.gravit.repackage.io.netty.buffer.ByteBufAllocator;
import pro.gravit.repackage.io.netty.channel.AbstractChannel;
import pro.gravit.repackage.io.netty.channel.AbstractChannelHandlerContext$1;
import pro.gravit.repackage.io.netty.channel.AbstractChannelHandlerContext$10;
import pro.gravit.repackage.io.netty.channel.AbstractChannelHandlerContext$11;
import pro.gravit.repackage.io.netty.channel.AbstractChannelHandlerContext$12;
import pro.gravit.repackage.io.netty.channel.AbstractChannelHandlerContext$2;
import pro.gravit.repackage.io.netty.channel.AbstractChannelHandlerContext$3;
import pro.gravit.repackage.io.netty.channel.AbstractChannelHandlerContext$4;
import pro.gravit.repackage.io.netty.channel.AbstractChannelHandlerContext$5;
import pro.gravit.repackage.io.netty.channel.AbstractChannelHandlerContext$6;
import pro.gravit.repackage.io.netty.channel.AbstractChannelHandlerContext$7;
import pro.gravit.repackage.io.netty.channel.AbstractChannelHandlerContext$8;
import pro.gravit.repackage.io.netty.channel.AbstractChannelHandlerContext$9;
import pro.gravit.repackage.io.netty.channel.AbstractChannelHandlerContext$Tasks;
import pro.gravit.repackage.io.netty.channel.AbstractChannelHandlerContext$WriteTask;
import pro.gravit.repackage.io.netty.channel.Channel;
import pro.gravit.repackage.io.netty.channel.ChannelDuplexHandler;
import pro.gravit.repackage.io.netty.channel.ChannelFuture;
import pro.gravit.repackage.io.netty.channel.ChannelHandler;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerMask;
import pro.gravit.repackage.io.netty.channel.ChannelInboundHandler;
import pro.gravit.repackage.io.netty.channel.ChannelInboundHandlerAdapter;
import pro.gravit.repackage.io.netty.channel.ChannelOutboundHandler;
import pro.gravit.repackage.io.netty.channel.ChannelOutboundHandlerAdapter;
import pro.gravit.repackage.io.netty.channel.ChannelPipeline;
import pro.gravit.repackage.io.netty.channel.ChannelProgressivePromise;
import pro.gravit.repackage.io.netty.channel.ChannelPromise;
import pro.gravit.repackage.io.netty.channel.DefaultChannelPipeline;
import pro.gravit.repackage.io.netty.channel.DefaultChannelPipeline$HeadContext;
import pro.gravit.repackage.io.netty.channel.DefaultChannelProgressivePromise;
import pro.gravit.repackage.io.netty.channel.DefaultChannelPromise;
import pro.gravit.repackage.io.netty.channel.FailedChannelFuture;
import pro.gravit.repackage.io.netty.channel.SucceededChannelFuture;
import pro.gravit.repackage.io.netty.channel.VoidChannelPromise;
import pro.gravit.repackage.io.netty.util.Attribute;
import pro.gravit.repackage.io.netty.util.AttributeKey;
import pro.gravit.repackage.io.netty.util.ReferenceCountUtil;
import pro.gravit.repackage.io.netty.util.ResourceLeakHint;
import pro.gravit.repackage.io.netty.util.concurrent.AbstractEventExecutor;
import pro.gravit.repackage.io.netty.util.concurrent.EventExecutor;
import pro.gravit.repackage.io.netty.util.concurrent.OrderedEventExecutor;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;
import pro.gravit.repackage.io.netty.util.internal.PromiseNotificationUtil;
import pro.gravit.repackage.io.netty.util.internal.StringUtil;
import pro.gravit.repackage.io.netty.util.internal.ThrowableUtil;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;

abstract class AbstractChannelHandlerContext
implements ChannelHandlerContext,
ResourceLeakHint {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractChannelHandlerContext.class);
    volatile AbstractChannelHandlerContext next;
    volatile AbstractChannelHandlerContext prev;
    private static final AtomicIntegerFieldUpdater<AbstractChannelHandlerContext> HANDLER_STATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(AbstractChannelHandlerContext.class, "handlerState");
    private static final int ADD_PENDING = 1;
    private static final int ADD_COMPLETE = 2;
    private static final int REMOVE_COMPLETE = 3;
    private static final int INIT = 0;
    private final DefaultChannelPipeline pipeline;
    private final String name;
    private final boolean ordered;
    private final int executionMask;
    final EventExecutor executor;
    private ChannelFuture succeededFuture;
    private AbstractChannelHandlerContext$Tasks invokeTasks;
    private volatile int handlerState = 0;

    AbstractChannelHandlerContext(DefaultChannelPipeline defaultChannelPipeline, EventExecutor eventExecutor, String string, Class<? extends ChannelHandler> clazz) {
        this.name = ObjectUtil.checkNotNull(string, "name");
        this.pipeline = defaultChannelPipeline;
        this.executor = eventExecutor;
        this.executionMask = ChannelHandlerMask.mask(clazz);
        this.ordered = eventExecutor == null || eventExecutor instanceof OrderedEventExecutor;
    }

    @Override
    public Channel channel() {
        return this.pipeline.channel();
    }

    @Override
    public ChannelPipeline pipeline() {
        return this.pipeline;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.channel().config().getAllocator();
    }

    @Override
    public EventExecutor executor() {
        if (this.executor == null) {
            return this.channel().eventLoop();
        }
        return this.executor;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public ChannelHandlerContext fireChannelRegistered() {
        AbstractChannelHandlerContext.invokeChannelRegistered(this.findContextInbound(2));
        return this;
    }

    static void invokeChannelRegistered(AbstractChannelHandlerContext abstractChannelHandlerContext) {
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeChannelRegistered();
        } else {
            eventExecutor.execute(new AbstractChannelHandlerContext$1(abstractChannelHandlerContext));
        }
    }

    private void invokeChannelRegistered() {
        block6: {
            if (this.invokeHandler()) {
                try {
                    ChannelHandler channelHandler = this.handler();
                    DefaultChannelPipeline$HeadContext defaultChannelPipeline$HeadContext = this.pipeline.head;
                    if (channelHandler == defaultChannelPipeline$HeadContext) {
                        defaultChannelPipeline$HeadContext.channelRegistered(this);
                        break block6;
                    }
                    if (channelHandler instanceof ChannelInboundHandlerAdapter) {
                        ((ChannelInboundHandlerAdapter)channelHandler).channelRegistered(this);
                        break block6;
                    }
                    ((ChannelInboundHandler)channelHandler).channelRegistered(this);
                }
                catch (Throwable throwable) {
                    this.invokeExceptionCaught(throwable);
                }
            } else {
                this.fireChannelRegistered();
            }
        }
    }

    @Override
    public ChannelHandlerContext fireChannelUnregistered() {
        AbstractChannelHandlerContext.invokeChannelUnregistered(this.findContextInbound(4));
        return this;
    }

    static void invokeChannelUnregistered(AbstractChannelHandlerContext abstractChannelHandlerContext) {
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeChannelUnregistered();
        } else {
            eventExecutor.execute(new AbstractChannelHandlerContext$2(abstractChannelHandlerContext));
        }
    }

    private void invokeChannelUnregistered() {
        block6: {
            if (this.invokeHandler()) {
                try {
                    ChannelHandler channelHandler = this.handler();
                    DefaultChannelPipeline$HeadContext defaultChannelPipeline$HeadContext = this.pipeline.head;
                    if (channelHandler == defaultChannelPipeline$HeadContext) {
                        defaultChannelPipeline$HeadContext.channelUnregistered(this);
                        break block6;
                    }
                    if (channelHandler instanceof ChannelInboundHandlerAdapter) {
                        ((ChannelInboundHandlerAdapter)channelHandler).channelUnregistered(this);
                        break block6;
                    }
                    ((ChannelInboundHandler)channelHandler).channelUnregistered(this);
                }
                catch (Throwable throwable) {
                    this.invokeExceptionCaught(throwable);
                }
            } else {
                this.fireChannelUnregistered();
            }
        }
    }

    @Override
    public ChannelHandlerContext fireChannelActive() {
        AbstractChannelHandlerContext.invokeChannelActive(this.findContextInbound(8));
        return this;
    }

    static void invokeChannelActive(AbstractChannelHandlerContext abstractChannelHandlerContext) {
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeChannelActive();
        } else {
            eventExecutor.execute(new AbstractChannelHandlerContext$3(abstractChannelHandlerContext));
        }
    }

    private void invokeChannelActive() {
        block6: {
            if (this.invokeHandler()) {
                try {
                    ChannelHandler channelHandler = this.handler();
                    DefaultChannelPipeline$HeadContext defaultChannelPipeline$HeadContext = this.pipeline.head;
                    if (channelHandler == defaultChannelPipeline$HeadContext) {
                        defaultChannelPipeline$HeadContext.channelActive(this);
                        break block6;
                    }
                    if (channelHandler instanceof ChannelInboundHandlerAdapter) {
                        ((ChannelInboundHandlerAdapter)channelHandler).channelActive(this);
                        break block6;
                    }
                    ((ChannelInboundHandler)channelHandler).channelActive(this);
                }
                catch (Throwable throwable) {
                    this.invokeExceptionCaught(throwable);
                }
            } else {
                this.fireChannelActive();
            }
        }
    }

    @Override
    public ChannelHandlerContext fireChannelInactive() {
        AbstractChannelHandlerContext.invokeChannelInactive(this.findContextInbound(16));
        return this;
    }

    static void invokeChannelInactive(AbstractChannelHandlerContext abstractChannelHandlerContext) {
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeChannelInactive();
        } else {
            eventExecutor.execute(new AbstractChannelHandlerContext$4(abstractChannelHandlerContext));
        }
    }

    private void invokeChannelInactive() {
        block6: {
            if (this.invokeHandler()) {
                try {
                    ChannelHandler channelHandler = this.handler();
                    DefaultChannelPipeline$HeadContext defaultChannelPipeline$HeadContext = this.pipeline.head;
                    if (channelHandler == defaultChannelPipeline$HeadContext) {
                        defaultChannelPipeline$HeadContext.channelInactive(this);
                        break block6;
                    }
                    if (channelHandler instanceof ChannelInboundHandlerAdapter) {
                        ((ChannelInboundHandlerAdapter)channelHandler).channelInactive(this);
                        break block6;
                    }
                    ((ChannelInboundHandler)channelHandler).channelInactive(this);
                }
                catch (Throwable throwable) {
                    this.invokeExceptionCaught(throwable);
                }
            } else {
                this.fireChannelInactive();
            }
        }
    }

    @Override
    public ChannelHandlerContext fireExceptionCaught(Throwable throwable) {
        AbstractChannelHandlerContext.invokeExceptionCaught(this.findContextInbound(1), throwable);
        return this;
    }

    static void invokeExceptionCaught(AbstractChannelHandlerContext abstractChannelHandlerContext, Throwable throwable) {
        block4: {
            ObjectUtil.checkNotNull(throwable, "cause");
            EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
            if (eventExecutor.inEventLoop()) {
                abstractChannelHandlerContext.invokeExceptionCaught(throwable);
            } else {
                try {
                    eventExecutor.execute(new AbstractChannelHandlerContext$5(abstractChannelHandlerContext, throwable));
                }
                catch (Throwable throwable2) {
                    if (!logger.isWarnEnabled()) break block4;
                    logger.warn("Failed to submit an exceptionCaught() event.", throwable2);
                    logger.warn("The exceptionCaught() event that was failed to submit was:", throwable);
                }
            }
        }
    }

    private void invokeExceptionCaught(Throwable throwable) {
        if (this.invokeHandler()) {
            try {
                this.handler().exceptionCaught(this, throwable);
            }
            catch (Throwable throwable2) {
                if (logger.isDebugEnabled()) {
                    logger.debug("An exception {}was thrown by a user handler's exceptionCaught() method while handling the following exception:", (Object)ThrowableUtil.stackTraceToString(throwable2), (Object)throwable);
                } else if (logger.isWarnEnabled()) {
                    logger.warn("An exception '{}' [enable DEBUG level for full stacktrace] was thrown by a user handler's exceptionCaught() method while handling the following exception:", (Object)throwable2, (Object)throwable);
                }
            }
        } else {
            this.fireExceptionCaught(throwable);
        }
    }

    @Override
    public ChannelHandlerContext fireUserEventTriggered(Object object) {
        AbstractChannelHandlerContext.invokeUserEventTriggered(this.findContextInbound(128), object);
        return this;
    }

    static void invokeUserEventTriggered(AbstractChannelHandlerContext abstractChannelHandlerContext, Object object) {
        ObjectUtil.checkNotNull(object, "event");
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeUserEventTriggered(object);
        } else {
            eventExecutor.execute(new AbstractChannelHandlerContext$6(abstractChannelHandlerContext, object));
        }
    }

    private void invokeUserEventTriggered(Object object) {
        block6: {
            if (this.invokeHandler()) {
                try {
                    ChannelHandler channelHandler = this.handler();
                    DefaultChannelPipeline$HeadContext defaultChannelPipeline$HeadContext = this.pipeline.head;
                    if (channelHandler == defaultChannelPipeline$HeadContext) {
                        defaultChannelPipeline$HeadContext.userEventTriggered(this, object);
                        break block6;
                    }
                    if (channelHandler instanceof ChannelInboundHandlerAdapter) {
                        ((ChannelInboundHandlerAdapter)channelHandler).userEventTriggered(this, object);
                        break block6;
                    }
                    ((ChannelInboundHandler)channelHandler).userEventTriggered(this, object);
                }
                catch (Throwable throwable) {
                    this.invokeExceptionCaught(throwable);
                }
            } else {
                this.fireUserEventTriggered(object);
            }
        }
    }

    @Override
    public ChannelHandlerContext fireChannelRead(Object object) {
        AbstractChannelHandlerContext.invokeChannelRead(this.findContextInbound(32), object);
        return this;
    }

    static void invokeChannelRead(AbstractChannelHandlerContext abstractChannelHandlerContext, Object object) {
        Object object2 = abstractChannelHandlerContext.pipeline.touch(ObjectUtil.checkNotNull(object, "msg"), abstractChannelHandlerContext);
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeChannelRead(object2);
        } else {
            eventExecutor.execute(new AbstractChannelHandlerContext$7(abstractChannelHandlerContext, object2));
        }
    }

    private void invokeChannelRead(Object object) {
        block6: {
            if (this.invokeHandler()) {
                try {
                    ChannelHandler channelHandler = this.handler();
                    DefaultChannelPipeline$HeadContext defaultChannelPipeline$HeadContext = this.pipeline.head;
                    if (channelHandler == defaultChannelPipeline$HeadContext) {
                        defaultChannelPipeline$HeadContext.channelRead(this, object);
                        break block6;
                    }
                    if (channelHandler instanceof ChannelDuplexHandler) {
                        ((ChannelDuplexHandler)channelHandler).channelRead(this, object);
                        break block6;
                    }
                    ((ChannelInboundHandler)channelHandler).channelRead(this, object);
                }
                catch (Throwable throwable) {
                    this.invokeExceptionCaught(throwable);
                }
            } else {
                this.fireChannelRead(object);
            }
        }
    }

    @Override
    public ChannelHandlerContext fireChannelReadComplete() {
        AbstractChannelHandlerContext.invokeChannelReadComplete(this.findContextInbound(64));
        return this;
    }

    static void invokeChannelReadComplete(AbstractChannelHandlerContext abstractChannelHandlerContext) {
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeChannelReadComplete();
        } else {
            AbstractChannelHandlerContext$Tasks abstractChannelHandlerContext$Tasks = abstractChannelHandlerContext.invokeTasks;
            if (abstractChannelHandlerContext$Tasks == null) {
                abstractChannelHandlerContext.invokeTasks = abstractChannelHandlerContext$Tasks = new AbstractChannelHandlerContext$Tasks(abstractChannelHandlerContext);
            }
            eventExecutor.execute(AbstractChannelHandlerContext$Tasks.access$700(abstractChannelHandlerContext$Tasks));
        }
    }

    private void invokeChannelReadComplete() {
        block6: {
            if (this.invokeHandler()) {
                try {
                    ChannelHandler channelHandler = this.handler();
                    DefaultChannelPipeline$HeadContext defaultChannelPipeline$HeadContext = this.pipeline.head;
                    if (channelHandler == defaultChannelPipeline$HeadContext) {
                        defaultChannelPipeline$HeadContext.channelReadComplete(this);
                        break block6;
                    }
                    if (channelHandler instanceof ChannelDuplexHandler) {
                        ((ChannelDuplexHandler)channelHandler).channelReadComplete(this);
                        break block6;
                    }
                    ((ChannelInboundHandler)channelHandler).channelReadComplete(this);
                }
                catch (Throwable throwable) {
                    this.invokeExceptionCaught(throwable);
                }
            } else {
                this.fireChannelReadComplete();
            }
        }
    }

    @Override
    public ChannelHandlerContext fireChannelWritabilityChanged() {
        AbstractChannelHandlerContext.invokeChannelWritabilityChanged(this.findContextInbound(256));
        return this;
    }

    static void invokeChannelWritabilityChanged(AbstractChannelHandlerContext abstractChannelHandlerContext) {
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeChannelWritabilityChanged();
        } else {
            AbstractChannelHandlerContext$Tasks abstractChannelHandlerContext$Tasks = abstractChannelHandlerContext.invokeTasks;
            if (abstractChannelHandlerContext$Tasks == null) {
                abstractChannelHandlerContext.invokeTasks = abstractChannelHandlerContext$Tasks = new AbstractChannelHandlerContext$Tasks(abstractChannelHandlerContext);
            }
            eventExecutor.execute(AbstractChannelHandlerContext$Tasks.access$800(abstractChannelHandlerContext$Tasks));
        }
    }

    private void invokeChannelWritabilityChanged() {
        block6: {
            if (this.invokeHandler()) {
                try {
                    ChannelHandler channelHandler = this.handler();
                    DefaultChannelPipeline$HeadContext defaultChannelPipeline$HeadContext = this.pipeline.head;
                    if (channelHandler == defaultChannelPipeline$HeadContext) {
                        defaultChannelPipeline$HeadContext.channelWritabilityChanged(this);
                        break block6;
                    }
                    if (channelHandler instanceof ChannelInboundHandlerAdapter) {
                        ((ChannelInboundHandlerAdapter)channelHandler).channelWritabilityChanged(this);
                        break block6;
                    }
                    ((ChannelInboundHandler)channelHandler).channelWritabilityChanged(this);
                }
                catch (Throwable throwable) {
                    this.invokeExceptionCaught(throwable);
                }
            } else {
                this.fireChannelWritabilityChanged();
            }
        }
    }

    @Override
    public ChannelFuture bind(SocketAddress socketAddress) {
        return this.bind(socketAddress, this.newPromise());
    }

    @Override
    public ChannelFuture connect(SocketAddress socketAddress) {
        return this.connect(socketAddress, this.newPromise());
    }

    @Override
    public ChannelFuture connect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        return this.connect(socketAddress, socketAddress2, this.newPromise());
    }

    @Override
    public ChannelFuture disconnect() {
        return this.disconnect(this.newPromise());
    }

    @Override
    public ChannelFuture close() {
        return this.close(this.newPromise());
    }

    @Override
    public ChannelFuture deregister() {
        return this.deregister(this.newPromise());
    }

    @Override
    public ChannelFuture bind(SocketAddress socketAddress, ChannelPromise channelPromise) {
        ObjectUtil.checkNotNull(socketAddress, "localAddress");
        if (this.isNotValidPromise(channelPromise, false)) {
            return channelPromise;
        }
        AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextOutbound(512);
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeBind(socketAddress, channelPromise);
        } else {
            AbstractChannelHandlerContext.safeExecute(eventExecutor, new AbstractChannelHandlerContext$8(this, abstractChannelHandlerContext, socketAddress, channelPromise), channelPromise, null, false);
        }
        return channelPromise;
    }

    private void invokeBind(SocketAddress socketAddress, ChannelPromise channelPromise) {
        block7: {
            if (this.invokeHandler()) {
                try {
                    ChannelHandler channelHandler = this.handler();
                    DefaultChannelPipeline$HeadContext defaultChannelPipeline$HeadContext = this.pipeline.head;
                    if (channelHandler == defaultChannelPipeline$HeadContext) {
                        defaultChannelPipeline$HeadContext.bind(this, socketAddress, channelPromise);
                        break block7;
                    }
                    if (channelHandler instanceof ChannelDuplexHandler) {
                        ((ChannelDuplexHandler)channelHandler).bind(this, socketAddress, channelPromise);
                        break block7;
                    }
                    if (channelHandler instanceof ChannelOutboundHandlerAdapter) {
                        ((ChannelOutboundHandlerAdapter)channelHandler).bind(this, socketAddress, channelPromise);
                        break block7;
                    }
                    ((ChannelOutboundHandler)channelHandler).bind(this, socketAddress, channelPromise);
                }
                catch (Throwable throwable) {
                    AbstractChannelHandlerContext.notifyOutboundHandlerException(throwable, channelPromise);
                }
            } else {
                this.bind(socketAddress, channelPromise);
            }
        }
    }

    @Override
    public ChannelFuture connect(SocketAddress socketAddress, ChannelPromise channelPromise) {
        return this.connect(socketAddress, null, channelPromise);
    }

    @Override
    public ChannelFuture connect(SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
        ObjectUtil.checkNotNull(socketAddress, "remoteAddress");
        if (this.isNotValidPromise(channelPromise, false)) {
            return channelPromise;
        }
        AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextOutbound(1024);
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeConnect(socketAddress, socketAddress2, channelPromise);
        } else {
            AbstractChannelHandlerContext.safeExecute(eventExecutor, new AbstractChannelHandlerContext$9(this, abstractChannelHandlerContext, socketAddress, socketAddress2, channelPromise), channelPromise, null, false);
        }
        return channelPromise;
    }

    private void invokeConnect(SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
        block7: {
            if (this.invokeHandler()) {
                try {
                    ChannelHandler channelHandler = this.handler();
                    DefaultChannelPipeline$HeadContext defaultChannelPipeline$HeadContext = this.pipeline.head;
                    if (channelHandler == defaultChannelPipeline$HeadContext) {
                        defaultChannelPipeline$HeadContext.connect(this, socketAddress, socketAddress2, channelPromise);
                        break block7;
                    }
                    if (channelHandler instanceof ChannelDuplexHandler) {
                        ((ChannelDuplexHandler)channelHandler).connect(this, socketAddress, socketAddress2, channelPromise);
                        break block7;
                    }
                    if (channelHandler instanceof ChannelOutboundHandlerAdapter) {
                        ((ChannelOutboundHandlerAdapter)channelHandler).connect(this, socketAddress, socketAddress2, channelPromise);
                        break block7;
                    }
                    ((ChannelOutboundHandler)channelHandler).connect(this, socketAddress, socketAddress2, channelPromise);
                }
                catch (Throwable throwable) {
                    AbstractChannelHandlerContext.notifyOutboundHandlerException(throwable, channelPromise);
                }
            } else {
                this.connect(socketAddress, socketAddress2, channelPromise);
            }
        }
    }

    @Override
    public ChannelFuture disconnect(ChannelPromise channelPromise) {
        if (!this.channel().metadata().hasDisconnect()) {
            return this.close(channelPromise);
        }
        if (this.isNotValidPromise(channelPromise, false)) {
            return channelPromise;
        }
        AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextOutbound(2048);
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeDisconnect(channelPromise);
        } else {
            AbstractChannelHandlerContext.safeExecute(eventExecutor, new AbstractChannelHandlerContext$10(this, abstractChannelHandlerContext, channelPromise), channelPromise, null, false);
        }
        return channelPromise;
    }

    private void invokeDisconnect(ChannelPromise channelPromise) {
        block7: {
            if (this.invokeHandler()) {
                try {
                    ChannelHandler channelHandler = this.handler();
                    DefaultChannelPipeline$HeadContext defaultChannelPipeline$HeadContext = this.pipeline.head;
                    if (channelHandler == defaultChannelPipeline$HeadContext) {
                        defaultChannelPipeline$HeadContext.disconnect(this, channelPromise);
                        break block7;
                    }
                    if (channelHandler instanceof ChannelDuplexHandler) {
                        ((ChannelDuplexHandler)channelHandler).disconnect(this, channelPromise);
                        break block7;
                    }
                    if (channelHandler instanceof ChannelOutboundHandlerAdapter) {
                        ((ChannelOutboundHandlerAdapter)channelHandler).disconnect(this, channelPromise);
                        break block7;
                    }
                    ((ChannelOutboundHandler)channelHandler).disconnect(this, channelPromise);
                }
                catch (Throwable throwable) {
                    AbstractChannelHandlerContext.notifyOutboundHandlerException(throwable, channelPromise);
                }
            } else {
                this.disconnect(channelPromise);
            }
        }
    }

    @Override
    public ChannelFuture close(ChannelPromise channelPromise) {
        if (this.isNotValidPromise(channelPromise, false)) {
            return channelPromise;
        }
        AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextOutbound(4096);
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeClose(channelPromise);
        } else {
            AbstractChannelHandlerContext.safeExecute(eventExecutor, new AbstractChannelHandlerContext$11(this, abstractChannelHandlerContext, channelPromise), channelPromise, null, false);
        }
        return channelPromise;
    }

    private void invokeClose(ChannelPromise channelPromise) {
        block7: {
            if (this.invokeHandler()) {
                try {
                    ChannelHandler channelHandler = this.handler();
                    DefaultChannelPipeline$HeadContext defaultChannelPipeline$HeadContext = this.pipeline.head;
                    if (channelHandler == defaultChannelPipeline$HeadContext) {
                        defaultChannelPipeline$HeadContext.close(this, channelPromise);
                        break block7;
                    }
                    if (channelHandler instanceof ChannelDuplexHandler) {
                        ((ChannelDuplexHandler)channelHandler).close(this, channelPromise);
                        break block7;
                    }
                    if (channelHandler instanceof ChannelOutboundHandlerAdapter) {
                        ((ChannelOutboundHandlerAdapter)channelHandler).close(this, channelPromise);
                        break block7;
                    }
                    ((ChannelOutboundHandler)channelHandler).close(this, channelPromise);
                }
                catch (Throwable throwable) {
                    AbstractChannelHandlerContext.notifyOutboundHandlerException(throwable, channelPromise);
                }
            } else {
                this.close(channelPromise);
            }
        }
    }

    @Override
    public ChannelFuture deregister(ChannelPromise channelPromise) {
        if (this.isNotValidPromise(channelPromise, false)) {
            return channelPromise;
        }
        AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextOutbound(8192);
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeDeregister(channelPromise);
        } else {
            AbstractChannelHandlerContext.safeExecute(eventExecutor, new AbstractChannelHandlerContext$12(this, abstractChannelHandlerContext, channelPromise), channelPromise, null, false);
        }
        return channelPromise;
    }

    private void invokeDeregister(ChannelPromise channelPromise) {
        block7: {
            if (this.invokeHandler()) {
                try {
                    ChannelHandler channelHandler = this.handler();
                    DefaultChannelPipeline$HeadContext defaultChannelPipeline$HeadContext = this.pipeline.head;
                    if (channelHandler == defaultChannelPipeline$HeadContext) {
                        defaultChannelPipeline$HeadContext.deregister(this, channelPromise);
                        break block7;
                    }
                    if (channelHandler instanceof ChannelDuplexHandler) {
                        ((ChannelDuplexHandler)channelHandler).deregister(this, channelPromise);
                        break block7;
                    }
                    if (channelHandler instanceof ChannelOutboundHandlerAdapter) {
                        ((ChannelOutboundHandlerAdapter)channelHandler).deregister(this, channelPromise);
                        break block7;
                    }
                    ((ChannelOutboundHandler)channelHandler).deregister(this, channelPromise);
                }
                catch (Throwable throwable) {
                    AbstractChannelHandlerContext.notifyOutboundHandlerException(throwable, channelPromise);
                }
            } else {
                this.deregister(channelPromise);
            }
        }
    }

    @Override
    public ChannelHandlerContext read() {
        AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextOutbound(16384);
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeRead();
        } else {
            AbstractChannelHandlerContext$Tasks abstractChannelHandlerContext$Tasks = abstractChannelHandlerContext.invokeTasks;
            if (abstractChannelHandlerContext$Tasks == null) {
                abstractChannelHandlerContext.invokeTasks = abstractChannelHandlerContext$Tasks = new AbstractChannelHandlerContext$Tasks(abstractChannelHandlerContext);
            }
            eventExecutor.execute(AbstractChannelHandlerContext$Tasks.access$1400(abstractChannelHandlerContext$Tasks));
        }
        return this;
    }

    private void invokeRead() {
        block7: {
            if (this.invokeHandler()) {
                try {
                    ChannelHandler channelHandler = this.handler();
                    DefaultChannelPipeline$HeadContext defaultChannelPipeline$HeadContext = this.pipeline.head;
                    if (channelHandler == defaultChannelPipeline$HeadContext) {
                        defaultChannelPipeline$HeadContext.read(this);
                        break block7;
                    }
                    if (channelHandler instanceof ChannelDuplexHandler) {
                        ((ChannelDuplexHandler)channelHandler).read(this);
                        break block7;
                    }
                    if (channelHandler instanceof ChannelOutboundHandlerAdapter) {
                        ((ChannelOutboundHandlerAdapter)channelHandler).read(this);
                        break block7;
                    }
                    ((ChannelOutboundHandler)channelHandler).read(this);
                }
                catch (Throwable throwable) {
                    this.invokeExceptionCaught(throwable);
                }
            } else {
                this.read();
            }
        }
    }

    @Override
    public ChannelFuture write(Object object) {
        return this.write(object, this.newPromise());
    }

    @Override
    public ChannelFuture write(Object object, ChannelPromise channelPromise) {
        this.write(object, false, channelPromise);
        return channelPromise;
    }

    void invokeWrite(Object object, ChannelPromise channelPromise) {
        if (this.invokeHandler()) {
            this.invokeWrite0(object, channelPromise);
        } else {
            this.write(object, channelPromise);
        }
    }

    private void invokeWrite0(Object object, ChannelPromise channelPromise) {
        try {
            ChannelHandler channelHandler = this.handler();
            DefaultChannelPipeline$HeadContext defaultChannelPipeline$HeadContext = this.pipeline.head;
            if (channelHandler == defaultChannelPipeline$HeadContext) {
                defaultChannelPipeline$HeadContext.write(this, object, channelPromise);
            } else if (channelHandler instanceof ChannelDuplexHandler) {
                ((ChannelDuplexHandler)channelHandler).write(this, object, channelPromise);
            } else if (channelHandler instanceof ChannelOutboundHandlerAdapter) {
                ((ChannelOutboundHandlerAdapter)channelHandler).write(this, object, channelPromise);
            } else {
                ((ChannelOutboundHandler)channelHandler).write(this, object, channelPromise);
            }
        }
        catch (Throwable throwable) {
            AbstractChannelHandlerContext.notifyOutboundHandlerException(throwable, channelPromise);
        }
    }

    @Override
    public ChannelHandlerContext flush() {
        AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextOutbound(65536);
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            abstractChannelHandlerContext.invokeFlush();
        } else {
            AbstractChannelHandlerContext$Tasks abstractChannelHandlerContext$Tasks = abstractChannelHandlerContext.invokeTasks;
            if (abstractChannelHandlerContext$Tasks == null) {
                abstractChannelHandlerContext.invokeTasks = abstractChannelHandlerContext$Tasks = new AbstractChannelHandlerContext$Tasks(abstractChannelHandlerContext);
            }
            AbstractChannelHandlerContext.safeExecute(eventExecutor, AbstractChannelHandlerContext$Tasks.access$1500(abstractChannelHandlerContext$Tasks), this.channel().voidPromise(), null, false);
        }
        return this;
    }

    private void invokeFlush() {
        if (this.invokeHandler()) {
            this.invokeFlush0();
        } else {
            this.flush();
        }
    }

    private void invokeFlush0() {
        try {
            ChannelHandler channelHandler = this.handler();
            DefaultChannelPipeline$HeadContext defaultChannelPipeline$HeadContext = this.pipeline.head;
            if (channelHandler == defaultChannelPipeline$HeadContext) {
                defaultChannelPipeline$HeadContext.flush(this);
            } else if (channelHandler instanceof ChannelDuplexHandler) {
                ((ChannelDuplexHandler)channelHandler).flush(this);
            } else if (channelHandler instanceof ChannelOutboundHandlerAdapter) {
                ((ChannelOutboundHandlerAdapter)channelHandler).flush(this);
            } else {
                ((ChannelOutboundHandler)channelHandler).flush(this);
            }
        }
        catch (Throwable throwable) {
            this.invokeExceptionCaught(throwable);
        }
    }

    @Override
    public ChannelFuture writeAndFlush(Object object, ChannelPromise channelPromise) {
        this.write(object, true, channelPromise);
        return channelPromise;
    }

    void invokeWriteAndFlush(Object object, ChannelPromise channelPromise) {
        if (this.invokeHandler()) {
            this.invokeWrite0(object, channelPromise);
            this.invokeFlush0();
        } else {
            this.writeAndFlush(object, channelPromise);
        }
    }

    private void write(Object object, boolean bl, ChannelPromise channelPromise) {
        ObjectUtil.checkNotNull(object, "msg");
        try {
            if (this.isNotValidPromise(channelPromise, true)) {
                ReferenceCountUtil.release(object);
                return;
            }
        }
        catch (RuntimeException runtimeException) {
            ReferenceCountUtil.release(object);
            throw runtimeException;
        }
        AbstractChannelHandlerContext abstractChannelHandlerContext = this.findContextOutbound(bl ? 98304 : 32768);
        Object object2 = this.pipeline.touch(object, abstractChannelHandlerContext);
        EventExecutor eventExecutor = abstractChannelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            if (bl) {
                abstractChannelHandlerContext.invokeWriteAndFlush(object2, channelPromise);
            } else {
                abstractChannelHandlerContext.invokeWrite(object2, channelPromise);
            }
        } else {
            AbstractChannelHandlerContext$WriteTask abstractChannelHandlerContext$WriteTask = AbstractChannelHandlerContext$WriteTask.newInstance(abstractChannelHandlerContext, object2, channelPromise, bl);
            if (!AbstractChannelHandlerContext.safeExecute(eventExecutor, abstractChannelHandlerContext$WriteTask, channelPromise, object2, !bl)) {
                abstractChannelHandlerContext$WriteTask.cancel();
            }
        }
    }

    @Override
    public ChannelFuture writeAndFlush(Object object) {
        return this.writeAndFlush(object, this.newPromise());
    }

    private static void notifyOutboundHandlerException(Throwable throwable, ChannelPromise channelPromise) {
        PromiseNotificationUtil.tryFailure(channelPromise, throwable, channelPromise instanceof VoidChannelPromise ? null : logger);
    }

    @Override
    public ChannelPromise newPromise() {
        return new DefaultChannelPromise(this.channel(), this.executor());
    }

    @Override
    public ChannelProgressivePromise newProgressivePromise() {
        return new DefaultChannelProgressivePromise(this.channel(), this.executor());
    }

    @Override
    public ChannelFuture newSucceededFuture() {
        ChannelFuture channelFuture = this.succeededFuture;
        if (channelFuture == null) {
            this.succeededFuture = channelFuture = new SucceededChannelFuture(this.channel(), this.executor());
        }
        return channelFuture;
    }

    @Override
    public ChannelFuture newFailedFuture(Throwable throwable) {
        return new FailedChannelFuture(this.channel(), this.executor(), throwable);
    }

    private boolean isNotValidPromise(ChannelPromise channelPromise, boolean bl) {
        ObjectUtil.checkNotNull(channelPromise, "promise");
        if (channelPromise.isDone()) {
            if (channelPromise.isCancelled()) {
                return true;
            }
            throw new IllegalArgumentException("promise already done: " + channelPromise);
        }
        if (channelPromise.channel() != this.channel()) {
            throw new IllegalArgumentException(String.format("promise.channel does not match: %s (expected: %s)", channelPromise.channel(), this.channel()));
        }
        if (channelPromise.getClass() == DefaultChannelPromise.class) {
            return false;
        }
        if (!bl && channelPromise instanceof VoidChannelPromise) {
            throw new IllegalArgumentException(StringUtil.simpleClassName(VoidChannelPromise.class) + " not allowed for this operation");
        }
        if (channelPromise instanceof AbstractChannel.CloseFuture) {
            throw new IllegalArgumentException(StringUtil.simpleClassName(AbstractChannel.CloseFuture.class) + " not allowed in a pipeline");
        }
        return false;
    }

    private AbstractChannelHandlerContext findContextInbound(int n) {
        AbstractChannelHandlerContext abstractChannelHandlerContext = this;
        EventExecutor eventExecutor = this.executor();
        while (AbstractChannelHandlerContext.skipContext(abstractChannelHandlerContext = abstractChannelHandlerContext.next, eventExecutor, n, 510)) {
        }
        return abstractChannelHandlerContext;
    }

    private AbstractChannelHandlerContext findContextOutbound(int n) {
        AbstractChannelHandlerContext abstractChannelHandlerContext = this;
        EventExecutor eventExecutor = this.executor();
        while (AbstractChannelHandlerContext.skipContext(abstractChannelHandlerContext = abstractChannelHandlerContext.prev, eventExecutor, n, 130560)) {
        }
        return abstractChannelHandlerContext;
    }

    private static boolean skipContext(AbstractChannelHandlerContext abstractChannelHandlerContext, EventExecutor eventExecutor, int n, int n2) {
        return (abstractChannelHandlerContext.executionMask & (n2 | n)) == 0 || abstractChannelHandlerContext.executor() == eventExecutor && (abstractChannelHandlerContext.executionMask & n) == 0;
    }

    @Override
    public ChannelPromise voidPromise() {
        return this.channel().voidPromise();
    }

    final void setRemoved() {
        this.handlerState = 3;
    }

    final boolean setAddComplete() {
        int n;
        do {
            if ((n = this.handlerState) != 3) continue;
            return false;
        } while (!HANDLER_STATE_UPDATER.compareAndSet(this, n, 2));
        return true;
    }

    final void setAddPending() {
        boolean bl = HANDLER_STATE_UPDATER.compareAndSet(this, 0, 1);
        assert (bl);
    }

    final void callHandlerAdded() {
        if (this.setAddComplete()) {
            this.handler().handlerAdded(this);
        }
    }

    final void callHandlerRemoved() {
        try {
            if (this.handlerState == 2) {
                this.handler().handlerRemoved(this);
            }
        }
        finally {
            this.setRemoved();
        }
    }

    private boolean invokeHandler() {
        int n = this.handlerState;
        return n == 2 || !this.ordered && n == 1;
    }

    @Override
    public boolean isRemoved() {
        return this.handlerState == 3;
    }

    @Override
    public <T> Attribute<T> attr(AttributeKey<T> attributeKey) {
        return this.channel().attr(attributeKey);
    }

    @Override
    public <T> boolean hasAttr(AttributeKey<T> attributeKey) {
        return this.channel().hasAttr(attributeKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean safeExecute(EventExecutor eventExecutor, Runnable runnable, ChannelPromise channelPromise, Object object, boolean bl) {
        try {
            if (bl && eventExecutor instanceof AbstractEventExecutor) {
                ((AbstractEventExecutor)eventExecutor).lazyExecute(runnable);
            } else {
                eventExecutor.execute(runnable);
            }
            return true;
        }
        catch (Throwable throwable) {
            try {
                if (object != null) {
                    ReferenceCountUtil.release(object);
                }
            }
            finally {
                channelPromise.setFailure(throwable);
            }
            return false;
        }
    }

    @Override
    public String toHintString() {
        return '\'' + this.name + "' will handle the message from this point.";
    }

    public String toString() {
        return StringUtil.simpleClassName(ChannelHandlerContext.class) + '(' + this.name + ", " + this.channel() + ')';
    }

    static /* synthetic */ void access$000(AbstractChannelHandlerContext abstractChannelHandlerContext) {
        abstractChannelHandlerContext.invokeChannelRegistered();
    }

    static /* synthetic */ void access$100(AbstractChannelHandlerContext abstractChannelHandlerContext) {
        abstractChannelHandlerContext.invokeChannelUnregistered();
    }

    static /* synthetic */ void access$200(AbstractChannelHandlerContext abstractChannelHandlerContext) {
        abstractChannelHandlerContext.invokeChannelActive();
    }

    static /* synthetic */ void access$300(AbstractChannelHandlerContext abstractChannelHandlerContext) {
        abstractChannelHandlerContext.invokeChannelInactive();
    }

    static /* synthetic */ void access$400(AbstractChannelHandlerContext abstractChannelHandlerContext, Throwable throwable) {
        abstractChannelHandlerContext.invokeExceptionCaught(throwable);
    }

    static /* synthetic */ void access$500(AbstractChannelHandlerContext abstractChannelHandlerContext, Object object) {
        abstractChannelHandlerContext.invokeUserEventTriggered(object);
    }

    static /* synthetic */ void access$600(AbstractChannelHandlerContext abstractChannelHandlerContext, Object object) {
        abstractChannelHandlerContext.invokeChannelRead(object);
    }

    static /* synthetic */ void access$900(AbstractChannelHandlerContext abstractChannelHandlerContext, SocketAddress socketAddress, ChannelPromise channelPromise) {
        abstractChannelHandlerContext.invokeBind(socketAddress, channelPromise);
    }

    static /* synthetic */ void access$1000(AbstractChannelHandlerContext abstractChannelHandlerContext, SocketAddress socketAddress, SocketAddress socketAddress2, ChannelPromise channelPromise) {
        abstractChannelHandlerContext.invokeConnect(socketAddress, socketAddress2, channelPromise);
    }

    static /* synthetic */ void access$1100(AbstractChannelHandlerContext abstractChannelHandlerContext, ChannelPromise channelPromise) {
        abstractChannelHandlerContext.invokeDisconnect(channelPromise);
    }

    static /* synthetic */ void access$1200(AbstractChannelHandlerContext abstractChannelHandlerContext, ChannelPromise channelPromise) {
        abstractChannelHandlerContext.invokeClose(channelPromise);
    }

    static /* synthetic */ void access$1300(AbstractChannelHandlerContext abstractChannelHandlerContext, ChannelPromise channelPromise) {
        abstractChannelHandlerContext.invokeDeregister(channelPromise);
    }

    static /* synthetic */ DefaultChannelPipeline access$1700(AbstractChannelHandlerContext abstractChannelHandlerContext) {
        return abstractChannelHandlerContext.pipeline;
    }

    static /* synthetic */ void access$1900(AbstractChannelHandlerContext abstractChannelHandlerContext) {
        abstractChannelHandlerContext.invokeChannelReadComplete();
    }

    static /* synthetic */ void access$2000(AbstractChannelHandlerContext abstractChannelHandlerContext) {
        abstractChannelHandlerContext.invokeRead();
    }

    static /* synthetic */ void access$2100(AbstractChannelHandlerContext abstractChannelHandlerContext) {
        abstractChannelHandlerContext.invokeChannelWritabilityChanged();
    }

    static /* synthetic */ void access$2200(AbstractChannelHandlerContext abstractChannelHandlerContext) {
        abstractChannelHandlerContext.invokeFlush();
    }
}

