/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.channel;

import pro.gravit.repackage.io.netty.buffer.AbstractReferenceCountedByteBuf;
import pro.gravit.repackage.io.netty.channel.Channel;
import pro.gravit.repackage.io.netty.channel.ChannelFuture;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.channel.ChannelOutboundInvoker;
import pro.gravit.repackage.io.netty.channel.ChannelPromise;
import pro.gravit.repackage.io.netty.channel.PendingBytesTracker;
import pro.gravit.repackage.io.netty.channel.PendingWriteQueue$PendingWrite;
import pro.gravit.repackage.io.netty.channel.VoidChannelPromise;
import pro.gravit.repackage.io.netty.util.ReferenceCountUtil;
import pro.gravit.repackage.io.netty.util.concurrent.EventExecutor;
import pro.gravit.repackage.io.netty.util.concurrent.PromiseCombiner;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;
import pro.gravit.repackage.io.netty.util.internal.SystemPropertyUtil;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;

public final class PendingWriteQueue {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PendingWriteQueue.class);
    private static final int PENDING_WRITE_OVERHEAD = SystemPropertyUtil.getInt("pro.gravit.repackage.io.netty.transport.pendingWriteSizeOverhead", 64);
    private final ChannelOutboundInvoker invoker;
    private final EventExecutor executor;
    private final PendingBytesTracker tracker;
    private PendingWriteQueue$PendingWrite head;
    private PendingWriteQueue$PendingWrite tail;
    private int size;
    private long bytes;

    public PendingWriteQueue(ChannelHandlerContext channelHandlerContext) {
        this.tracker = PendingBytesTracker.newTracker(channelHandlerContext.channel());
        this.invoker = channelHandlerContext;
        this.executor = channelHandlerContext.executor();
    }

    public PendingWriteQueue(Channel channel) {
        this.tracker = PendingBytesTracker.newTracker(channel);
        this.invoker = channel;
        this.executor = channel.eventLoop();
    }

    public boolean isEmpty() {
        assert (this.executor.inEventLoop());
        return this.head == null;
    }

    public int size() {
        assert (this.executor.inEventLoop());
        return this.size;
    }

    public long bytes() {
        assert (this.executor.inEventLoop());
        return this.bytes;
    }

    private int size(Object object) {
        int n = this.tracker.size(object);
        if (n < 0) {
            n = 0;
        }
        return n + PENDING_WRITE_OVERHEAD;
    }

    public void add(Object object, ChannelPromise channelPromise) {
        assert (this.executor.inEventLoop());
        ObjectUtil.checkNotNull(object, "msg");
        ObjectUtil.checkNotNull(channelPromise, "promise");
        int n = this.size(object);
        PendingWriteQueue$PendingWrite pendingWriteQueue$PendingWrite = PendingWriteQueue$PendingWrite.newInstance(object, n, channelPromise);
        PendingWriteQueue$PendingWrite pendingWriteQueue$PendingWrite2 = this.tail;
        if (pendingWriteQueue$PendingWrite2 == null) {
            this.tail = this.head = pendingWriteQueue$PendingWrite;
        } else {
            PendingWriteQueue$PendingWrite.access$002(pendingWriteQueue$PendingWrite2, pendingWriteQueue$PendingWrite);
            this.tail = pendingWriteQueue$PendingWrite;
        }
        ++this.size;
        this.bytes += (long)n;
        this.tracker.incrementPendingOutboundBytes(PendingWriteQueue$PendingWrite.access$100(pendingWriteQueue$PendingWrite));
        if (object instanceof AbstractReferenceCountedByteBuf) {
            ((AbstractReferenceCountedByteBuf)object).touch();
        } else {
            ReferenceCountUtil.touch(object);
        }
    }

    public ChannelFuture removeAndWriteAll() {
        assert (this.executor.inEventLoop());
        if (this.isEmpty()) {
            return null;
        }
        ChannelPromise channelPromise = this.invoker.newPromise();
        PromiseCombiner promiseCombiner = new PromiseCombiner(this.executor);
        try {
            PendingWriteQueue$PendingWrite pendingWriteQueue$PendingWrite = this.head;
            while (pendingWriteQueue$PendingWrite != null) {
                this.tail = null;
                this.head = null;
                this.size = 0;
                this.bytes = 0L;
                while (pendingWriteQueue$PendingWrite != null) {
                    PendingWriteQueue$PendingWrite pendingWriteQueue$PendingWrite2 = PendingWriteQueue$PendingWrite.access$000(pendingWriteQueue$PendingWrite);
                    Object object = PendingWriteQueue$PendingWrite.access$200(pendingWriteQueue$PendingWrite);
                    ChannelPromise channelPromise2 = PendingWriteQueue$PendingWrite.access$300(pendingWriteQueue$PendingWrite);
                    this.recycle(pendingWriteQueue$PendingWrite, false);
                    if (!(channelPromise2 instanceof VoidChannelPromise)) {
                        promiseCombiner.add(channelPromise2);
                    }
                    this.invoker.write(object, channelPromise2);
                    pendingWriteQueue$PendingWrite = pendingWriteQueue$PendingWrite2;
                }
                pendingWriteQueue$PendingWrite = this.head;
            }
            promiseCombiner.finish(channelPromise);
        }
        catch (Throwable throwable) {
            channelPromise.setFailure(throwable);
        }
        this.assertEmpty();
        return channelPromise;
    }

    public void removeAndFailAll(Throwable throwable) {
        assert (this.executor.inEventLoop());
        ObjectUtil.checkNotNull(throwable, "cause");
        PendingWriteQueue$PendingWrite pendingWriteQueue$PendingWrite = this.head;
        while (pendingWriteQueue$PendingWrite != null) {
            this.tail = null;
            this.head = null;
            this.size = 0;
            this.bytes = 0L;
            while (pendingWriteQueue$PendingWrite != null) {
                PendingWriteQueue$PendingWrite pendingWriteQueue$PendingWrite2 = PendingWriteQueue$PendingWrite.access$000(pendingWriteQueue$PendingWrite);
                ReferenceCountUtil.safeRelease(PendingWriteQueue$PendingWrite.access$200(pendingWriteQueue$PendingWrite));
                ChannelPromise channelPromise = PendingWriteQueue$PendingWrite.access$300(pendingWriteQueue$PendingWrite);
                this.recycle(pendingWriteQueue$PendingWrite, false);
                PendingWriteQueue.safeFail(channelPromise, throwable);
                pendingWriteQueue$PendingWrite = pendingWriteQueue$PendingWrite2;
            }
            pendingWriteQueue$PendingWrite = this.head;
        }
        this.assertEmpty();
    }

    public void removeAndFail(Throwable throwable) {
        assert (this.executor.inEventLoop());
        ObjectUtil.checkNotNull(throwable, "cause");
        PendingWriteQueue$PendingWrite pendingWriteQueue$PendingWrite = this.head;
        if (pendingWriteQueue$PendingWrite == null) {
            return;
        }
        ReferenceCountUtil.safeRelease(PendingWriteQueue$PendingWrite.access$200(pendingWriteQueue$PendingWrite));
        ChannelPromise channelPromise = PendingWriteQueue$PendingWrite.access$300(pendingWriteQueue$PendingWrite);
        PendingWriteQueue.safeFail(channelPromise, throwable);
        this.recycle(pendingWriteQueue$PendingWrite, true);
    }

    private void assertEmpty() {
        assert (this.tail == null && this.head == null && this.size == 0);
    }

    public ChannelFuture removeAndWrite() {
        assert (this.executor.inEventLoop());
        PendingWriteQueue$PendingWrite pendingWriteQueue$PendingWrite = this.head;
        if (pendingWriteQueue$PendingWrite == null) {
            return null;
        }
        Object object = PendingWriteQueue$PendingWrite.access$200(pendingWriteQueue$PendingWrite);
        ChannelPromise channelPromise = PendingWriteQueue$PendingWrite.access$300(pendingWriteQueue$PendingWrite);
        this.recycle(pendingWriteQueue$PendingWrite, true);
        return this.invoker.write(object, channelPromise);
    }

    public ChannelPromise remove() {
        assert (this.executor.inEventLoop());
        PendingWriteQueue$PendingWrite pendingWriteQueue$PendingWrite = this.head;
        if (pendingWriteQueue$PendingWrite == null) {
            return null;
        }
        ChannelPromise channelPromise = PendingWriteQueue$PendingWrite.access$300(pendingWriteQueue$PendingWrite);
        ReferenceCountUtil.safeRelease(PendingWriteQueue$PendingWrite.access$200(pendingWriteQueue$PendingWrite));
        this.recycle(pendingWriteQueue$PendingWrite, true);
        return channelPromise;
    }

    public Object current() {
        assert (this.executor.inEventLoop());
        PendingWriteQueue$PendingWrite pendingWriteQueue$PendingWrite = this.head;
        if (pendingWriteQueue$PendingWrite == null) {
            return null;
        }
        return PendingWriteQueue$PendingWrite.access$200(pendingWriteQueue$PendingWrite);
    }

    private void recycle(PendingWriteQueue$PendingWrite pendingWriteQueue$PendingWrite, boolean bl) {
        PendingWriteQueue$PendingWrite pendingWriteQueue$PendingWrite2 = PendingWriteQueue$PendingWrite.access$000(pendingWriteQueue$PendingWrite);
        long l = PendingWriteQueue$PendingWrite.access$100(pendingWriteQueue$PendingWrite);
        if (bl) {
            if (pendingWriteQueue$PendingWrite2 == null) {
                this.tail = null;
                this.head = null;
                this.size = 0;
                this.bytes = 0L;
            } else {
                this.head = pendingWriteQueue$PendingWrite2;
                --this.size;
                this.bytes -= l;
                assert (this.size > 0 && this.bytes >= 0L);
            }
        }
        PendingWriteQueue$PendingWrite.access$400(pendingWriteQueue$PendingWrite);
        this.tracker.decrementPendingOutboundBytes(l);
    }

    private static void safeFail(ChannelPromise channelPromise, Throwable throwable) {
        if (!(channelPromise instanceof VoidChannelPromise) && !channelPromise.tryFailure(throwable)) {
            logger.warn("Failed to mark a promise as failure because it's done already: {}", (Object)channelPromise, (Object)throwable);
        }
    }
}

