/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.channel.socket.nio;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.channel.AbstractChannel$AbstractUnsafe;
import pro.gravit.repackage.io.netty.channel.Channel;
import pro.gravit.repackage.io.netty.channel.ChannelConfig;
import pro.gravit.repackage.io.netty.channel.ChannelException;
import pro.gravit.repackage.io.netty.channel.ChannelFuture;
import pro.gravit.repackage.io.netty.channel.ChannelOutboundBuffer;
import pro.gravit.repackage.io.netty.channel.ChannelPromise;
import pro.gravit.repackage.io.netty.channel.FileRegion;
import pro.gravit.repackage.io.netty.channel.RecvByteBufAllocator$Handle;
import pro.gravit.repackage.io.netty.channel.ServerChannel;
import pro.gravit.repackage.io.netty.channel.nio.AbstractNioByteChannel;
import pro.gravit.repackage.io.netty.channel.nio.AbstractNioChannel$AbstractNioUnsafe;
import pro.gravit.repackage.io.netty.channel.nio.NioEventLoop;
import pro.gravit.repackage.io.netty.channel.socket.DuplexChannel;
import pro.gravit.repackage.io.netty.channel.socket.nio.NioDomainSocketChannel$1;
import pro.gravit.repackage.io.netty.channel.socket.nio.NioDomainSocketChannel$2;
import pro.gravit.repackage.io.netty.channel.socket.nio.NioDomainSocketChannel$3;
import pro.gravit.repackage.io.netty.channel.socket.nio.NioDomainSocketChannel$4;
import pro.gravit.repackage.io.netty.channel.socket.nio.NioDomainSocketChannel$NioDomainSocketChannelConfig;
import pro.gravit.repackage.io.netty.channel.socket.nio.NioDomainSocketChannel$NioSocketChannelUnsafe;
import pro.gravit.repackage.io.netty.channel.socket.nio.SelectorProviderUtil;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;
import pro.gravit.repackage.io.netty.util.internal.SocketUtils;
import pro.gravit.repackage.io.netty.util.internal.SuppressJava6Requirement;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;

public final class NioDomainSocketChannel
extends AbstractNioByteChannel
implements DuplexChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(NioDomainSocketChannel.class);
    private static final SelectorProvider DEFAULT_SELECTOR_PROVIDER = SelectorProvider.provider();
    private static final Method OPEN_SOCKET_CHANNEL_WITH_FAMILY = SelectorProviderUtil.findOpenMethod("openSocketChannel");
    private final ChannelConfig config;
    private volatile boolean isInputShutdown;
    private volatile boolean isOutputShutdown;

    static SocketChannel newChannel(SelectorProvider selectorProvider) {
        if (PlatformDependent.javaVersion() < 16) {
            throw new UnsupportedOperationException("Only supported on java 16+");
        }
        try {
            SocketChannel socketChannel = (SocketChannel)SelectorProviderUtil.newDomainSocketChannel(OPEN_SOCKET_CHANNEL_WITH_FAMILY, selectorProvider);
            if (socketChannel == null) {
                throw new ChannelException("Failed to open a socket.");
            }
            return socketChannel;
        }
        catch (IOException iOException) {
            throw new ChannelException("Failed to open a socket.", iOException);
        }
    }

    public NioDomainSocketChannel() {
        this(DEFAULT_SELECTOR_PROVIDER);
    }

    public NioDomainSocketChannel(SelectorProvider selectorProvider) {
        this(NioDomainSocketChannel.newChannel(selectorProvider));
    }

    public NioDomainSocketChannel(SocketChannel socketChannel) {
        this(null, socketChannel);
    }

    public NioDomainSocketChannel(Channel channel, SocketChannel socketChannel) {
        super(channel, socketChannel);
        if (PlatformDependent.javaVersion() < 16) {
            throw new UnsupportedOperationException("Only supported on java 16+");
        }
        this.config = new NioDomainSocketChannel$NioDomainSocketChannelConfig(this, this, socketChannel, null);
    }

    @Override
    public ServerChannel parent() {
        return (ServerChannel)super.parent();
    }

    @Override
    public ChannelConfig config() {
        return this.config;
    }

    @Override
    protected SocketChannel javaChannel() {
        return (SocketChannel)super.javaChannel();
    }

    @Override
    public boolean isActive() {
        SocketChannel socketChannel = this.javaChannel();
        return socketChannel.isOpen() && socketChannel.isConnected();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.isOutputShutdown || !this.isActive();
    }

    @Override
    public boolean isInputShutdown() {
        return this.isInputShutdown || !this.isActive();
    }

    @Override
    public boolean isShutdown() {
        return this.isInputShutdown() && this.isOutputShutdown() || !this.isActive();
    }

    @Override
    @SuppressJava6Requirement(reason="guarded by version check")
    protected void doShutdownOutput() {
        this.javaChannel().shutdownOutput();
        this.isOutputShutdown = true;
    }

    @Override
    public ChannelFuture shutdownOutput() {
        return this.shutdownOutput(this.newPromise());
    }

    @Override
    public ChannelFuture shutdownOutput(ChannelPromise channelPromise) {
        NioEventLoop nioEventLoop = this.eventLoop();
        if (nioEventLoop.inEventLoop()) {
            ((AbstractChannel$AbstractUnsafe)((Object)this.unsafe())).shutdownOutput(channelPromise);
        } else {
            nioEventLoop.execute(new NioDomainSocketChannel$1(this, channelPromise));
        }
        return channelPromise;
    }

    @Override
    public ChannelFuture shutdownInput() {
        return this.shutdownInput(this.newPromise());
    }

    @Override
    protected boolean isInputShutdown0() {
        return this.isInputShutdown();
    }

    @Override
    public ChannelFuture shutdownInput(ChannelPromise channelPromise) {
        NioEventLoop nioEventLoop = this.eventLoop();
        if (nioEventLoop.inEventLoop()) {
            this.shutdownInput0(channelPromise);
        } else {
            nioEventLoop.execute(new NioDomainSocketChannel$2(this, channelPromise));
        }
        return channelPromise;
    }

    @Override
    public ChannelFuture shutdown() {
        return this.shutdown(this.newPromise());
    }

    @Override
    public ChannelFuture shutdown(ChannelPromise channelPromise) {
        ChannelFuture channelFuture = this.shutdownOutput();
        if (channelFuture.isDone()) {
            this.shutdownOutputDone(channelFuture, channelPromise);
        } else {
            channelFuture.addListener(new NioDomainSocketChannel$3(this, channelPromise));
        }
        return channelPromise;
    }

    private void shutdownOutputDone(ChannelFuture channelFuture, ChannelPromise channelPromise) {
        ChannelFuture channelFuture2 = this.shutdownInput();
        if (channelFuture2.isDone()) {
            NioDomainSocketChannel.shutdownDone(channelFuture, channelFuture2, channelPromise);
        } else {
            channelFuture2.addListener(new NioDomainSocketChannel$4(this, channelFuture, channelPromise));
        }
    }

    private static void shutdownDone(ChannelFuture channelFuture, ChannelFuture channelFuture2, ChannelPromise channelPromise) {
        Throwable throwable = channelFuture.cause();
        Throwable throwable2 = channelFuture2.cause();
        if (throwable != null) {
            if (throwable2 != null) {
                logger.debug("Exception suppressed because a previous exception occurred.", throwable2);
            }
            channelPromise.setFailure(throwable);
        } else if (throwable2 != null) {
            channelPromise.setFailure(throwable2);
        } else {
            channelPromise.setSuccess();
        }
    }

    private void shutdownInput0(ChannelPromise channelPromise) {
        try {
            this.shutdownInput0();
            channelPromise.setSuccess();
        }
        catch (Throwable throwable) {
            channelPromise.setFailure(throwable);
        }
    }

    @SuppressJava6Requirement(reason="Usage guarded by java version check")
    private void shutdownInput0() {
        this.javaChannel().shutdownInput();
        this.isInputShutdown = true;
    }

    @Override
    @SuppressJava6Requirement(reason="Usage guarded by java version check")
    protected SocketAddress localAddress0() {
        try {
            return this.javaChannel().getLocalAddress();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    @SuppressJava6Requirement(reason="Usage guarded by java version check")
    protected SocketAddress remoteAddress0() {
        try {
            return this.javaChannel().getRemoteAddress();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    protected void doBind(SocketAddress socketAddress) {
        SocketUtils.bind(this.javaChannel(), socketAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doConnect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        if (socketAddress2 != null) {
            this.doBind(socketAddress2);
        }
        boolean bl = false;
        try {
            boolean bl2 = SocketUtils.connect(this.javaChannel(), socketAddress);
            if (!bl2) {
                this.selectionKey().interestOps(8);
            }
            bl = true;
            boolean bl3 = bl2;
            return bl3;
        }
        finally {
            if (!bl) {
                this.doClose();
            }
        }
    }

    @Override
    protected void doFinishConnect() {
        if (!this.javaChannel().finishConnect()) {
            throw new Error();
        }
    }

    @Override
    protected void doDisconnect() {
        this.doClose();
    }

    @Override
    protected void doClose() {
        try {
            super.doClose();
        }
        finally {
            this.javaChannel().close();
        }
    }

    @Override
    protected int doReadBytes(ByteBuf byteBuf) {
        RecvByteBufAllocator$Handle recvByteBufAllocator$Handle = this.unsafe().recvBufAllocHandle();
        recvByteBufAllocator$Handle.attemptedBytesRead(byteBuf.writableBytes());
        return byteBuf.writeBytes(this.javaChannel(), recvByteBufAllocator$Handle.attemptedBytesRead());
    }

    @Override
    protected int doWriteBytes(ByteBuf byteBuf) {
        int n = byteBuf.readableBytes();
        return byteBuf.readBytes(this.javaChannel(), n);
    }

    @Override
    protected long doWriteFileRegion(FileRegion fileRegion) {
        long l = fileRegion.transferred();
        return fileRegion.transferTo(this.javaChannel(), l);
    }

    private void adjustMaxBytesPerGatheringWrite(int n, int n2, int n3) {
        if (n == n2) {
            if (n << 1 > n3) {
                ((NioDomainSocketChannel$NioDomainSocketChannelConfig)this.config).setMaxBytesPerGatheringWrite(n << 1);
            }
        } else if (n > 4096 && n2 < n >>> 1) {
            ((NioDomainSocketChannel$NioDomainSocketChannelConfig)this.config).setMaxBytesPerGatheringWrite(n >>> 1);
        }
    }

    @Override
    protected void doWrite(ChannelOutboundBuffer channelOutboundBuffer) {
        SocketChannel socketChannel = this.javaChannel();
        int n = this.config().getWriteSpinCount();
        do {
            if (channelOutboundBuffer.isEmpty()) {
                this.clearOpWrite();
                return;
            }
            int n2 = ((NioDomainSocketChannel$NioDomainSocketChannelConfig)this.config).getMaxBytesPerGatheringWrite();
            ByteBuffer[] byteBufferArray = channelOutboundBuffer.nioBuffers(1024, n2);
            int n3 = channelOutboundBuffer.nioBufferCount();
            switch (n3) {
                case 0: {
                    n -= this.doWrite0(channelOutboundBuffer);
                    break;
                }
                case 1: {
                    ByteBuffer byteBuffer = byteBufferArray[0];
                    int n4 = byteBuffer.remaining();
                    int n5 = socketChannel.write(byteBuffer);
                    if (n5 <= 0) {
                        this.incompleteWrite(true);
                        return;
                    }
                    this.adjustMaxBytesPerGatheringWrite(n4, n5, n2);
                    channelOutboundBuffer.removeBytes(n5);
                    --n;
                    break;
                }
                default: {
                    long l = channelOutboundBuffer.nioBufferSize();
                    long l2 = socketChannel.write(byteBufferArray, 0, n3);
                    if (l2 <= 0L) {
                        this.incompleteWrite(true);
                        return;
                    }
                    this.adjustMaxBytesPerGatheringWrite((int)l, (int)l2, n2);
                    channelOutboundBuffer.removeBytes(l2);
                    --n;
                    break;
                }
            }
        } while (n > 0);
        this.incompleteWrite(n < 0);
    }

    @Override
    protected AbstractNioChannel$AbstractNioUnsafe newUnsafe() {
        return new NioDomainSocketChannel$NioSocketChannelUnsafe(this, null);
    }

    static /* synthetic */ void access$100(NioDomainSocketChannel nioDomainSocketChannel, ChannelPromise channelPromise) {
        nioDomainSocketChannel.shutdownInput0(channelPromise);
    }

    static /* synthetic */ void access$200(NioDomainSocketChannel nioDomainSocketChannel, ChannelFuture channelFuture, ChannelPromise channelPromise) {
        nioDomainSocketChannel.shutdownOutputDone(channelFuture, channelPromise);
    }

    static /* synthetic */ void access$300(ChannelFuture channelFuture, ChannelFuture channelFuture2, ChannelPromise channelPromise) {
        NioDomainSocketChannel.shutdownDone(channelFuture, channelFuture2, channelPromise);
    }

    static /* synthetic */ void access$500(NioDomainSocketChannel nioDomainSocketChannel) {
        nioDomainSocketChannel.clearReadPending();
    }
}

