/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.channel.socket.nio;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.SocketAddress;
import java.nio.file.Path;
import pro.gravit.repackage.io.netty.util.internal.SuppressJava6Requirement;

final class NioDomainSocketUtil {
    private static final Method OF_METHOD;
    private static final Method GET_PATH_METHOD;

    static SocketAddress newUnixDomainSocketAddress(String string) {
        if (OF_METHOD == null) {
            throw new IllegalStateException();
        }
        try {
            return (SocketAddress)OF_METHOD.invoke(null, string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IllegalStateException(invocationTargetException);
        }
    }

    @SuppressJava6Requirement(reason="Guarded by version check")
    static void deleteSocketFile(SocketAddress socketAddress) {
        if (GET_PATH_METHOD == null) {
            throw new IllegalStateException();
        }
        try {
            Path path = (Path)GET_PATH_METHOD.invoke((Object)socketAddress, new Object[0]);
            if (path != null) {
                path.toFile().delete();
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IllegalStateException(invocationTargetException);
        }
    }

    private NioDomainSocketUtil() {
    }

    static {
        Method method;
        Method method2;
        try {
            Class<?> clazz = Class.forName("java.net.UnixDomainSocketAddress");
            method2 = clazz.getMethod("of", String.class);
            method = clazz.getMethod("getPath", new Class[0]);
        }
        catch (Throwable throwable) {
            method2 = null;
            method = null;
        }
        OF_METHOD = method2;
        GET_PATH_METHOD = method;
    }
}

