/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.channel.socket.nio;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.List;
import pro.gravit.repackage.io.netty.channel.Channel;
import pro.gravit.repackage.io.netty.channel.ChannelException;
import pro.gravit.repackage.io.netty.channel.ChannelMetadata;
import pro.gravit.repackage.io.netty.channel.ChannelOutboundBuffer;
import pro.gravit.repackage.io.netty.channel.nio.AbstractNioMessageChannel;
import pro.gravit.repackage.io.netty.channel.socket.InternetProtocolFamily;
import pro.gravit.repackage.io.netty.channel.socket.ServerSocketChannel;
import pro.gravit.repackage.io.netty.channel.socket.ServerSocketChannelConfig;
import pro.gravit.repackage.io.netty.channel.socket.nio.NioServerSocketChannel$NioServerSocketChannelConfig;
import pro.gravit.repackage.io.netty.channel.socket.nio.NioSocketChannel;
import pro.gravit.repackage.io.netty.channel.socket.nio.SelectorProviderUtil;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;
import pro.gravit.repackage.io.netty.util.internal.SocketUtils;
import pro.gravit.repackage.io.netty.util.internal.SuppressJava6Requirement;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;

public class NioServerSocketChannel
extends AbstractNioMessageChannel
implements ServerSocketChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(false, 16);
    private static final SelectorProvider DEFAULT_SELECTOR_PROVIDER = SelectorProvider.provider();
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(NioServerSocketChannel.class);
    private static final Method OPEN_SERVER_SOCKET_CHANNEL_WITH_FAMILY = SelectorProviderUtil.findOpenMethod("openServerSocketChannel");
    private final ServerSocketChannelConfig config = new NioServerSocketChannel$NioServerSocketChannelConfig(this, this, this.javaChannel().socket(), null);

    private static java.nio.channels.ServerSocketChannel newChannel(SelectorProvider selectorProvider, InternetProtocolFamily internetProtocolFamily) {
        try {
            java.nio.channels.ServerSocketChannel serverSocketChannel = (java.nio.channels.ServerSocketChannel)SelectorProviderUtil.newChannel(OPEN_SERVER_SOCKET_CHANNEL_WITH_FAMILY, selectorProvider, internetProtocolFamily);
            return serverSocketChannel == null ? selectorProvider.openServerSocketChannel() : serverSocketChannel;
        }
        catch (IOException iOException) {
            throw new ChannelException("Failed to open a socket.", iOException);
        }
    }

    public NioServerSocketChannel() {
        this(DEFAULT_SELECTOR_PROVIDER);
    }

    public NioServerSocketChannel(SelectorProvider selectorProvider) {
        this(selectorProvider, null);
    }

    public NioServerSocketChannel(SelectorProvider selectorProvider, InternetProtocolFamily internetProtocolFamily) {
        this(NioServerSocketChannel.newChannel(selectorProvider, internetProtocolFamily));
    }

    public NioServerSocketChannel(java.nio.channels.ServerSocketChannel serverSocketChannel) {
        super(null, serverSocketChannel, 16);
    }

    @Override
    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    public ServerSocketChannelConfig config() {
        return this.config;
    }

    @Override
    public boolean isActive() {
        return this.isOpen() && this.javaChannel().socket().isBound();
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return null;
    }

    @Override
    protected java.nio.channels.ServerSocketChannel javaChannel() {
        return (java.nio.channels.ServerSocketChannel)super.javaChannel();
    }

    @Override
    protected SocketAddress localAddress0() {
        return SocketUtils.localSocketAddress(this.javaChannel().socket());
    }

    @Override
    @SuppressJava6Requirement(reason="Usage guarded by java version check")
    protected void doBind(SocketAddress socketAddress) {
        if (PlatformDependent.javaVersion() >= 7) {
            this.javaChannel().bind(socketAddress, this.config.getBacklog());
        } else {
            this.javaChannel().socket().bind(socketAddress, this.config.getBacklog());
        }
    }

    @Override
    protected void doClose() {
        this.javaChannel().close();
    }

    @Override
    protected int doReadMessages(List<Object> list) {
        SocketChannel socketChannel = SocketUtils.accept(this.javaChannel());
        try {
            if (socketChannel != null) {
                list.add(new NioSocketChannel((Channel)this, socketChannel));
                return 1;
            }
        }
        catch (Throwable throwable) {
            logger.warn("Failed to create a new channel from an accepted socket.", throwable);
            try {
                socketChannel.close();
            }
            catch (Throwable throwable2) {
                logger.warn("Failed to close a socket.", throwable2);
            }
        }
        return 0;
    }

    @Override
    protected boolean doConnect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void doFinishConnect() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected SocketAddress remoteAddress0() {
        return null;
    }

    @Override
    protected void doDisconnect() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean doWriteMessage(Object object, ChannelOutboundBuffer channelOutboundBuffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected final Object filterOutboundMessage(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean closeOnReadError(Throwable throwable) {
        return super.closeOnReadError(throwable);
    }

    static /* synthetic */ void access$100(NioServerSocketChannel nioServerSocketChannel) {
        nioServerSocketChannel.clearReadPending();
    }
}

