/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.channel.unix;

import java.nio.ByteBuffer;
import pro.gravit.repackage.io.netty.channel.unix.GenericUnixChannelOption;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

public final class RawUnixChannelOption
extends GenericUnixChannelOption<ByteBuffer> {
    private final int length;

    public RawUnixChannelOption(String string, int n, int n2, int n3) {
        super(string, n, n2);
        this.length = ObjectUtil.checkPositive(n3, "length");
    }

    public int length() {
        return this.length;
    }

    @Override
    public void validate(ByteBuffer byteBuffer) {
        super.validate(byteBuffer);
        if (byteBuffer.remaining() != this.length) {
            throw new IllegalArgumentException("Length of value does not match. Expected " + this.length + ", but got " + byteBuffer.remaining());
        }
    }
}

