/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec;

import java.util.List;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.buffer.ByteBufAllocator;
import pro.gravit.repackage.io.netty.buffer.Unpooled;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.channel.ChannelInboundHandlerAdapter;
import pro.gravit.repackage.io.netty.channel.socket.ChannelInputShutdownEvent;
import pro.gravit.repackage.io.netty.handler.codec.ByteToMessageDecoder$1;
import pro.gravit.repackage.io.netty.handler.codec.ByteToMessageDecoder$2;
import pro.gravit.repackage.io.netty.handler.codec.ByteToMessageDecoder$Cumulator;
import pro.gravit.repackage.io.netty.handler.codec.CodecOutputList;
import pro.gravit.repackage.io.netty.handler.codec.DecoderException;
import pro.gravit.repackage.io.netty.util.IllegalReferenceCountException;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;
import pro.gravit.repackage.io.netty.util.internal.StringUtil;

public abstract class ByteToMessageDecoder
extends ChannelInboundHandlerAdapter {
    public static final ByteToMessageDecoder$Cumulator MERGE_CUMULATOR = new ByteToMessageDecoder$1();
    public static final ByteToMessageDecoder$Cumulator COMPOSITE_CUMULATOR = new ByteToMessageDecoder$2();
    private static final byte STATE_INIT = 0;
    private static final byte STATE_CALLING_CHILD_DECODE = 1;
    private static final byte STATE_HANDLER_REMOVED_PENDING = 2;
    ByteBuf cumulation;
    private ByteToMessageDecoder$Cumulator cumulator = MERGE_CUMULATOR;
    private boolean singleDecode;
    private boolean first;
    private boolean firedChannelRead;
    private boolean selfFiredChannelRead;
    private byte decodeState = 0;
    private int discardAfterReads = 16;
    private int numReads;

    protected ByteToMessageDecoder() {
        this.ensureNotSharable();
    }

    public void setSingleDecode(boolean bl) {
        this.singleDecode = bl;
    }

    public boolean isSingleDecode() {
        return this.singleDecode;
    }

    public void setCumulator(ByteToMessageDecoder$Cumulator byteToMessageDecoder$Cumulator) {
        this.cumulator = ObjectUtil.checkNotNull(byteToMessageDecoder$Cumulator, "cumulator");
    }

    public void setDiscardAfterReads(int n) {
        ObjectUtil.checkPositive(n, "discardAfterReads");
        this.discardAfterReads = n;
    }

    protected int actualReadableBytes() {
        return this.internalBuffer().readableBytes();
    }

    protected ByteBuf internalBuffer() {
        if (this.cumulation != null) {
            return this.cumulation;
        }
        return Unpooled.EMPTY_BUFFER;
    }

    @Override
    public final void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        if (this.decodeState == 1) {
            this.decodeState = (byte)2;
            return;
        }
        ByteBuf byteBuf = this.cumulation;
        if (byteBuf != null) {
            this.cumulation = null;
            this.numReads = 0;
            int n = byteBuf.readableBytes();
            if (n > 0) {
                channelHandlerContext.fireChannelRead(byteBuf);
                channelHandlerContext.fireChannelReadComplete();
            } else {
                byteBuf.release();
            }
        }
        this.handlerRemoved0(channelHandlerContext);
    }

    protected void handlerRemoved0(ChannelHandlerContext channelHandlerContext) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        if (object instanceof ByteBuf) {
            this.selfFiredChannelRead = true;
            CodecOutputList codecOutputList = CodecOutputList.newInstance();
            try {
                this.first = this.cumulation == null;
                this.cumulation = this.cumulator.cumulate(channelHandlerContext.alloc(), this.first ? Unpooled.EMPTY_BUFFER : this.cumulation, (ByteBuf)object);
                this.callDecode(channelHandlerContext, this.cumulation, codecOutputList);
            }
            catch (DecoderException decoderException) {
                throw decoderException;
            }
            catch (Exception exception) {
                throw new DecoderException(exception);
            }
            finally {
                try {
                    if (this.cumulation != null && !this.cumulation.isReadable()) {
                        this.numReads = 0;
                        try {
                            this.cumulation.release();
                        }
                        catch (IllegalReferenceCountException illegalReferenceCountException) {
                            throw new IllegalReferenceCountException(this.getClass().getSimpleName() + "#decode() might have released its input buffer, or passed it down the pipeline without a retain() call, which is not allowed.", illegalReferenceCountException);
                        }
                        this.cumulation = null;
                    } else if (++this.numReads >= this.discardAfterReads) {
                        this.numReads = 0;
                        this.discardSomeReadBytes();
                    }
                    int n = codecOutputList.size();
                    this.firedChannelRead |= codecOutputList.insertSinceRecycled();
                    ByteToMessageDecoder.fireChannelRead(channelHandlerContext, codecOutputList, n);
                }
                finally {
                    codecOutputList.recycle();
                }
            }
        }
        channelHandlerContext.fireChannelRead(object);
    }

    static void fireChannelRead(ChannelHandlerContext channelHandlerContext, List<Object> list, int n) {
        if (list instanceof CodecOutputList) {
            ByteToMessageDecoder.fireChannelRead(channelHandlerContext, (CodecOutputList)list, n);
        } else {
            for (int i = 0; i < n; ++i) {
                channelHandlerContext.fireChannelRead(list.get(i));
            }
        }
    }

    static void fireChannelRead(ChannelHandlerContext channelHandlerContext, CodecOutputList codecOutputList, int n) {
        for (int i = 0; i < n; ++i) {
            channelHandlerContext.fireChannelRead(codecOutputList.getUnsafe(i));
        }
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) {
        this.numReads = 0;
        this.discardSomeReadBytes();
        if (this.selfFiredChannelRead && !this.firedChannelRead && !channelHandlerContext.channel().config().isAutoRead()) {
            channelHandlerContext.read();
        }
        this.firedChannelRead = false;
        this.selfFiredChannelRead = false;
        channelHandlerContext.fireChannelReadComplete();
    }

    protected final void discardSomeReadBytes() {
        if (this.cumulation != null && !this.first && this.cumulation.refCnt() == 1) {
            this.cumulation.discardSomeReadBytes();
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        this.channelInputClosed(channelHandlerContext, true);
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext channelHandlerContext, Object object) {
        if (object instanceof ChannelInputShutdownEvent) {
            this.channelInputClosed(channelHandlerContext, false);
        }
        super.userEventTriggered(channelHandlerContext, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void channelInputClosed(ChannelHandlerContext channelHandlerContext, boolean bl) {
        CodecOutputList codecOutputList = CodecOutputList.newInstance();
        try {
            this.channelInputClosed(channelHandlerContext, codecOutputList);
        }
        catch (DecoderException decoderException) {
            throw decoderException;
        }
        catch (Exception exception) {
            throw new DecoderException(exception);
        }
        finally {
            try {
                if (this.cumulation != null) {
                    this.cumulation.release();
                    this.cumulation = null;
                }
                int n = codecOutputList.size();
                ByteToMessageDecoder.fireChannelRead(channelHandlerContext, codecOutputList, n);
                if (n > 0) {
                    channelHandlerContext.fireChannelReadComplete();
                }
                if (bl) {
                    channelHandlerContext.fireChannelInactive();
                }
            }
            finally {
                codecOutputList.recycle();
            }
        }
    }

    void channelInputClosed(ChannelHandlerContext channelHandlerContext, List<Object> list) {
        if (this.cumulation != null) {
            this.callDecode(channelHandlerContext, this.cumulation, list);
            if (!channelHandlerContext.isRemoved()) {
                ByteBuf byteBuf = this.cumulation == null ? Unpooled.EMPTY_BUFFER : this.cumulation;
                this.decodeLast(channelHandlerContext, byteBuf, list);
            }
        } else {
            this.decodeLast(channelHandlerContext, Unpooled.EMPTY_BUFFER, list);
        }
    }

    protected void callDecode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        try {
            while (byteBuf.isReadable()) {
                int n = list.size();
                if (n > 0) {
                    ByteToMessageDecoder.fireChannelRead(channelHandlerContext, list, n);
                    list.clear();
                    if (channelHandlerContext.isRemoved()) break;
                }
                int n2 = byteBuf.readableBytes();
                this.decodeRemovalReentryProtection(channelHandlerContext, byteBuf, list);
                if (!channelHandlerContext.isRemoved()) {
                    if (list.isEmpty()) {
                        if (n2 != byteBuf.readableBytes()) continue;
                    } else {
                        if (n2 == byteBuf.readableBytes()) {
                            throw new DecoderException(StringUtil.simpleClassName(this.getClass()) + ".decode() did not read anything but decoded a message.");
                        }
                        if (!this.isSingleDecode()) continue;
                    }
                }
                break;
            }
        }
        catch (DecoderException decoderException) {
            throw decoderException;
        }
        catch (Exception exception) {
            throw new DecoderException(exception);
        }
    }

    protected abstract void decode(ChannelHandlerContext var1, ByteBuf var2, List<Object> var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void decodeRemovalReentryProtection(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        boolean bl;
        this.decodeState = 1;
        try {
            this.decode(channelHandlerContext, byteBuf, list);
            bl = this.decodeState == 2;
        }
        catch (Throwable throwable) {
            boolean bl2 = this.decodeState == 2;
            this.decodeState = 0;
            if (bl2) {
                ByteToMessageDecoder.fireChannelRead(channelHandlerContext, list, list.size());
                list.clear();
                this.handlerRemoved(channelHandlerContext);
            }
            throw throwable;
        }
        this.decodeState = 0;
        if (bl) {
            ByteToMessageDecoder.fireChannelRead(channelHandlerContext, list, list.size());
            list.clear();
            this.handlerRemoved(channelHandlerContext);
        }
    }

    protected void decodeLast(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        if (byteBuf.isReadable()) {
            this.decodeRemovalReentryProtection(channelHandlerContext, byteBuf, list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ByteBuf expandCumulation(ByteBufAllocator byteBufAllocator, ByteBuf byteBuf, ByteBuf byteBuf2) {
        ByteBuf byteBuf3;
        int n = byteBuf.readableBytes();
        int n2 = byteBuf2.readableBytes();
        int n3 = n + n2;
        ByteBuf byteBuf4 = byteBuf3 = byteBufAllocator.buffer(byteBufAllocator.calculateNewCapacity(n3, Integer.MAX_VALUE));
        try {
            byteBuf3.setBytes(0, byteBuf, byteBuf.readerIndex(), n).setBytes(n, byteBuf2, byteBuf2.readerIndex(), n2).writerIndex(n3);
            byteBuf2.readerIndex(byteBuf2.writerIndex());
            byteBuf4 = byteBuf;
            ByteBuf byteBuf5 = byteBuf3;
            return byteBuf5;
        }
        finally {
            byteBuf4.release();
        }
    }
}

