/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec;

import java.util.List;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.channel.ChannelInboundHandlerAdapter;
import pro.gravit.repackage.io.netty.handler.codec.CodecOutputList;
import pro.gravit.repackage.io.netty.handler.codec.DecoderException;
import pro.gravit.repackage.io.netty.util.ReferenceCountUtil;
import pro.gravit.repackage.io.netty.util.internal.TypeParameterMatcher;

public abstract class MessageToMessageDecoder<I>
extends ChannelInboundHandlerAdapter {
    private final TypeParameterMatcher matcher;
    private boolean decodeCalled;
    private boolean messageProduced;

    protected MessageToMessageDecoder() {
        this.matcher = TypeParameterMatcher.find(this, MessageToMessageDecoder.class, "I");
    }

    protected MessageToMessageDecoder(Class<? extends I> clazz) {
        this.matcher = TypeParameterMatcher.get(clazz);
    }

    public boolean acceptInboundMessage(Object object) {
        return this.matcher.match(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        CodecOutputList codecOutputList;
        block17: {
            this.decodeCalled = true;
            codecOutputList = CodecOutputList.newInstance();
            try {
                if (this.acceptInboundMessage(object)) {
                    Object object2 = object;
                    try {
                        this.decode(channelHandlerContext, object2, codecOutputList);
                        break block17;
                    }
                    finally {
                        ReferenceCountUtil.release(object2);
                    }
                }
                codecOutputList.add(object);
            }
            catch (DecoderException decoderException) {
                try {
                    throw decoderException;
                    catch (Exception exception) {
                        throw new DecoderException(exception);
                    }
                }
                catch (Throwable throwable) {
                    try {
                        int n = codecOutputList.size();
                        this.messageProduced |= n > 0;
                        for (int i = 0; i < n; ++i) {
                            channelHandlerContext.fireChannelRead(codecOutputList.getUnsafe(i));
                        }
                        throw throwable;
                    }
                    finally {
                        codecOutputList.recycle();
                    }
                }
            }
        }
        try {
            int n = codecOutputList.size();
            this.messageProduced |= n > 0;
            for (int i = 0; i < n; ++i) {
                channelHandlerContext.fireChannelRead(codecOutputList.getUnsafe(i));
            }
            return;
        }
        finally {
            codecOutputList.recycle();
        }
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) {
        if (!this.isSharable()) {
            if (this.decodeCalled && !this.messageProduced && !channelHandlerContext.channel().config().isAutoRead()) {
                channelHandlerContext.read();
            }
            this.decodeCalled = false;
            this.messageProduced = false;
        }
        channelHandlerContext.fireChannelReadComplete();
    }

    protected abstract void decode(ChannelHandlerContext var1, I var2, List<Object> var3);
}

