/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.compression;

import com.ning.compress.BufferRecycler;
import com.ning.compress.lzf.ChunkEncoder;
import com.ning.compress.lzf.LZFChunk;
import com.ning.compress.lzf.LZFEncoder;
import com.ning.compress.lzf.util.ChunkEncoderFactory;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.handler.codec.MessageToByteEncoder;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;

public class LzfEncoder
extends MessageToByteEncoder<ByteBuf> {
    private static final int MIN_BLOCK_TO_COMPRESS = 16;
    private static final boolean DEFAULT_SAFE = !PlatformDependent.hasUnsafe();
    private final int compressThreshold;
    private final ChunkEncoder encoder;
    private final BufferRecycler recycler;

    public LzfEncoder() {
        this(DEFAULT_SAFE);
    }

    @Deprecated
    public LzfEncoder(boolean bl) {
        this(bl, 65535);
    }

    @Deprecated
    public LzfEncoder(boolean bl, int n) {
        this(bl, n, 16);
    }

    public LzfEncoder(int n) {
        this(DEFAULT_SAFE, n);
    }

    public LzfEncoder(int n, int n2) {
        this(DEFAULT_SAFE, n, n2);
    }

    @Deprecated
    public LzfEncoder(boolean bl, int n, int n2) {
        super(false);
        if (n < 16 || n > 65535) {
            throw new IllegalArgumentException("totalLength: " + n + " (expected: " + 16 + '-' + 65535 + ')');
        }
        if (n2 < 16) {
            throw new IllegalArgumentException("compressThreshold:" + n2 + " expected >=" + 16);
        }
        this.compressThreshold = n2;
        this.encoder = bl ? ChunkEncoderFactory.safeNonAllocatingInstance((int)n) : ChunkEncoderFactory.optimalNonAllocatingInstance((int)n);
        this.recycler = BufferRecycler.instance();
    }

    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, ByteBuf byteBuf2) {
        int n;
        byte[] byArray;
        int n2;
        byte[] byArray2;
        int n3 = byteBuf.readableBytes();
        int n4 = byteBuf.readerIndex();
        if (byteBuf.hasArray()) {
            byArray2 = byteBuf.array();
            n2 = byteBuf.arrayOffset() + n4;
        } else {
            byArray2 = this.recycler.allocInputBuffer(n3);
            byteBuf.getBytes(n4, byArray2, 0, n3);
            n2 = 0;
        }
        int n5 = LZFEncoder.estimateMaxWorkspaceSize((int)n3) + 1;
        byteBuf2.ensureWritable(n5);
        if (byteBuf2.hasArray()) {
            byArray = byteBuf2.array();
            n = byteBuf2.arrayOffset() + byteBuf2.writerIndex();
        } else {
            byArray = new byte[n5];
            n = 0;
        }
        int n6 = n3 >= this.compressThreshold ? this.encodeCompress(byArray2, n2, n3, byArray, n) : LzfEncoder.encodeNonCompress(byArray2, n2, n3, byArray, n);
        if (byteBuf2.hasArray()) {
            byteBuf2.writerIndex(byteBuf2.writerIndex() + n6);
        } else {
            byteBuf2.writeBytes(byArray, 0, n6);
        }
        byteBuf.skipBytes(n3);
        if (!byteBuf.hasArray()) {
            this.recycler.releaseInputBuffer(byArray2);
        }
    }

    private int encodeCompress(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        return LZFEncoder.appendEncoded((ChunkEncoder)this.encoder, (byte[])byArray, (int)n, (int)n2, (byte[])byArray2, (int)n3) - n3;
    }

    private static int lzfEncodeNonCompress(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        int n4 = n2;
        int n5 = Math.min(65535, n4);
        n3 = LZFChunk.appendNonCompressed((byte[])byArray, (int)n, (int)n5, (byte[])byArray2, (int)n3);
        if ((n4 -= n5) < 1) {
            return n3;
        }
        n += n5;
        do {
            n5 = Math.min(n4, 65535);
            n3 = LZFChunk.appendNonCompressed((byte[])byArray, (int)n, (int)n5, (byte[])byArray2, (int)n3);
            n += n5;
        } while ((n4 -= n5) > 0);
        return n3;
    }

    private static int encodeNonCompress(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        return LzfEncoder.lzfEncodeNonCompress(byArray, n, n2, byArray2, n3) - n3;
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        this.encoder.close();
        super.handlerRemoved(channelHandlerContext);
    }
}

