/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.http;

import pro.gravit.repackage.io.netty.handler.codec.DefaultHeaders$NameValidator;
import pro.gravit.repackage.io.netty.handler.codec.DefaultHeaders$ValueValidator;
import pro.gravit.repackage.io.netty.handler.codec.http.CombinedHttpHeaders;
import pro.gravit.repackage.io.netty.handler.codec.http.DefaultHttpHeaders;
import pro.gravit.repackage.io.netty.handler.codec.http.DefaultHttpHeadersFactory$1;
import pro.gravit.repackage.io.netty.handler.codec.http.DefaultHttpHeadersFactory$2;
import pro.gravit.repackage.io.netty.handler.codec.http.DefaultHttpHeadersFactory$3;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpHeaders;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpHeadersFactory;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

public final class DefaultHttpHeadersFactory
implements HttpHeadersFactory {
    private static final DefaultHeaders$NameValidator<CharSequence> DEFAULT_NAME_VALIDATOR = new DefaultHttpHeadersFactory$1();
    private static final DefaultHeaders$ValueValidator<CharSequence> DEFAULT_VALUE_VALIDATOR = new DefaultHttpHeadersFactory$2();
    private static final DefaultHeaders$NameValidator<CharSequence> DEFAULT_TRAILER_NAME_VALIDATOR = new DefaultHttpHeadersFactory$3();
    private static final DefaultHeaders$NameValidator<CharSequence> NO_NAME_VALIDATOR = DefaultHeaders$NameValidator.NOT_NULL;
    private static final DefaultHeaders$ValueValidator<CharSequence> NO_VALUE_VALIDATOR = DefaultHeaders$ValueValidator.NO_VALIDATION;
    private static final DefaultHttpHeadersFactory DEFAULT = new DefaultHttpHeadersFactory(DEFAULT_NAME_VALIDATOR, DEFAULT_VALUE_VALIDATOR, false);
    private static final DefaultHttpHeadersFactory DEFAULT_TRAILER = new DefaultHttpHeadersFactory(DEFAULT_TRAILER_NAME_VALIDATOR, DEFAULT_VALUE_VALIDATOR, false);
    private static final DefaultHttpHeadersFactory DEFAULT_COMBINING = new DefaultHttpHeadersFactory(DefaultHttpHeadersFactory.DEFAULT.nameValidator, DefaultHttpHeadersFactory.DEFAULT.valueValidator, true);
    private static final DefaultHttpHeadersFactory DEFAULT_NO_VALIDATION = new DefaultHttpHeadersFactory(NO_NAME_VALIDATOR, NO_VALUE_VALIDATOR, false);
    private final DefaultHeaders$NameValidator<CharSequence> nameValidator;
    private final DefaultHeaders$ValueValidator<CharSequence> valueValidator;
    private final boolean combiningHeaders;

    private DefaultHttpHeadersFactory(DefaultHeaders$NameValidator<CharSequence> defaultHeaders$NameValidator, DefaultHeaders$ValueValidator<CharSequence> defaultHeaders$ValueValidator, boolean bl) {
        this.nameValidator = ObjectUtil.checkNotNull(defaultHeaders$NameValidator, "nameValidator");
        this.valueValidator = ObjectUtil.checkNotNull(defaultHeaders$ValueValidator, "valueValidator");
        this.combiningHeaders = bl;
    }

    public static DefaultHttpHeadersFactory headersFactory() {
        return DEFAULT;
    }

    public static DefaultHttpHeadersFactory trailersFactory() {
        return DEFAULT_TRAILER;
    }

    @Override
    public HttpHeaders newHeaders() {
        if (this.isCombiningHeaders()) {
            return new CombinedHttpHeaders(this.getNameValidator(), this.getValueValidator());
        }
        return new DefaultHttpHeaders(this.getNameValidator(), this.getValueValidator());
    }

    @Override
    public HttpHeaders newEmptyHeaders() {
        if (this.isCombiningHeaders()) {
            return new CombinedHttpHeaders(this.getNameValidator(), this.getValueValidator(), 2);
        }
        return new DefaultHttpHeaders(this.getNameValidator(), this.getValueValidator(), 2);
    }

    public DefaultHttpHeadersFactory withNameValidation(boolean bl) {
        return this.withNameValidator(bl ? DEFAULT_NAME_VALIDATOR : NO_NAME_VALIDATOR);
    }

    public DefaultHttpHeadersFactory withNameValidator(DefaultHeaders$NameValidator<CharSequence> defaultHeaders$NameValidator) {
        if (this.nameValidator == ObjectUtil.checkNotNull(defaultHeaders$NameValidator, "validator")) {
            return this;
        }
        if (defaultHeaders$NameValidator == DEFAULT_NAME_VALIDATOR && this.valueValidator == DEFAULT_VALUE_VALIDATOR) {
            return this.combiningHeaders ? DEFAULT_COMBINING : DEFAULT;
        }
        return new DefaultHttpHeadersFactory(defaultHeaders$NameValidator, this.valueValidator, this.combiningHeaders);
    }

    public DefaultHttpHeadersFactory withValueValidation(boolean bl) {
        return this.withValueValidator(bl ? DEFAULT_VALUE_VALIDATOR : NO_VALUE_VALIDATOR);
    }

    public DefaultHttpHeadersFactory withValueValidator(DefaultHeaders$ValueValidator<CharSequence> defaultHeaders$ValueValidator) {
        if (this.valueValidator == ObjectUtil.checkNotNull(defaultHeaders$ValueValidator, "validator")) {
            return this;
        }
        if (this.nameValidator == DEFAULT_NAME_VALIDATOR && defaultHeaders$ValueValidator == DEFAULT_VALUE_VALIDATOR) {
            return this.combiningHeaders ? DEFAULT_COMBINING : DEFAULT;
        }
        return new DefaultHttpHeadersFactory(this.nameValidator, defaultHeaders$ValueValidator, this.combiningHeaders);
    }

    public DefaultHttpHeadersFactory withValidation(boolean bl) {
        if (this == DEFAULT && !bl) {
            return DEFAULT_NO_VALIDATION;
        }
        if (this == DEFAULT_NO_VALIDATION && bl) {
            return DEFAULT;
        }
        return this.withNameValidation(bl).withValueValidation(bl);
    }

    public DefaultHttpHeadersFactory withCombiningHeaders(boolean bl) {
        if (this.combiningHeaders == bl) {
            return this;
        }
        return new DefaultHttpHeadersFactory(this.nameValidator, this.valueValidator, bl);
    }

    public DefaultHeaders$NameValidator<CharSequence> getNameValidator() {
        return this.nameValidator;
    }

    public DefaultHeaders$ValueValidator<CharSequence> getValueValidator() {
        return this.valueValidator;
    }

    public boolean isCombiningHeaders() {
        return this.combiningHeaders;
    }

    public boolean isValidatingHeaderNames() {
        return this.nameValidator != NO_NAME_VALIDATOR;
    }

    public boolean isValidatingHeaderValues() {
        return this.valueValidator != NO_VALUE_VALIDATOR;
    }

    static /* synthetic */ DefaultHeaders$NameValidator access$000() {
        return DEFAULT_NAME_VALIDATOR;
    }
}

