/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.http;

import pro.gravit.repackage.io.netty.handler.codec.http.HttpMethod$EnumNameMap;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpMethod$EnumNameMap$Node;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpUtil;
import pro.gravit.repackage.io.netty.util.AsciiString;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

public class HttpMethod
implements Comparable<HttpMethod> {
    public static final HttpMethod OPTIONS = new HttpMethod("OPTIONS");
    public static final HttpMethod GET = new HttpMethod("GET");
    public static final HttpMethod HEAD = new HttpMethod("HEAD");
    public static final HttpMethod POST = new HttpMethod("POST");
    public static final HttpMethod PUT = new HttpMethod("PUT");
    public static final HttpMethod PATCH = new HttpMethod("PATCH");
    public static final HttpMethod DELETE = new HttpMethod("DELETE");
    public static final HttpMethod TRACE = new HttpMethod("TRACE");
    public static final HttpMethod CONNECT = new HttpMethod("CONNECT");
    private static final HttpMethod$EnumNameMap<HttpMethod> methodMap = new HttpMethod$EnumNameMap(new HttpMethod$EnumNameMap$Node<HttpMethod>(OPTIONS.toString(), OPTIONS), new HttpMethod$EnumNameMap$Node<HttpMethod>(GET.toString(), GET), new HttpMethod$EnumNameMap$Node<HttpMethod>(HEAD.toString(), HEAD), new HttpMethod$EnumNameMap$Node<HttpMethod>(POST.toString(), POST), new HttpMethod$EnumNameMap$Node<HttpMethod>(PUT.toString(), PUT), new HttpMethod$EnumNameMap$Node<HttpMethod>(PATCH.toString(), PATCH), new HttpMethod$EnumNameMap$Node<HttpMethod>(DELETE.toString(), DELETE), new HttpMethod$EnumNameMap$Node<HttpMethod>(TRACE.toString(), TRACE), new HttpMethod$EnumNameMap$Node<HttpMethod>(CONNECT.toString(), CONNECT));
    private final AsciiString name;

    public static HttpMethod valueOf(String string) {
        if (string == GET.name()) {
            return GET;
        }
        if (string == POST.name()) {
            return POST;
        }
        HttpMethod httpMethod = methodMap.get(string);
        return httpMethod != null ? httpMethod : new HttpMethod(string);
    }

    public HttpMethod(String string) {
        string = ObjectUtil.checkNonEmptyAfterTrim(string, "name");
        int n = HttpUtil.validateToken(string);
        if (n != -1) {
            throw new IllegalArgumentException("Illegal character in HTTP Method: 0x" + Integer.toHexString(string.charAt(n)));
        }
        this.name = AsciiString.cached(string);
    }

    public String name() {
        return this.name.toString();
    }

    public AsciiString asciiName() {
        return this.name;
    }

    public int hashCode() {
        return this.name().hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof HttpMethod)) {
            return false;
        }
        HttpMethod httpMethod = (HttpMethod)object;
        return this.name().equals(httpMethod.name());
    }

    public String toString() {
        return this.name.toString();
    }

    @Override
    public int compareTo(HttpMethod httpMethod) {
        if (httpMethod == this) {
            return 0;
        }
        return this.name().compareTo(httpMethod.name());
    }
}

