/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.http;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import pro.gravit.repackage.io.netty.handler.codec.CharSequenceValueConverter;
import pro.gravit.repackage.io.netty.handler.codec.http.DefaultHttpHeadersFactory;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpHeaders;
import pro.gravit.repackage.io.netty.handler.codec.http.ReadOnlyHttpHeaders$ReadOnlyIterator;
import pro.gravit.repackage.io.netty.handler.codec.http.ReadOnlyHttpHeaders$ReadOnlyStringIterator;
import pro.gravit.repackage.io.netty.handler.codec.http.ReadOnlyHttpHeaders$ReadOnlyStringValueIterator;
import pro.gravit.repackage.io.netty.handler.codec.http.ReadOnlyHttpHeaders$ReadOnlyValueIterator;
import pro.gravit.repackage.io.netty.util.AsciiString;

public final class ReadOnlyHttpHeaders
extends HttpHeaders {
    private final CharSequence[] nameValuePairs;

    public ReadOnlyHttpHeaders(boolean bl, CharSequence ... charSequenceArray) {
        if ((charSequenceArray.length & 1) != 0) {
            throw ReadOnlyHttpHeaders.newInvalidArraySizeException();
        }
        if (bl) {
            ReadOnlyHttpHeaders.validateHeaders(charSequenceArray);
        }
        this.nameValuePairs = charSequenceArray;
    }

    private static IllegalArgumentException newInvalidArraySizeException() {
        return new IllegalArgumentException("nameValuePairs must be arrays of [name, value] pairs");
    }

    private static void validateHeaders(CharSequence ... charSequenceArray) {
        for (int i = 0; i < charSequenceArray.length; i += 2) {
            DefaultHttpHeadersFactory.headersFactory().getNameValidator().validateName(charSequenceArray[i]);
        }
    }

    private CharSequence get0(CharSequence charSequence) {
        int n = AsciiString.hashCode(charSequence);
        for (int i = 0; i < this.nameValuePairs.length; i += 2) {
            CharSequence charSequence2 = this.nameValuePairs[i];
            if (AsciiString.hashCode(charSequence2) != n || !AsciiString.contentEqualsIgnoreCase(charSequence2, charSequence)) continue;
            return this.nameValuePairs[i + 1];
        }
        return null;
    }

    @Override
    public String get(String string) {
        CharSequence charSequence = this.get0(string);
        return charSequence == null ? null : charSequence.toString();
    }

    @Override
    public Integer getInt(CharSequence charSequence) {
        CharSequence charSequence2 = this.get0(charSequence);
        return charSequence2 == null ? null : Integer.valueOf(CharSequenceValueConverter.INSTANCE.convertToInt(charSequence2));
    }

    @Override
    public int getInt(CharSequence charSequence, int n) {
        CharSequence charSequence2 = this.get0(charSequence);
        return charSequence2 == null ? n : CharSequenceValueConverter.INSTANCE.convertToInt(charSequence2);
    }

    @Override
    public Short getShort(CharSequence charSequence) {
        CharSequence charSequence2 = this.get0(charSequence);
        return charSequence2 == null ? null : Short.valueOf(CharSequenceValueConverter.INSTANCE.convertToShort(charSequence2));
    }

    @Override
    public short getShort(CharSequence charSequence, short s) {
        CharSequence charSequence2 = this.get0(charSequence);
        return charSequence2 == null ? s : CharSequenceValueConverter.INSTANCE.convertToShort(charSequence2);
    }

    @Override
    public Long getTimeMillis(CharSequence charSequence) {
        CharSequence charSequence2 = this.get0(charSequence);
        return charSequence2 == null ? null : Long.valueOf(CharSequenceValueConverter.INSTANCE.convertToTimeMillis(charSequence2));
    }

    @Override
    public long getTimeMillis(CharSequence charSequence, long l) {
        CharSequence charSequence2 = this.get0(charSequence);
        return charSequence2 == null ? l : CharSequenceValueConverter.INSTANCE.convertToTimeMillis(charSequence2);
    }

    @Override
    public List<String> getAll(String string) {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        int n = AsciiString.hashCode(string);
        ArrayList<String> arrayList = new ArrayList<String>(4);
        for (int i = 0; i < this.nameValuePairs.length; i += 2) {
            CharSequence charSequence = this.nameValuePairs[i];
            if (AsciiString.hashCode(charSequence) != n || !AsciiString.contentEqualsIgnoreCase(charSequence, string)) continue;
            arrayList.add(this.nameValuePairs[i + 1].toString());
        }
        return arrayList;
    }

    @Override
    public List<Map.Entry<String, String>> entries() {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Map.Entry<String, String>> arrayList = new ArrayList<Map.Entry<String, String>>(this.size());
        for (int i = 0; i < this.nameValuePairs.length; i += 2) {
            arrayList.add(new AbstractMap.SimpleImmutableEntry<String, String>(this.nameValuePairs[i].toString(), this.nameValuePairs[i + 1].toString()));
        }
        return arrayList;
    }

    @Override
    public boolean contains(String string) {
        return this.get0(string) != null;
    }

    @Override
    public boolean contains(String string, String string2, boolean bl) {
        return this.containsValue(string, string2, bl);
    }

    @Override
    public boolean containsValue(CharSequence charSequence, CharSequence charSequence2, boolean bl) {
        if (bl) {
            for (int i = 0; i < this.nameValuePairs.length; i += 2) {
                if (!AsciiString.contentEqualsIgnoreCase(this.nameValuePairs[i], charSequence) || !AsciiString.contentEqualsIgnoreCase(this.nameValuePairs[i + 1], charSequence2)) continue;
                return true;
            }
        } else {
            for (int i = 0; i < this.nameValuePairs.length; i += 2) {
                if (!AsciiString.contentEqualsIgnoreCase(this.nameValuePairs[i], charSequence) || !AsciiString.contentEquals(this.nameValuePairs[i + 1], charSequence2)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<String> valueStringIterator(CharSequence charSequence) {
        return new ReadOnlyHttpHeaders$ReadOnlyStringValueIterator(this, charSequence);
    }

    public Iterator<CharSequence> valueCharSequenceIterator(CharSequence charSequence) {
        return new ReadOnlyHttpHeaders$ReadOnlyValueIterator(this, charSequence);
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        return new ReadOnlyHttpHeaders$ReadOnlyStringIterator(this);
    }

    @Override
    public Iterator<Map.Entry<CharSequence, CharSequence>> iteratorCharSequence() {
        return new ReadOnlyHttpHeaders$ReadOnlyIterator(this, null);
    }

    @Override
    public boolean isEmpty() {
        return this.nameValuePairs.length == 0;
    }

    @Override
    public int size() {
        return this.nameValuePairs.length >>> 1;
    }

    @Override
    public Set<String> names() {
        if (this.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(this.size());
        for (int i = 0; i < this.nameValuePairs.length; i += 2) {
            linkedHashSet.add(this.nameValuePairs[i].toString());
        }
        return linkedHashSet;
    }

    @Override
    public HttpHeaders add(String string, Object object) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public HttpHeaders add(String string, Iterable<?> iterable) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public HttpHeaders addInt(CharSequence charSequence, int n) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public HttpHeaders addShort(CharSequence charSequence, short s) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public HttpHeaders set(String string, Object object) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public HttpHeaders set(String string, Iterable<?> iterable) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public HttpHeaders setInt(CharSequence charSequence, int n) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public HttpHeaders setShort(CharSequence charSequence, short s) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public HttpHeaders remove(String string) {
        throw new UnsupportedOperationException("read only");
    }

    @Override
    public HttpHeaders clear() {
        throw new UnsupportedOperationException("read only");
    }

    static /* synthetic */ CharSequence[] access$200(ReadOnlyHttpHeaders readOnlyHttpHeaders) {
        return readOnlyHttpHeaders.nameValuePairs;
    }
}

