/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.http.websocketx;

import java.util.List;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.buffer.ByteBufUtil;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.handler.codec.ReplayingDecoder;
import pro.gravit.repackage.io.netty.handler.codec.TooLongFrameException;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketDecoderConfig;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

public class WebSocket00FrameDecoder
extends ReplayingDecoder<Void>
implements WebSocketFrameDecoder {
    static final int DEFAULT_MAX_FRAME_SIZE = 16384;
    private final long maxFrameSize;
    private boolean receivedClosingHandshake;

    public WebSocket00FrameDecoder() {
        this(16384);
    }

    public WebSocket00FrameDecoder(int n) {
        this.maxFrameSize = n;
    }

    public WebSocket00FrameDecoder(WebSocketDecoderConfig webSocketDecoderConfig) {
        this.maxFrameSize = ObjectUtil.checkNotNull(webSocketDecoderConfig, "decoderConfig").maxFramePayloadLength();
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        if (this.receivedClosingHandshake) {
            byteBuf.skipBytes(this.actualReadableBytes());
            return;
        }
        byte by = byteBuf.readByte();
        WebSocketFrame webSocketFrame = (by & 0x80) == 128 ? this.decodeBinaryFrame(channelHandlerContext, by, byteBuf) : this.decodeTextFrame(channelHandlerContext, byteBuf);
        if (webSocketFrame != null) {
            list.add(webSocketFrame);
        }
    }

    private WebSocketFrame decodeBinaryFrame(ChannelHandlerContext channelHandlerContext, byte by, ByteBuf byteBuf) {
        byte by2;
        long l = 0L;
        int n = 0;
        do {
            by2 = byteBuf.readByte();
            l <<= 7;
            if ((l |= (long)(by2 & 0x7F)) > this.maxFrameSize) {
                throw new TooLongFrameException("frame length exceeds " + this.maxFrameSize + ": " + l);
            }
            if (++n <= 8) continue;
            throw new TooLongFrameException("frame length field size exceeds 8: " + n);
        } while ((by2 & 0x80) == 128);
        if (by == -1 && l == 0L) {
            this.receivedClosingHandshake = true;
            return new CloseWebSocketFrame(true, 0, channelHandlerContext.alloc().buffer(0));
        }
        ByteBuf byteBuf2 = ByteBufUtil.readBytes(channelHandlerContext.alloc(), byteBuf, (int)l);
        return new BinaryWebSocketFrame(byteBuf2);
    }

    private WebSocketFrame decodeTextFrame(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) {
        int n;
        int n2 = byteBuf.readerIndex();
        int n3 = byteBuf.indexOf(n2, n2 + (n = this.actualReadableBytes()), (byte)-1);
        if (n3 == -1) {
            if ((long)n > this.maxFrameSize) {
                throw new TooLongFrameException("frame length exceeds " + this.maxFrameSize + ": " + n);
            }
            return null;
        }
        int n4 = n3 - n2;
        if ((long)n4 > this.maxFrameSize) {
            throw new TooLongFrameException("frame length exceeds " + this.maxFrameSize + ": " + n4);
        }
        ByteBuf byteBuf2 = ByteBufUtil.readBytes(channelHandlerContext.alloc(), byteBuf, n4);
        byteBuf.skipBytes(1);
        int n5 = byteBuf2.indexOf(byteBuf2.readerIndex(), byteBuf2.writerIndex(), (byte)-1);
        if (n5 >= 0) {
            byteBuf2.release();
            throw new IllegalArgumentException("a text frame should not contain 0xFF.");
        }
        return new TextWebSocketFrame(byteBuf2);
    }
}

