/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.spdy;

import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.buffer.Unpooled;
import pro.gravit.repackage.io.netty.handler.codec.spdy.SpdyCodecUtil;
import pro.gravit.repackage.io.netty.handler.codec.spdy.SpdyFrameDecoder$State;
import pro.gravit.repackage.io.netty.handler.codec.spdy.SpdyFrameDecoderDelegate;
import pro.gravit.repackage.io.netty.handler.codec.spdy.SpdyFrameDecoderExtendedDelegate;
import pro.gravit.repackage.io.netty.handler.codec.spdy.SpdyVersion;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

public class SpdyFrameDecoder {
    protected final SpdyFrameDecoderDelegate delegate;
    protected final int spdyVersion;
    private final int maxChunkSize;
    private int frameType;
    private SpdyFrameDecoder$State state;
    private byte flags;
    private int length;
    private int streamId;
    private int numSettings;

    public SpdyFrameDecoder(SpdyVersion spdyVersion, SpdyFrameDecoderDelegate spdyFrameDecoderDelegate) {
        this(spdyVersion, spdyFrameDecoderDelegate, 8192);
    }

    public SpdyFrameDecoder(SpdyVersion spdyVersion, SpdyFrameDecoderDelegate spdyFrameDecoderDelegate, int n) {
        this.spdyVersion = ObjectUtil.checkNotNull(spdyVersion, "spdyVersion").version();
        this.delegate = ObjectUtil.checkNotNull(spdyFrameDecoderDelegate, "delegate");
        this.maxChunkSize = ObjectUtil.checkPositive(n, "maxChunkSize");
        this.state = SpdyFrameDecoder$State.READ_COMMON_HEADER;
    }

    public void decode(ByteBuf byteBuf) {
        block17: while (true) {
            switch (this.state) {
                case READ_COMMON_HEADER: {
                    int n;
                    boolean bl;
                    if (byteBuf.readableBytes() < 8) {
                        return;
                    }
                    int n2 = byteBuf.readerIndex();
                    int n3 = n2 + 4;
                    int n4 = n2 + 5;
                    byteBuf.skipBytes(8);
                    boolean bl2 = bl = (byteBuf.getByte(n2) & 0x80) != 0;
                    if (bl) {
                        n = SpdyCodecUtil.getUnsignedShort(byteBuf, n2) & Short.MAX_VALUE;
                        this.frameType = SpdyCodecUtil.getUnsignedShort(byteBuf, n2 + 2);
                        this.streamId = 0;
                    } else {
                        n = this.spdyVersion;
                        this.frameType = 0;
                        this.streamId = SpdyCodecUtil.getUnsignedInt(byteBuf, n2);
                    }
                    this.flags = byteBuf.getByte(n3);
                    this.length = SpdyCodecUtil.getUnsignedMedium(byteBuf, n4);
                    if (n != this.spdyVersion) {
                        this.state = SpdyFrameDecoder$State.FRAME_ERROR;
                        this.delegate.readFrameError("Invalid SPDY Version");
                        continue block17;
                    }
                    if (!SpdyFrameDecoder.isValidFrameHeader(this.streamId, this.frameType, this.flags, this.length)) {
                        this.state = SpdyFrameDecoder$State.FRAME_ERROR;
                        this.delegate.readFrameError("Invalid Frame Error");
                        continue block17;
                    }
                    if (this.isValidUnknownFrameHeader(this.streamId, this.frameType, this.flags, this.length)) {
                        this.state = SpdyFrameDecoder$State.READ_UNKNOWN_FRAME;
                        continue block17;
                    }
                    this.state = SpdyFrameDecoder.getNextState(this.frameType, this.length);
                    continue block17;
                }
                case READ_DATA_FRAME: {
                    if (this.length == 0) {
                        this.state = SpdyFrameDecoder$State.READ_COMMON_HEADER;
                        this.delegate.readDataFrame(this.streamId, SpdyFrameDecoder.hasFlag(this.flags, (byte)1), Unpooled.buffer(0));
                        continue block17;
                    }
                    int n = Math.min(this.maxChunkSize, this.length);
                    if (byteBuf.readableBytes() < n) {
                        return;
                    }
                    ByteBuf byteBuf2 = byteBuf.readRetainedSlice(n);
                    this.length -= n;
                    if (this.length == 0) {
                        this.state = SpdyFrameDecoder$State.READ_COMMON_HEADER;
                    }
                    boolean bl = this.length == 0 && SpdyFrameDecoder.hasFlag(this.flags, (byte)1);
                    this.delegate.readDataFrame(this.streamId, bl, byteBuf2);
                    continue block17;
                }
                case READ_SYN_STREAM_FRAME: {
                    if (byteBuf.readableBytes() < 10) {
                        return;
                    }
                    int n = byteBuf.readerIndex();
                    this.streamId = SpdyCodecUtil.getUnsignedInt(byteBuf, n);
                    int n5 = SpdyCodecUtil.getUnsignedInt(byteBuf, n + 4);
                    byte by = (byte)(byteBuf.getByte(n + 8) >> 5 & 7);
                    boolean bl = SpdyFrameDecoder.hasFlag(this.flags, (byte)1);
                    boolean bl3 = SpdyFrameDecoder.hasFlag(this.flags, (byte)2);
                    byteBuf.skipBytes(10);
                    this.length -= 10;
                    if (this.streamId == 0) {
                        this.state = SpdyFrameDecoder$State.FRAME_ERROR;
                        this.delegate.readFrameError("Invalid SYN_STREAM Frame");
                        continue block17;
                    }
                    this.state = SpdyFrameDecoder$State.READ_HEADER_BLOCK;
                    this.delegate.readSynStreamFrame(this.streamId, n5, by, bl, bl3);
                    continue block17;
                }
                case READ_SYN_REPLY_FRAME: {
                    if (byteBuf.readableBytes() < 4) {
                        return;
                    }
                    this.streamId = SpdyCodecUtil.getUnsignedInt(byteBuf, byteBuf.readerIndex());
                    boolean bl = SpdyFrameDecoder.hasFlag(this.flags, (byte)1);
                    byteBuf.skipBytes(4);
                    this.length -= 4;
                    if (this.streamId == 0) {
                        this.state = SpdyFrameDecoder$State.FRAME_ERROR;
                        this.delegate.readFrameError("Invalid SYN_REPLY Frame");
                        continue block17;
                    }
                    this.state = SpdyFrameDecoder$State.READ_HEADER_BLOCK;
                    this.delegate.readSynReplyFrame(this.streamId, bl);
                    continue block17;
                }
                case READ_RST_STREAM_FRAME: {
                    if (byteBuf.readableBytes() < 8) {
                        return;
                    }
                    this.streamId = SpdyCodecUtil.getUnsignedInt(byteBuf, byteBuf.readerIndex());
                    int n7 = SpdyCodecUtil.getSignedInt(byteBuf, byteBuf.readerIndex() + 4);
                    byteBuf.skipBytes(8);
                    if (this.streamId == 0 || n7 == 0) {
                        this.state = SpdyFrameDecoder$State.FRAME_ERROR;
                        this.delegate.readFrameError("Invalid RST_STREAM Frame");
                        continue block17;
                    }
                    this.state = SpdyFrameDecoder$State.READ_COMMON_HEADER;
                    this.delegate.readRstStreamFrame(this.streamId, n7);
                    continue block17;
                }
                case READ_SETTINGS_FRAME: {
                    if (byteBuf.readableBytes() < 4) {
                        return;
                    }
                    boolean bl = SpdyFrameDecoder.hasFlag(this.flags, (byte)1);
                    this.numSettings = SpdyCodecUtil.getUnsignedInt(byteBuf, byteBuf.readerIndex());
                    byteBuf.skipBytes(4);
                    this.length -= 4;
                    if ((this.length & 7) != 0 || this.length >> 3 != this.numSettings) {
                        this.state = SpdyFrameDecoder$State.FRAME_ERROR;
                        this.delegate.readFrameError("Invalid SETTINGS Frame");
                        continue block17;
                    }
                    this.state = SpdyFrameDecoder$State.READ_SETTING;
                    this.delegate.readSettingsFrame(bl);
                    continue block17;
                }
                case READ_SETTING: {
                    if (this.numSettings == 0) {
                        this.state = SpdyFrameDecoder$State.READ_COMMON_HEADER;
                        this.delegate.readSettingsEnd();
                        continue block17;
                    }
                    if (byteBuf.readableBytes() < 8) {
                        return;
                    }
                    byte by = byteBuf.getByte(byteBuf.readerIndex());
                    int n = SpdyCodecUtil.getUnsignedMedium(byteBuf, byteBuf.readerIndex() + 1);
                    int n6 = SpdyCodecUtil.getSignedInt(byteBuf, byteBuf.readerIndex() + 4);
                    boolean bl = SpdyFrameDecoder.hasFlag(by, (byte)1);
                    boolean bl4 = SpdyFrameDecoder.hasFlag(by, (byte)2);
                    byteBuf.skipBytes(8);
                    --this.numSettings;
                    this.delegate.readSetting(n, n6, bl, bl4);
                    continue block17;
                }
                case READ_PING_FRAME: {
                    if (byteBuf.readableBytes() < 4) {
                        return;
                    }
                    int n = SpdyCodecUtil.getSignedInt(byteBuf, byteBuf.readerIndex());
                    byteBuf.skipBytes(4);
                    this.state = SpdyFrameDecoder$State.READ_COMMON_HEADER;
                    this.delegate.readPingFrame(n);
                    continue block17;
                }
                case READ_GOAWAY_FRAME: {
                    if (byteBuf.readableBytes() < 8) {
                        return;
                    }
                    int n = SpdyCodecUtil.getUnsignedInt(byteBuf, byteBuf.readerIndex());
                    int n7 = SpdyCodecUtil.getSignedInt(byteBuf, byteBuf.readerIndex() + 4);
                    byteBuf.skipBytes(8);
                    this.state = SpdyFrameDecoder$State.READ_COMMON_HEADER;
                    this.delegate.readGoAwayFrame(n, n7);
                    continue block17;
                }
                case READ_HEADERS_FRAME: {
                    if (byteBuf.readableBytes() < 4) {
                        return;
                    }
                    this.streamId = SpdyCodecUtil.getUnsignedInt(byteBuf, byteBuf.readerIndex());
                    boolean bl = SpdyFrameDecoder.hasFlag(this.flags, (byte)1);
                    byteBuf.skipBytes(4);
                    this.length -= 4;
                    if (this.streamId == 0) {
                        this.state = SpdyFrameDecoder$State.FRAME_ERROR;
                        this.delegate.readFrameError("Invalid HEADERS Frame");
                        continue block17;
                    }
                    this.state = SpdyFrameDecoder$State.READ_HEADER_BLOCK;
                    this.delegate.readHeadersFrame(this.streamId, bl);
                    continue block17;
                }
                case READ_WINDOW_UPDATE_FRAME: {
                    if (byteBuf.readableBytes() < 8) {
                        return;
                    }
                    this.streamId = SpdyCodecUtil.getUnsignedInt(byteBuf, byteBuf.readerIndex());
                    int n = SpdyCodecUtil.getUnsignedInt(byteBuf, byteBuf.readerIndex() + 4);
                    byteBuf.skipBytes(8);
                    if (n == 0) {
                        this.state = SpdyFrameDecoder$State.FRAME_ERROR;
                        this.delegate.readFrameError("Invalid WINDOW_UPDATE Frame");
                        continue block17;
                    }
                    this.state = SpdyFrameDecoder$State.READ_COMMON_HEADER;
                    this.delegate.readWindowUpdateFrame(this.streamId, n);
                    continue block17;
                }
                case READ_UNKNOWN_FRAME: {
                    if (this.decodeUnknownFrame(this.frameType, this.flags, this.length, byteBuf)) {
                        this.state = SpdyFrameDecoder$State.READ_COMMON_HEADER;
                        continue block17;
                    }
                    return;
                }
                case READ_HEADER_BLOCK: {
                    if (this.length == 0) {
                        this.state = SpdyFrameDecoder$State.READ_COMMON_HEADER;
                        this.delegate.readHeaderBlockEnd();
                        continue block17;
                    }
                    if (!byteBuf.isReadable()) {
                        return;
                    }
                    int n = Math.min(byteBuf.readableBytes(), this.length);
                    ByteBuf byteBuf3 = byteBuf.readRetainedSlice(n);
                    this.length -= n;
                    this.delegate.readHeaderBlock(byteBuf3);
                    continue block17;
                }
                case DISCARD_FRAME: {
                    int n = Math.min(byteBuf.readableBytes(), this.length);
                    byteBuf.skipBytes(n);
                    this.length -= n;
                    if (this.length == 0) {
                        this.state = SpdyFrameDecoder$State.READ_COMMON_HEADER;
                        continue block17;
                    }
                    return;
                }
                case FRAME_ERROR: {
                    byteBuf.skipBytes(byteBuf.readableBytes());
                    return;
                }
            }
            break;
        }
        throw new Error("Shouldn't reach here.");
    }

    private static boolean hasFlag(byte by, byte by2) {
        return (by & by2) != 0;
    }

    private static SpdyFrameDecoder$State getNextState(int n, int n2) {
        switch (n) {
            case 0: {
                return SpdyFrameDecoder$State.READ_DATA_FRAME;
            }
            case 1: {
                return SpdyFrameDecoder$State.READ_SYN_STREAM_FRAME;
            }
            case 2: {
                return SpdyFrameDecoder$State.READ_SYN_REPLY_FRAME;
            }
            case 3: {
                return SpdyFrameDecoder$State.READ_RST_STREAM_FRAME;
            }
            case 4: {
                return SpdyFrameDecoder$State.READ_SETTINGS_FRAME;
            }
            case 6: {
                return SpdyFrameDecoder$State.READ_PING_FRAME;
            }
            case 7: {
                return SpdyFrameDecoder$State.READ_GOAWAY_FRAME;
            }
            case 8: {
                return SpdyFrameDecoder$State.READ_HEADERS_FRAME;
            }
            case 9: {
                return SpdyFrameDecoder$State.READ_WINDOW_UPDATE_FRAME;
            }
        }
        if (n2 != 0) {
            return SpdyFrameDecoder$State.DISCARD_FRAME;
        }
        return SpdyFrameDecoder$State.READ_COMMON_HEADER;
    }

    protected boolean decodeUnknownFrame(int n, byte by, int n2, ByteBuf byteBuf) {
        if (n2 == 0) {
            if (this.delegate instanceof SpdyFrameDecoderExtendedDelegate) {
                ((SpdyFrameDecoderExtendedDelegate)this.delegate).readUnknownFrame(n, by, Unpooled.EMPTY_BUFFER);
            }
            return true;
        }
        if (byteBuf.readableBytes() < n2) {
            return false;
        }
        if (this.delegate instanceof SpdyFrameDecoderExtendedDelegate) {
            ByteBuf byteBuf2 = byteBuf.readRetainedSlice(n2);
            ((SpdyFrameDecoderExtendedDelegate)this.delegate).readUnknownFrame(n, by, byteBuf2);
        } else {
            byteBuf.skipBytes(n2);
        }
        return true;
    }

    protected boolean isValidUnknownFrameHeader(int n, int n2, byte by, int n3) {
        return false;
    }

    private static boolean isValidFrameHeader(int n, int n2, byte by, int n3) {
        switch (n2) {
            case 0: {
                return n != 0;
            }
            case 1: {
                return n3 >= 10;
            }
            case 2: {
                return n3 >= 4;
            }
            case 3: {
                return by == 0 && n3 == 8;
            }
            case 4: {
                return n3 >= 4;
            }
            case 6: {
                return n3 == 4;
            }
            case 7: {
                return n3 == 8;
            }
            case 8: {
                return n3 >= 4;
            }
            case 9: {
                return n3 == 8;
            }
        }
        return true;
    }
}

