/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.ssl;

import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509KeyManager;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslCachingKeyMaterialProvider;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslCachingX509KeyManagerFactory$1;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslKeyMaterialProvider;
import pro.gravit.repackage.io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

public final class OpenSslCachingX509KeyManagerFactory
extends KeyManagerFactory {
    private final int maxCachedEntries;

    public OpenSslCachingX509KeyManagerFactory(KeyManagerFactory keyManagerFactory) {
        this(keyManagerFactory, 1024);
    }

    public OpenSslCachingX509KeyManagerFactory(KeyManagerFactory keyManagerFactory, int n) {
        super(new OpenSslCachingX509KeyManagerFactory$1(keyManagerFactory), keyManagerFactory.getProvider(), keyManagerFactory.getAlgorithm());
        this.maxCachedEntries = ObjectUtil.checkPositive(n, "maxCachedEntries");
    }

    OpenSslKeyMaterialProvider newProvider(String string) {
        X509KeyManager x509KeyManager = ReferenceCountedOpenSslContext.chooseX509KeyManager(this.getKeyManagers());
        if ("sun.security.ssl.X509KeyManagerImpl".equals(x509KeyManager.getClass().getName())) {
            return new OpenSslKeyMaterialProvider(x509KeyManager, string);
        }
        return new OpenSslCachingKeyMaterialProvider(ReferenceCountedOpenSslContext.chooseX509KeyManager(this.getKeyManagers()), string, this.maxCachedEntries);
    }
}

