/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.ssl;

import java.io.Serializable;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.buffer.ByteBufAllocator;
import pro.gravit.repackage.io.netty.handler.ssl.ApplicationProtocolConfig;
import pro.gravit.repackage.io.netty.handler.ssl.ApplicationProtocolConfig$SelectorFailureBehavior;
import pro.gravit.repackage.io.netty.handler.ssl.ApplicationProtocolNegotiator;
import pro.gravit.repackage.io.netty.handler.ssl.CipherSuiteConverter;
import pro.gravit.repackage.io.netty.handler.ssl.CipherSuiteFilter;
import pro.gravit.repackage.io.netty.handler.ssl.ClientAuth;
import pro.gravit.repackage.io.netty.handler.ssl.EnhancingX509ExtendedTrustManager;
import pro.gravit.repackage.io.netty.handler.ssl.GroupsConverter;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSsl;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslApplicationProtocolNegotiator;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslAsyncPrivateKeyMethod;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslCachingX509KeyManagerFactory;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslCertificateCompressionConfig;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslCertificateCompressionConfig$AlgorithmConfig;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslContextOption;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslDefaultApplicationProtocolNegotiator;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslEngineMap;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslKeyMaterialProvider;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslPrivateKeyMethod;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslSessionContext;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslSessionStats;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslX509KeyManagerFactory;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslX509TrustManagerWrapper;
import pro.gravit.repackage.io.netty.handler.ssl.PemEncoded;
import pro.gravit.repackage.io.netty.handler.ssl.PemPrivateKey;
import pro.gravit.repackage.io.netty.handler.ssl.PemX509Certificate;
import pro.gravit.repackage.io.netty.handler.ssl.ReferenceCountedOpenSslContext$1;
import pro.gravit.repackage.io.netty.handler.ssl.ReferenceCountedOpenSslContext$2;
import pro.gravit.repackage.io.netty.handler.ssl.ReferenceCountedOpenSslContext$AsyncPrivateKeyMethod;
import pro.gravit.repackage.io.netty.handler.ssl.ReferenceCountedOpenSslContext$CompressionAlgorithm;
import pro.gravit.repackage.io.netty.handler.ssl.ReferenceCountedOpenSslContext$DefaultOpenSslEngineMap;
import pro.gravit.repackage.io.netty.handler.ssl.ReferenceCountedOpenSslContext$PrivateKeyMethod;
import pro.gravit.repackage.io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import pro.gravit.repackage.io.netty.handler.ssl.ResumptionController;
import pro.gravit.repackage.io.netty.handler.ssl.SslContext;
import pro.gravit.repackage.io.netty.handler.ssl.SslContextOption;
import pro.gravit.repackage.io.netty.handler.ssl.SslHandler;
import pro.gravit.repackage.io.netty.handler.ssl.SslUtils;
import pro.gravit.repackage.io.netty.handler.ssl.util.LazyX509Certificate;
import pro.gravit.repackage.io.netty.internal.tcnative.AsyncSSLPrivateKeyMethod;
import pro.gravit.repackage.io.netty.internal.tcnative.CertificateCompressionAlgo;
import pro.gravit.repackage.io.netty.internal.tcnative.SSL;
import pro.gravit.repackage.io.netty.internal.tcnative.SSLContext;
import pro.gravit.repackage.io.netty.internal.tcnative.SSLPrivateKeyMethod;
import pro.gravit.repackage.io.netty.util.AbstractReferenceCounted;
import pro.gravit.repackage.io.netty.util.ReferenceCounted;
import pro.gravit.repackage.io.netty.util.ResourceLeakDetector;
import pro.gravit.repackage.io.netty.util.ResourceLeakDetectorFactory;
import pro.gravit.repackage.io.netty.util.ResourceLeakTracker;
import pro.gravit.repackage.io.netty.util.concurrent.ImmediateExecutor;
import pro.gravit.repackage.io.netty.util.internal.EmptyArrays;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;
import pro.gravit.repackage.io.netty.util.internal.StringUtil;
import pro.gravit.repackage.io.netty.util.internal.SuppressJava6Requirement;
import pro.gravit.repackage.io.netty.util.internal.SystemPropertyUtil;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;

public abstract class ReferenceCountedOpenSslContext
extends SslContext
implements ReferenceCounted {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ReferenceCountedOpenSslContext.class);
    private static final int DEFAULT_BIO_NON_APPLICATION_BUFFER_SIZE = Math.max(1, SystemPropertyUtil.getInt("pro.gravit.repackage.io.netty.handler.ssl.openssl.bioNonApplicationBufferSize", 2048));
    static final boolean USE_TASKS = SystemPropertyUtil.getBoolean("pro.gravit.repackage.io.netty.handler.ssl.openssl.useTasks", true);
    private static final Integer DH_KEY_LENGTH;
    private static final ResourceLeakDetector<ReferenceCountedOpenSslContext> leakDetector;
    protected static final int VERIFY_DEPTH = 10;
    static final boolean CLIENT_ENABLE_SESSION_TICKET;
    static final boolean CLIENT_ENABLE_SESSION_TICKET_TLSV13;
    static final boolean SERVER_ENABLE_SESSION_TICKET;
    static final boolean SERVER_ENABLE_SESSION_TICKET_TLSV13;
    static final boolean SERVER_ENABLE_SESSION_CACHE;
    static final boolean CLIENT_ENABLE_SESSION_CACHE;
    protected long ctx;
    private final List<String> unmodifiableCiphers;
    private final OpenSslApplicationProtocolNegotiator apn;
    private final int mode;
    private final ResourceLeakTracker<ReferenceCountedOpenSslContext> leak;
    private final AbstractReferenceCounted refCnt = new ReferenceCountedOpenSslContext$1(this);
    final Certificate[] keyCertChain;
    final ClientAuth clientAuth;
    final String[] protocols;
    final String endpointIdentificationAlgorithm;
    final boolean hasTLSv13Cipher;
    final boolean enableOcsp;
    final OpenSslEngineMap engineMap = new ReferenceCountedOpenSslContext$DefaultOpenSslEngineMap();
    final ReadWriteLock ctxLock = new ReentrantReadWriteLock();
    private volatile int bioNonApplicationBufferSize = DEFAULT_BIO_NON_APPLICATION_BUFFER_SIZE;
    static final OpenSslApplicationProtocolNegotiator NONE_PROTOCOL_NEGOTIATOR;
    final boolean tlsFalseStart;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReferenceCountedOpenSslContext(Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, OpenSslApplicationProtocolNegotiator openSslApplicationProtocolNegotiator, int n, Certificate[] certificateArray, ClientAuth clientAuth, String[] stringArray, boolean bl, String string, boolean bl2, boolean bl3, ResumptionController resumptionController, Map.Entry<SslContextOption<?>, Object> ... entryArray) {
        super(bl, resumptionController);
        Serializable serializable;
        OpenSsl.ensureAvailability();
        if (bl2 && !OpenSsl.isOcspSupported()) {
            throw new IllegalStateException("OCSP is not supported.");
        }
        if (n != 1 && n != 0) {
            throw new IllegalArgumentException("mode most be either SSL.SSL_MODE_SERVER or SSL.SSL_MODE_CLIENT");
        }
        boolean bl4 = false;
        boolean bl5 = USE_TASKS;
        OpenSslPrivateKeyMethod openSslPrivateKeyMethod = null;
        OpenSslAsyncPrivateKeyMethod openSslAsyncPrivateKeyMethod = null;
        OpenSslCertificateCompressionConfig openSslCertificateCompressionConfig = null;
        Integer n2 = null;
        Object[] objectArray = OpenSsl.NAMED_GROUPS;
        if (entryArray != null) {
            for (Map.Entry<SslContextOption<?>, Object> entry : entryArray) {
                SslContextOption<?> sslContextOption = entry.getKey();
                if (sslContextOption == OpenSslContextOption.TLS_FALSE_START) {
                    bl4 = (Boolean)entry.getValue();
                    continue;
                }
                if (sslContextOption == OpenSslContextOption.USE_TASKS) {
                    bl5 = (Boolean)entry.getValue();
                    continue;
                }
                if (sslContextOption == OpenSslContextOption.PRIVATE_KEY_METHOD) {
                    openSslPrivateKeyMethod = (OpenSslPrivateKeyMethod)entry.getValue();
                    continue;
                }
                if (sslContextOption == OpenSslContextOption.ASYNC_PRIVATE_KEY_METHOD) {
                    openSslAsyncPrivateKeyMethod = (OpenSslAsyncPrivateKeyMethod)entry.getValue();
                    continue;
                }
                if (sslContextOption == OpenSslContextOption.CERTIFICATE_COMPRESSION_ALGORITHMS) {
                    openSslCertificateCompressionConfig = (OpenSslCertificateCompressionConfig)entry.getValue();
                    continue;
                }
                if (sslContextOption == OpenSslContextOption.MAX_CERTIFICATE_LIST_BYTES) {
                    n2 = (Integer)entry.getValue();
                    continue;
                }
                if (sslContextOption == OpenSslContextOption.GROUPS) {
                    String[] stringArray2 = (String[])entry.getValue();
                    serializable = new LinkedHashSet<String>(stringArray2.length);
                    for (String string2 : stringArray2) {
                        serializable.add(GroupsConverter.toOpenSsl(string2));
                    }
                    objectArray = serializable.toArray(EmptyArrays.EMPTY_STRINGS);
                    continue;
                }
                logger.debug("Skipping unsupported " + SslContextOption.class.getSimpleName() + ": " + entry.getKey());
            }
        }
        if (openSslPrivateKeyMethod != null && openSslAsyncPrivateKeyMethod != null) {
            throw new IllegalArgumentException("You can either only use " + OpenSslAsyncPrivateKeyMethod.class.getSimpleName() + " or " + OpenSslPrivateKeyMethod.class.getSimpleName());
        }
        this.tlsFalseStart = bl4;
        this.leak = bl3 ? leakDetector.track(this) : null;
        this.mode = n;
        ClientAuth clientAuth2 = this.clientAuth = this.isServer() ? ObjectUtil.checkNotNull(clientAuth, "clientAuth") : ClientAuth.NONE;
        this.protocols = stringArray == null ? OpenSsl.defaultProtocols(n == 0) : stringArray;
        this.endpointIdentificationAlgorithm = string;
        this.enableOcsp = bl2;
        this.keyCertChain = certificateArray == null ? null : (Certificate[])certificateArray.clone();
        Object[] objectArray2 = ObjectUtil.checkNotNull(cipherSuiteFilter, "cipherFilter").filterCipherSuites(iterable, OpenSsl.DEFAULT_CIPHERS, OpenSsl.availableJavaCipherSuites());
        LinkedHashSet linkedHashSet = new LinkedHashSet(objectArray2.length);
        Collections.addAll(linkedHashSet, objectArray2);
        this.unmodifiableCiphers = new ArrayList<String>(linkedHashSet);
        this.apn = ObjectUtil.checkNotNull(openSslApplicationProtocolNegotiator, "apn");
        int n3 = 0;
        try {
            List<String> list;
            boolean bl6 = OpenSsl.isTlsv13Supported();
            boolean bl7 = false;
            try {
                int n4 = 30;
                if (bl6) {
                    n4 |= 0x20;
                }
                this.ctx = SSLContext.make((int)n4, (int)n);
            }
            catch (Exception exception) {
                throw new SSLException("failed to create an SSL_CTX", exception);
            }
            StringBuilder stringBuilder = new StringBuilder();
            serializable = new StringBuilder();
            try {
                if (this.unmodifiableCiphers.isEmpty()) {
                    SSLContext.setCipherSuite((long)this.ctx, (String)"", (boolean)false);
                    if (bl6) {
                        SSLContext.setCipherSuite((long)this.ctx, (String)"", (boolean)true);
                    }
                } else {
                    CipherSuiteConverter.convertToCipherStrings(this.unmodifiableCiphers, stringBuilder, serializable, OpenSsl.isBoringSSL());
                    SSLContext.setCipherSuite((long)this.ctx, (String)stringBuilder.toString(), (boolean)false);
                    if (bl6) {
                        String string3 = OpenSsl.checkTls13Ciphers(logger, ((StringBuilder)serializable).toString());
                        SSLContext.setCipherSuite((long)this.ctx, (String)string3, (boolean)true);
                        if (!string3.isEmpty()) {
                            bl7 = true;
                        }
                    }
                }
            }
            catch (SSLException sSLException) {
                throw sSLException;
            }
            catch (Exception exception) {
                throw new SSLException("failed to set cipher suite: " + this.unmodifiableCiphers, exception);
            }
            int n5 = SSLContext.getOptions((long)this.ctx) | SSL.SSL_OP_NO_SSLv2 | SSL.SSL_OP_NO_SSLv3 | SSL.SSL_OP_NO_TLSv1 | SSL.SSL_OP_NO_TLSv1_1 | SSL.SSL_OP_CIPHER_SERVER_PREFERENCE | SSL.SSL_OP_NO_COMPRESSION | SSL.SSL_OP_NO_TICKET;
            if (stringBuilder.length() == 0) {
                n5 |= SSL.SSL_OP_NO_SSLv2 | SSL.SSL_OP_NO_SSLv3 | SSL.SSL_OP_NO_TLSv1 | SSL.SSL_OP_NO_TLSv1_1 | SSL.SSL_OP_NO_TLSv1_2;
            }
            if (!bl6) {
                n5 |= SSL.SSL_OP_NO_TLSv1_3;
            }
            this.hasTLSv13Cipher = bl7;
            SSLContext.setOptions((long)this.ctx, (int)n5);
            SSLContext.setMode((long)this.ctx, (int)(SSLContext.getMode((long)this.ctx) | SSL.SSL_MODE_ACCEPT_MOVING_WRITE_BUFFER));
            if (DH_KEY_LENGTH != null) {
                SSLContext.setTmpDHLength((long)this.ctx, (int)DH_KEY_LENGTH);
            }
            if (!(list = openSslApplicationProtocolNegotiator.protocols()).isEmpty()) {
                String[] stringArray3 = list.toArray(EmptyArrays.EMPTY_STRINGS);
                int n6 = ReferenceCountedOpenSslContext.opensslSelectorFailureBehavior(openSslApplicationProtocolNegotiator.selectorFailureBehavior());
                switch (openSslApplicationProtocolNegotiator.protocol()) {
                    case NPN: {
                        SSLContext.setNpnProtos((long)this.ctx, (String[])stringArray3, (int)n6);
                        break;
                    }
                    case ALPN: {
                        SSLContext.setAlpnProtos((long)this.ctx, (String[])stringArray3, (int)n6);
                        break;
                    }
                    case NPN_AND_ALPN: {
                        SSLContext.setNpnProtos((long)this.ctx, (String[])stringArray3, (int)n6);
                        SSLContext.setAlpnProtos((long)this.ctx, (String[])stringArray3, (int)n6);
                        break;
                    }
                    default: {
                        throw new Error();
                    }
                }
            }
            if (bl2) {
                SSLContext.enableOcsp((long)this.ctx, (boolean)this.isClient());
            }
            SSLContext.setUseTasks((long)this.ctx, (boolean)bl5);
            if (openSslPrivateKeyMethod != null) {
                SSLContext.setPrivateKeyMethod((long)this.ctx, (SSLPrivateKeyMethod)new ReferenceCountedOpenSslContext$PrivateKeyMethod(this.engineMap, openSslPrivateKeyMethod));
            }
            if (openSslAsyncPrivateKeyMethod != null) {
                SSLContext.setPrivateKeyMethod((long)this.ctx, (AsyncSSLPrivateKeyMethod)new ReferenceCountedOpenSslContext$AsyncPrivateKeyMethod(this.engineMap, openSslAsyncPrivateKeyMethod));
            }
            if (openSslCertificateCompressionConfig != null) {
                block20: for (OpenSslCertificateCompressionConfig$AlgorithmConfig openSslCertificateCompressionConfig$AlgorithmConfig : openSslCertificateCompressionConfig) {
                    ReferenceCountedOpenSslContext$CompressionAlgorithm referenceCountedOpenSslContext$CompressionAlgorithm = new ReferenceCountedOpenSslContext$CompressionAlgorithm(this.engineMap, openSslCertificateCompressionConfig$AlgorithmConfig.algorithm());
                    switch (openSslCertificateCompressionConfig$AlgorithmConfig.mode()) {
                        case Decompress: {
                            SSLContext.addCertificateCompressionAlgorithm((long)this.ctx, (int)SSL.SSL_CERT_COMPRESSION_DIRECTION_DECOMPRESS, (CertificateCompressionAlgo)referenceCountedOpenSslContext$CompressionAlgorithm);
                            continue block20;
                        }
                        case Compress: {
                            SSLContext.addCertificateCompressionAlgorithm((long)this.ctx, (int)SSL.SSL_CERT_COMPRESSION_DIRECTION_COMPRESS, (CertificateCompressionAlgo)referenceCountedOpenSslContext$CompressionAlgorithm);
                            continue block20;
                        }
                        case Both: {
                            SSLContext.addCertificateCompressionAlgorithm((long)this.ctx, (int)SSL.SSL_CERT_COMPRESSION_DIRECTION_BOTH, (CertificateCompressionAlgo)referenceCountedOpenSslContext$CompressionAlgorithm);
                            continue block20;
                        }
                    }
                    throw new IllegalStateException();
                }
            }
            if (n2 != null) {
                SSLContext.setMaxCertList((long)this.ctx, (int)n2);
            }
            if (objectArray.length > 0 && !SSLContext.setCurvesList((long)this.ctx, (String[])objectArray)) {
                String string4 = "failed to set curves / groups suite: " + Arrays.toString(objectArray);
                int n7 = SSL.getLastErrorNumber();
                if (n7 != 0) {
                    string4 = string4 + ". " + SSL.getErrorString((long)n7);
                }
                throw new SSLException(string4);
            }
            n3 = 1;
        }
        finally {
            if (n3 == 0) {
                this.release();
            }
        }
    }

    private static int opensslSelectorFailureBehavior(ApplicationProtocolConfig$SelectorFailureBehavior applicationProtocolConfig$SelectorFailureBehavior) {
        switch (applicationProtocolConfig$SelectorFailureBehavior) {
            case NO_ADVERTISE: {
                return 0;
            }
            case CHOOSE_MY_LAST_PROTOCOL: {
                return 1;
            }
        }
        throw new Error();
    }

    @Override
    public final List<String> cipherSuites() {
        return this.unmodifiableCiphers;
    }

    @Override
    public ApplicationProtocolNegotiator applicationProtocolNegotiator() {
        return this.apn;
    }

    @Override
    public final boolean isClient() {
        return this.mode == 0;
    }

    @Override
    public final SSLEngine newEngine(ByteBufAllocator byteBufAllocator, String string, int n) {
        return this.newEngine0(byteBufAllocator, string, n, true);
    }

    @Override
    protected final SslHandler newHandler(ByteBufAllocator byteBufAllocator, boolean bl) {
        return new SslHandler(this.newEngine0(byteBufAllocator, null, -1, false), bl, ImmediateExecutor.INSTANCE, this.resumptionController);
    }

    @Override
    protected final SslHandler newHandler(ByteBufAllocator byteBufAllocator, String string, int n, boolean bl) {
        return new SslHandler(this.newEngine0(byteBufAllocator, string, n, false), bl, ImmediateExecutor.INSTANCE, this.resumptionController);
    }

    @Override
    protected SslHandler newHandler(ByteBufAllocator byteBufAllocator, boolean bl, Executor executor) {
        return new SslHandler(this.newEngine0(byteBufAllocator, null, -1, false), bl, executor, this.resumptionController);
    }

    @Override
    protected SslHandler newHandler(ByteBufAllocator byteBufAllocator, String string, int n, boolean bl, Executor executor) {
        return new SslHandler(this.newEngine0(byteBufAllocator, string, n, false), false, executor, this.resumptionController);
    }

    SSLEngine newEngine0(ByteBufAllocator byteBufAllocator, String string, int n, boolean bl) {
        return new ReferenceCountedOpenSslEngine(this, byteBufAllocator, string, n, bl, true, this.endpointIdentificationAlgorithm);
    }

    @Override
    public final SSLEngine newEngine(ByteBufAllocator byteBufAllocator) {
        return this.newEngine(byteBufAllocator, null, -1);
    }

    @Deprecated
    public final long context() {
        return this.sslCtxPointer();
    }

    @Deprecated
    public final OpenSslSessionStats stats() {
        return this.sessionContext().stats();
    }

    @Deprecated
    public void setRejectRemoteInitiatedRenegotiation(boolean bl) {
        if (!bl) {
            throw new UnsupportedOperationException("Renegotiation is not supported");
        }
    }

    @Deprecated
    public boolean getRejectRemoteInitiatedRenegotiation() {
        return true;
    }

    public void setBioNonApplicationBufferSize(int n) {
        this.bioNonApplicationBufferSize = ObjectUtil.checkPositiveOrZero(n, "bioNonApplicationBufferSize");
    }

    public int getBioNonApplicationBufferSize() {
        return this.bioNonApplicationBufferSize;
    }

    @Deprecated
    public final void setTicketKeys(byte[] byArray) {
        this.sessionContext().setTicketKeys(byArray);
    }

    @Override
    public abstract OpenSslSessionContext sessionContext();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public final long sslCtxPointer() {
        Lock lock = this.ctxLock.readLock();
        lock.lock();
        try {
            long l = SSLContext.getSslCtx((long)this.ctx);
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    @Deprecated
    public final void setPrivateKeyMethod(OpenSslPrivateKeyMethod openSslPrivateKeyMethod) {
        ObjectUtil.checkNotNull(openSslPrivateKeyMethod, "method");
        Lock lock = this.ctxLock.writeLock();
        lock.lock();
        try {
            SSLContext.setPrivateKeyMethod((long)this.ctx, (SSLPrivateKeyMethod)new ReferenceCountedOpenSslContext$PrivateKeyMethod(this.engineMap, openSslPrivateKeyMethod));
        }
        finally {
            lock.unlock();
        }
    }

    @Deprecated
    public final void setUseTasks(boolean bl) {
        Lock lock = this.ctxLock.writeLock();
        lock.lock();
        try {
            SSLContext.setUseTasks((long)this.ctx, (boolean)bl);
        }
        finally {
            lock.unlock();
        }
    }

    private void destroy() {
        Lock lock = this.ctxLock.writeLock();
        lock.lock();
        try {
            if (this.ctx != 0L) {
                if (this.enableOcsp) {
                    SSLContext.disableOcsp((long)this.ctx);
                }
                SSLContext.free((long)this.ctx);
                this.ctx = 0L;
                OpenSslSessionContext openSslSessionContext = this.sessionContext();
                if (openSslSessionContext != null) {
                    openSslSessionContext.destroy();
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    protected static X509Certificate[] certificates(byte[][] byArray) {
        X509Certificate[] x509CertificateArray = new X509Certificate[byArray.length];
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            x509CertificateArray[i] = new LazyX509Certificate(byArray[i]);
        }
        return x509CertificateArray;
    }

    @Deprecated
    protected static X509TrustManager chooseTrustManager(TrustManager[] trustManagerArray) {
        return ReferenceCountedOpenSslContext.chooseTrustManager(trustManagerArray, null);
    }

    static X509TrustManager chooseTrustManager(TrustManager[] trustManagerArray, ResumptionController resumptionController) {
        for (TrustManager trustManager : trustManagerArray) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            X509TrustManager x509TrustManager = (X509TrustManager)trustManager;
            if (PlatformDependent.javaVersion() >= 7) {
                if (resumptionController != null) {
                    x509TrustManager = (X509TrustManager)resumptionController.wrapIfNeeded(x509TrustManager);
                }
                if (ReferenceCountedOpenSslContext.useExtendedTrustManager(x509TrustManager = OpenSslX509TrustManagerWrapper.wrapIfNeeded(x509TrustManager))) {
                    x509TrustManager = new EnhancingX509ExtendedTrustManager(x509TrustManager);
                }
            }
            return x509TrustManager;
        }
        throw new IllegalStateException("no X509TrustManager found");
    }

    protected static X509KeyManager chooseX509KeyManager(KeyManager[] keyManagerArray) {
        for (KeyManager keyManager : keyManagerArray) {
            if (!(keyManager instanceof X509KeyManager)) continue;
            return (X509KeyManager)keyManager;
        }
        throw new IllegalStateException("no X509KeyManager found");
    }

    static OpenSslApplicationProtocolNegotiator toNegotiator(ApplicationProtocolConfig applicationProtocolConfig) {
        if (applicationProtocolConfig == null) {
            return NONE_PROTOCOL_NEGOTIATOR;
        }
        switch (applicationProtocolConfig.protocol()) {
            case NONE: {
                return NONE_PROTOCOL_NEGOTIATOR;
            }
            case NPN: 
            case ALPN: 
            case NPN_AND_ALPN: {
                switch (applicationProtocolConfig.selectedListenerFailureBehavior()) {
                    case CHOOSE_MY_LAST_PROTOCOL: 
                    case ACCEPT: {
                        switch (applicationProtocolConfig.selectorFailureBehavior()) {
                            case NO_ADVERTISE: 
                            case CHOOSE_MY_LAST_PROTOCOL: {
                                return new OpenSslDefaultApplicationProtocolNegotiator(applicationProtocolConfig);
                            }
                        }
                        throw new UnsupportedOperationException("OpenSSL provider does not support " + (Object)((Object)applicationProtocolConfig.selectorFailureBehavior()) + " behavior");
                    }
                }
                throw new UnsupportedOperationException("OpenSSL provider does not support " + (Object)((Object)applicationProtocolConfig.selectedListenerFailureBehavior()) + " behavior");
            }
        }
        throw new Error();
    }

    @SuppressJava6Requirement(reason="Guarded by java version check")
    static boolean useExtendedTrustManager(X509TrustManager x509TrustManager) {
        return PlatformDependent.javaVersion() >= 7 && x509TrustManager instanceof X509ExtendedTrustManager;
    }

    @Override
    public final int refCnt() {
        return this.refCnt.refCnt();
    }

    @Override
    public final ReferenceCounted retain() {
        this.refCnt.retain();
        return this;
    }

    @Override
    public final ReferenceCounted retain(int n) {
        this.refCnt.retain(n);
        return this;
    }

    @Override
    public final ReferenceCounted touch() {
        this.refCnt.touch();
        return this;
    }

    @Override
    public final ReferenceCounted touch(Object object) {
        this.refCnt.touch(object);
        return this;
    }

    @Override
    public final boolean release() {
        return this.refCnt.release();
    }

    @Override
    public final boolean release(int n) {
        return this.refCnt.release(n);
    }

    static void setKeyMaterial(long l, X509Certificate[] x509CertificateArray, PrivateKey privateKey, String string) {
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        PemEncoded pemEncoded = null;
        try {
            pemEncoded = PemX509Certificate.toPEM(ByteBufAllocator.DEFAULT, true, x509CertificateArray);
            l3 = ReferenceCountedOpenSslContext.toBIO(ByteBufAllocator.DEFAULT, pemEncoded.retain());
            l4 = ReferenceCountedOpenSslContext.toBIO(ByteBufAllocator.DEFAULT, pemEncoded.retain());
            if (privateKey != null) {
                l2 = ReferenceCountedOpenSslContext.toBIO(ByteBufAllocator.DEFAULT, privateKey);
            }
            SSLContext.setCertificateBio((long)l, (long)l3, (long)l2, (String)(string == null ? "" : string));
            SSLContext.setCertificateChainBio((long)l, (long)l4, (boolean)true);
        }
        catch (SSLException sSLException) {
            throw sSLException;
        }
        catch (Exception exception) {
            throw new SSLException("failed to set certificate and key", exception);
        }
        finally {
            ReferenceCountedOpenSslContext.freeBio(l2);
            ReferenceCountedOpenSslContext.freeBio(l3);
            ReferenceCountedOpenSslContext.freeBio(l4);
            if (pemEncoded != null) {
                pemEncoded.release();
            }
        }
    }

    static void freeBio(long l) {
        if (l != 0L) {
            SSL.freeBIO((long)l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long toBIO(ByteBufAllocator byteBufAllocator, PrivateKey privateKey) {
        if (privateKey == null) {
            return 0L;
        }
        PemEncoded pemEncoded = PemPrivateKey.toPEM(byteBufAllocator, true, privateKey);
        try {
            long l = ReferenceCountedOpenSslContext.toBIO(byteBufAllocator, pemEncoded.retain());
            return l;
        }
        finally {
            pemEncoded.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long toBIO(ByteBufAllocator byteBufAllocator, X509Certificate ... x509CertificateArray) {
        if (x509CertificateArray == null) {
            return 0L;
        }
        ObjectUtil.checkNonEmpty(x509CertificateArray, "certChain");
        PemEncoded pemEncoded = PemX509Certificate.toPEM(byteBufAllocator, true, x509CertificateArray);
        try {
            long l = ReferenceCountedOpenSslContext.toBIO(byteBufAllocator, pemEncoded.retain());
            return l;
        }
        finally {
            pemEncoded.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long toBIO(ByteBufAllocator byteBufAllocator, PemEncoded pemEncoded) {
        try {
            long l;
            ByteBuf byteBuf = pemEncoded.content();
            if (byteBuf.isDirect()) {
                long l2 = ReferenceCountedOpenSslContext.newBIO(byteBuf.retainedSlice());
                return l2;
            }
            ByteBuf byteBuf2 = byteBufAllocator.directBuffer(byteBuf.readableBytes());
            try {
                byteBuf2.writeBytes(byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes());
                l = ReferenceCountedOpenSslContext.newBIO(byteBuf2.retainedSlice());
            }
            catch (Throwable throwable) {
                try {
                    if (pemEncoded.isSensitive()) {
                        SslUtils.zeroout(byteBuf2);
                    }
                }
                finally {
                    byteBuf2.release();
                }
                throw throwable;
            }
            try {
                if (pemEncoded.isSensitive()) {
                    SslUtils.zeroout(byteBuf2);
                }
            }
            finally {
                byteBuf2.release();
            }
            return l;
        }
        finally {
            pemEncoded.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long newBIO(ByteBuf byteBuf) {
        try {
            long l = SSL.newMemBIO();
            int n = byteBuf.readableBytes();
            if (SSL.bioWrite((long)l, (long)(OpenSsl.memoryAddress(byteBuf) + (long)byteBuf.readerIndex()), (int)n) != n) {
                SSL.freeBIO((long)l);
                throw new IllegalStateException("Could not write data to memory BIO");
            }
            long l2 = l;
            return l2;
        }
        finally {
            byteBuf.release();
        }
    }

    static OpenSslKeyMaterialProvider providerFor(KeyManagerFactory keyManagerFactory, String string) {
        if (keyManagerFactory instanceof OpenSslX509KeyManagerFactory) {
            return ((OpenSslX509KeyManagerFactory)keyManagerFactory).newProvider();
        }
        if (keyManagerFactory instanceof OpenSslCachingX509KeyManagerFactory) {
            return ((OpenSslCachingX509KeyManagerFactory)keyManagerFactory).newProvider(string);
        }
        return new OpenSslKeyMaterialProvider(ReferenceCountedOpenSslContext.chooseX509KeyManager(keyManagerFactory.getKeyManagers()), string);
    }

    private static ReferenceCountedOpenSslEngine retrieveEngine(OpenSslEngineMap openSslEngineMap, long l) {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = openSslEngineMap.get(l);
        if (referenceCountedOpenSslEngine == null) {
            throw new SSLException("Could not find a " + StringUtil.simpleClassName(ReferenceCountedOpenSslEngine.class) + " for sslPointer " + l);
        }
        return referenceCountedOpenSslEngine;
    }

    private static byte[] verifyResult(byte[] byArray) {
        if (byArray == null) {
            throw new SignatureException();
        }
        return byArray;
    }

    static /* synthetic */ ResourceLeakTracker access$000(ReferenceCountedOpenSslContext referenceCountedOpenSslContext) {
        return referenceCountedOpenSslContext.leak;
    }

    static /* synthetic */ void access$100(ReferenceCountedOpenSslContext referenceCountedOpenSslContext) {
        referenceCountedOpenSslContext.destroy();
    }

    static /* synthetic */ InternalLogger access$300() {
        return logger;
    }

    static /* synthetic */ ReferenceCountedOpenSslEngine access$400(OpenSslEngineMap openSslEngineMap, long l) {
        return ReferenceCountedOpenSslContext.retrieveEngine(openSslEngineMap, l);
    }

    static /* synthetic */ byte[] access$500(byte[] byArray) {
        return ReferenceCountedOpenSslContext.verifyResult(byArray);
    }

    static {
        leakDetector = ResourceLeakDetectorFactory.instance().newResourceLeakDetector(ReferenceCountedOpenSslContext.class);
        CLIENT_ENABLE_SESSION_TICKET = SystemPropertyUtil.getBoolean("jdk.tls.client.enableSessionTicketExtension", false);
        CLIENT_ENABLE_SESSION_TICKET_TLSV13 = SystemPropertyUtil.getBoolean("jdk.tls.client.enableSessionTicketExtension", true);
        SERVER_ENABLE_SESSION_TICKET = SystemPropertyUtil.getBoolean("jdk.tls.server.enableSessionTicketExtension", false);
        SERVER_ENABLE_SESSION_TICKET_TLSV13 = SystemPropertyUtil.getBoolean("jdk.tls.server.enableSessionTicketExtension", true);
        SERVER_ENABLE_SESSION_CACHE = SystemPropertyUtil.getBoolean("pro.gravit.repackage.io.netty.handler.ssl.openssl.sessionCacheServer", true);
        CLIENT_ENABLE_SESSION_CACHE = SystemPropertyUtil.getBoolean("pro.gravit.repackage.io.netty.handler.ssl.openssl.sessionCacheClient", true);
        NONE_PROTOCOL_NEGOTIATOR = new ReferenceCountedOpenSslContext$2();
        Integer n = null;
        try {
            String string = SystemPropertyUtil.get("jdk.tls.ephemeralDHKeySize");
            if (string != null) {
                try {
                    n = Integer.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    logger.debug("ReferenceCountedOpenSslContext supports -Djdk.tls.ephemeralDHKeySize={int}, but got: " + string);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        DH_KEY_LENGTH = n;
    }
}

