/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.ssl;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import pro.gravit.repackage.io.netty.handler.ssl.JdkSslEngine;
import pro.gravit.repackage.io.netty.handler.ssl.ResumableX509ExtendedTrustManager;
import pro.gravit.repackage.io.netty.handler.ssl.ResumptionController$X509ExtendedWrapTrustManager;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;
import pro.gravit.repackage.io.netty.util.internal.SuppressJava6Requirement;

final class ResumptionController {
    private final Set<SSLEngine> confirmedValidations = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    private final AtomicReference<ResumableX509ExtendedTrustManager> resumableTm = new AtomicReference();

    ResumptionController() {
    }

    @SuppressJava6Requirement(reason="Guarded by version check")
    public TrustManager wrapIfNeeded(TrustManager trustManager) {
        if (trustManager instanceof ResumableX509ExtendedTrustManager) {
            if (PlatformDependent.javaVersion() < 7 || !(trustManager instanceof X509ExtendedTrustManager)) {
                throw new IllegalStateException("ResumableX509ExtendedTrustManager implementation must be a subclass of X509ExtendedTrustManager, found: " + (trustManager == null ? null : trustManager.getClass()));
            }
            if (!this.resumableTm.compareAndSet(null, (ResumableX509ExtendedTrustManager)trustManager)) {
                throw new IllegalStateException("Only one ResumableX509ExtendedTrustManager can be configured for resumed sessions");
            }
            return new ResumptionController$X509ExtendedWrapTrustManager((X509ExtendedTrustManager)trustManager, this.confirmedValidations);
        }
        return trustManager;
    }

    public void remove(SSLEngine sSLEngine) {
        if (this.resumableTm.get() != null) {
            this.confirmedValidations.remove(ResumptionController.unwrapEngine(sSLEngine));
        }
    }

    public boolean validateResumeIfNeeded(SSLEngine sSLEngine) {
        ResumableX509ExtendedTrustManager resumableX509ExtendedTrustManager;
        SSLSession sSLSession = sSLEngine.getSession();
        boolean bl = sSLSession.isValid();
        if (bl && (sSLEngine.getUseClientMode() || sSLEngine.getNeedClientAuth() || sSLEngine.getWantClientAuth()) && (resumableX509ExtendedTrustManager = this.resumableTm.get()) != null && !this.confirmedValidations.remove(sSLEngine = ResumptionController.unwrapEngine(sSLEngine))) {
            Certificate[] certificateArray;
            try {
                certificateArray = sSLSession.getPeerCertificates();
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                if (sSLEngine.getUseClientMode() || sSLEngine.getNeedClientAuth()) {
                    throw sSLPeerUnverifiedException;
                }
                return false;
            }
            if (sSLEngine.getUseClientMode()) {
                resumableX509ExtendedTrustManager.resumeServerTrusted(ResumptionController.chainOf(certificateArray), sSLEngine);
            } else {
                resumableX509ExtendedTrustManager.resumeClientTrusted(ResumptionController.chainOf(certificateArray), sSLEngine);
            }
            return true;
        }
        return false;
    }

    private static SSLEngine unwrapEngine(SSLEngine sSLEngine) {
        if (sSLEngine instanceof JdkSslEngine) {
            return ((JdkSslEngine)sSLEngine).getWrappedEngine();
        }
        return sSLEngine;
    }

    private static X509Certificate[] chainOf(Certificate[] certificateArray) {
        if (certificateArray instanceof X509Certificate[]) {
            return (X509Certificate[])certificateArray;
        }
        X509Certificate[] x509CertificateArray = new X509Certificate[certificateArray.length];
        for (int i = 0; i < certificateArray.length; ++i) {
            Certificate certificate = certificateArray[i];
            if (!(certificate instanceof X509Certificate) && certificate != null) {
                throw new IllegalArgumentException("Only X509Certificates are supported, found: " + certificate.getClass());
            }
            x509CertificateArray[i] = (X509Certificate)certificate;
        }
        return x509CertificateArray;
    }
}

